/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator;

import lombok.Generated;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.LockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcherFactory;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.subscriber.ScalingRegistrySubscriber;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.subscriber.SchemaMetaDataRegistrySubscriber;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.subscriber.ProcessRegistrySubscriber;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.service.ComputeNodeStatusService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.subscriber.ComputeNodeStatusSubscriber;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.service.StorageNodeStatusService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.subscriber.StorageNodeStatusSubscriber;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class RegistryCenter {
    private final ClusterPersistRepository repository;
    private final StorageNodeStatusService storageNodeStatusService;
    private final ComputeNodeStatusService computeNodeStatusService;
    private final LockRegistryService lockService;
    private final GovernanceWatcherFactory listenerFactory;

    public RegistryCenter(ClusterPersistRepository repository) {
        this.repository = repository;
        this.storageNodeStatusService = new StorageNodeStatusService(repository);
        this.computeNodeStatusService = new ComputeNodeStatusService(repository);
        this.lockService = new LockRegistryService(repository);
        this.listenerFactory = new GovernanceWatcherFactory(repository);
        this.createSubscribers(repository);
    }

    private void createSubscribers(ClusterPersistRepository repository) {
        new SchemaMetaDataRegistrySubscriber(repository);
        new ComputeNodeStatusSubscriber(repository);
        new StorageNodeStatusSubscriber(repository);
        new ScalingRegistrySubscriber(repository);
        new ProcessRegistrySubscriber(repository);
    }

    public void onlineInstance(InstanceDefinition instanceDefinition) {
        this.computeNodeStatusService.registerOnline(instanceDefinition);
        this.listenerFactory.watchListeners();
    }

    @Generated
    public ClusterPersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public StorageNodeStatusService getStorageNodeStatusService() {
        return this.storageNodeStatusService;
    }

    @Generated
    public ComputeNodeStatusService getComputeNodeStatusService() {
        return this.computeNodeStatusService;
    }

    @Generated
    public LockRegistryService getLockService() {
        return this.lockService;
    }
}

