/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.config.schema.impl.DataSourceProvidedSchemaConfiguration;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.definition.InstanceDefinition;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.ClusterContextManagerCoordinator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.DistributeLockContext;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.future.lock.service.GlobalLockRegistryService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.generator.ClusterWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryFactory;
import org.apache.shardingsphere.schedule.core.api.ModeScheduleContextFactory;
import org.apache.shardingsphere.transaction.config.TransactionRuleConfiguration;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.context.TransactionContextsBuilder;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGenerator;
import org.apache.shardingsphere.transaction.spi.TransactionConfigurationFileGeneratorFactory;

public final class ClusterContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        ModeScheduleContextFactory.getInstance().init(parameter.getInstanceDefinition().getInstanceId().getId(), parameter.getModeConfig());
        ClusterPersistRepository repository = ClusterPersistRepositoryFactory.newInstance((ClusterPersistRepositoryConfiguration)((ClusterPersistRepositoryConfiguration)parameter.getModeConfig().getRepository()), (InstanceDefinition)parameter.getInstanceDefinition());
        MetaDataPersistService metaDataPersistService = new MetaDataPersistService((PersistRepository)repository);
        this.persistConfigurations(metaDataPersistService, parameter);
        RegistryCenter registryCenter = new RegistryCenter(repository);
        MetaDataContextsBuilder metaDataContextsBuilder = this.createMetaDataContextsBuilder(metaDataPersistService, parameter);
        Map databaseMap = metaDataContextsBuilder.getDatabaseMap().isEmpty() ? Collections.emptyMap() : metaDataContextsBuilder.getDatabaseMap();
        this.persistMetaData(metaDataPersistService, databaseMap);
        MetaDataContexts metaDataContexts = metaDataContextsBuilder.build(metaDataPersistService);
        Properties transactionProps = this.getTransactionProperties(metaDataContexts);
        this.persistTransactionConfiguration(parameter, metaDataPersistService, transactionProps);
        ContextManager result = this.createContextManager(repository, metaDataPersistService, parameter.getInstanceDefinition(), metaDataContexts, transactionProps, parameter.getModeConfig());
        this.registerOnline(metaDataPersistService, parameter.getInstanceDefinition(), result, registryCenter);
        return result;
    }

    private void persistConfigurations(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        boolean isOverwrite = parameter.getModeConfig().isOverwrite();
        if (!parameter.isEmpty()) {
            metaDataPersistService.persistConfigurations(parameter.getSchemaConfigs(), parameter.getGlobalRuleConfigs(), parameter.getProps(), isOverwrite);
        }
        metaDataPersistService.persistInstanceLabels(parameter.getInstanceDefinition().getInstanceId().getId(), parameter.getLabels(), isOverwrite);
    }

    private Properties getTransactionProperties(MetaDataContexts metaDataContexts) {
        Optional fileGenerator;
        Optional schemaName = metaDataContexts.getAllSchemaNames().stream().findFirst();
        Optional<TransactionRule> transactionRule = metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        Optional optional = fileGenerator = transactionRule.isPresent() ? TransactionConfigurationFileGeneratorFactory.newInstance((String)transactionRule.get().getProviderType()) : Optional.empty();
        if (!schemaName.isPresent() || !fileGenerator.isPresent()) {
            return transactionRule.isPresent() ? transactionRule.get().getProps() : new Properties();
        }
        ShardingSphereMetaData metaData = metaDataContexts.getMetaData((String)schemaName.get());
        Properties result = ((TransactionConfigurationFileGenerator)fileGenerator.get()).getTransactionProps(transactionRule.get().getProps(), (SchemaConfiguration)new DataSourceProvidedSchemaConfiguration(metaData.getResource().getDataSources(), metaData.getRuleMetaData().getConfigurations()), this.getType());
        Optional transactionRuleConfig = metaDataContexts.getGlobalRuleMetaData().findSingleRuleConfiguration(TransactionRuleConfiguration.class);
        Preconditions.checkState((boolean)transactionRuleConfig.isPresent());
        ((TransactionRuleConfiguration)transactionRuleConfig.get()).getProps().clear();
        ((TransactionRuleConfiguration)transactionRuleConfig.get()).getProps().putAll((Map<?, ?>)result);
        transactionRule.get().getProps().clear();
        transactionRule.get().getProps().putAll((Map<?, ?>)result);
        return result;
    }

    private void persistTransactionConfiguration(ContextManagerBuilderParameter parameter, MetaDataPersistService metaDataPersistService, Properties transactionProps) {
        if (!transactionProps.isEmpty()) {
            metaDataPersistService.persistTransactionRule(transactionProps, true);
        }
        String instanceId = parameter.getInstanceDefinition().getInstanceId().getId();
        if (!metaDataPersistService.getComputeNodePersistService().loadXaRecoveryId(instanceId).isPresent()) {
            metaDataPersistService.getComputeNodePersistService().persistInstanceXaRecoveryId(instanceId, instanceId);
        }
    }

    private MetaDataContextsBuilder createMetaDataContextsBuilder(MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) throws SQLException {
        Collection<Object> schemaNames = InstanceType.JDBC == parameter.getInstanceDefinition().getInstanceType() ? parameter.getSchemaConfigs().keySet() : metaDataPersistService.getSchemaMetaDataService().loadAllNames();
        Collection globalRuleConfigs = metaDataPersistService.getGlobalRuleService().load();
        Properties props = metaDataPersistService.getPropsService().load();
        MetaDataContextsBuilder result = new MetaDataContextsBuilder(globalRuleConfigs, props);
        DatabaseType databaseType = DatabaseTypeFactory.getDatabaseType((Map)parameter.getSchemaConfigs(), (ConfigurationProperties)new ConfigurationProperties(parameter.getProps()));
        for (String string : schemaNames) {
            if (databaseType.getSystemSchemas().contains(string)) continue;
            result.addSchema(string, databaseType, this.createSchemaConfiguration(string, metaDataPersistService, parameter), props);
        }
        result.addSystemSchemas(databaseType);
        return result;
    }

    private SchemaConfiguration createSchemaConfiguration(String schemaName, MetaDataPersistService metaDataPersistService, ContextManagerBuilderParameter parameter) {
        Map dataSources = metaDataPersistService.getEffectiveDataSources(schemaName, parameter.getSchemaConfigs());
        Collection schemaRuleConfigs = metaDataPersistService.getSchemaRuleService().load(schemaName);
        return new DataSourceProvidedSchemaConfiguration(dataSources, schemaRuleConfigs);
    }

    private void persistMetaData(MetaDataPersistService metaDataPersistService, Map<String, ShardingSphereDatabase> databaseMap) {
        databaseMap.forEach((key, value) -> value.getSchemas().forEach((key1, value1) -> metaDataPersistService.getSchemaMetaDataService().persist(key, key1, value1)));
    }

    private ContextManager createContextManager(ClusterPersistRepository repository, MetaDataPersistService metaDataPersistService, InstanceDefinition instanceDefinition, MetaDataContexts metaDataContexts, Properties transactionProps, ModeConfiguration modeConfiguration) {
        ComputeNodeInstance computeNodeInstance = metaDataPersistService.getComputeNodePersistService().loadComputeNodeInstance(instanceDefinition);
        ClusterWorkerIdGenerator clusterWorkerIdGenerator = new ClusterWorkerIdGenerator(repository, metaDataPersistService, instanceDefinition);
        DistributeLockContext distributeLockContext = new DistributeLockContext(new GlobalLockRegistryService(repository));
        InstanceContext instanceContext = new InstanceContext(computeNodeInstance, (WorkerIdGenerator)clusterWorkerIdGenerator, modeConfiguration, (LockContext)distributeLockContext);
        distributeLockContext.synchronizeGlobalLock(instanceContext);
        this.generateTransactionConfigurationFile(instanceContext, metaDataContexts, transactionProps);
        TransactionContexts transactionContexts = new TransactionContextsBuilder(metaDataContexts.getMetaDataMap(), metaDataContexts.getGlobalRuleMetaData().getRules()).build();
        ContextManager result = new ContextManager();
        result.init(metaDataContexts, transactionContexts, instanceContext);
        return result;
    }

    private void generateTransactionConfigurationFile(InstanceContext instanceContext, MetaDataContexts metaDataContexts, Properties transactionProps) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        if (transactionRule.isPresent()) {
            Optional fileGenerator = TransactionConfigurationFileGeneratorFactory.newInstance((String)transactionRule.get().getProviderType());
            fileGenerator.ifPresent(optional -> optional.generateFile(transactionProps, instanceContext));
        }
    }

    private void registerOnline(MetaDataPersistService metaDataPersistService, InstanceDefinition instanceDefinition, ContextManager contextManager, RegistryCenter registryCenter) {
        new ClusterContextManagerCoordinator(metaDataPersistService, contextManager, registryCenter);
        registryCenter.onlineInstance(instanceDefinition);
        contextManager.getInstanceContext().getComputeNodeInstances().addAll(metaDataPersistService.getComputeNodePersistService().loadAllComputeNodeInstances());
    }

    public String getType() {
        return "Cluster";
    }
}

