/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.connection.dialect;

import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import lombok.Generated;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;

public final class MySQLXAConnectionWrapper
implements XAConnectionWrapper {
    private static final String MYSQL_XA_DATASOURCE_5 = "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource";
    private static final String MYSQL_XA_DATASOURCE_8 = "com.mysql.cj.jdbc.MysqlXADataSource";

    @Override
    public XAConnection wrap(XADataSource xaDataSource, Connection connection) {
        Connection physicalConnection = this.unwrapPhysicalConnection(xaDataSource.getClass().getName(), connection);
        Method method = xaDataSource.getClass().getDeclaredMethod("wrapConnection", Connection.class);
        method.setAccessible(true);
        return (XAConnection)method.invoke((Object)xaDataSource, physicalConnection);
    }

    private Connection unwrapPhysicalConnection(String xaDataSourceClassName, Connection connection) {
        switch (xaDataSourceClassName) {
            case "com.mysql.jdbc.jdbc2.optional.MysqlXADataSource": {
                return (Connection)connection.unwrap(Class.forName("com.mysql.jdbc.Connection"));
            }
            case "com.mysql.cj.jdbc.MysqlXADataSource": {
                return (Connection)connection.unwrap(Class.forName("com.mysql.cj.jdbc.JdbcConnection"));
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support xa datasource: `%s`", xaDataSourceClassName));
    }

    @Generated
    public MySQLXAConnectionWrapper() {
    }
}

