/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.connection;

import java.sql.Connection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import lombok.Generated;
import org.apache.shardingsphere.spi.database.type.DatabaseType;
import org.apache.shardingsphere.transaction.xa.jta.connection.dialect.H2XAConnectionWrapper;
import org.apache.shardingsphere.transaction.xa.jta.connection.dialect.MariaDBXAConnectionWrapper;
import org.apache.shardingsphere.transaction.xa.jta.connection.dialect.MySQLXAConnectionWrapper;
import org.apache.shardingsphere.transaction.xa.jta.connection.dialect.PostgreSQLXAConnectionWrapper;

public final class XAConnectionFactory {
    public static XAConnection createXAConnection(DatabaseType databaseType, XADataSource xaDataSource, Connection connection) {
        switch (databaseType.getName()) {
            case "MySQL": {
                return new MySQLXAConnectionWrapper().wrap(xaDataSource, connection);
            }
            case "MariaDB": {
                return new MariaDBXAConnectionWrapper().wrap(xaDataSource, connection);
            }
            case "PostgreSQL": {
                return new PostgreSQLXAConnectionWrapper().wrap(xaDataSource, connection);
            }
            case "H2": {
                return new H2XAConnectionWrapper().wrap(xaDataSource, connection);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type: `%s`", databaseType));
    }

    @Generated
    private XAConnectionFactory() {
    }
}

