/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.token;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShadowRule;
import org.apache.shardingsphere.shadow.rewrite.aware.ShadowRuleAware;
import org.apache.shardingsphere.shadow.rewrite.token.generator.impl.RemoveShadowColumnTokenGenerator;
import org.apache.shardingsphere.shadow.rewrite.token.generator.impl.ShadowInsertValuesTokenGenerator;
import org.apache.shardingsphere.shadow.rewrite.token.generator.impl.ShadowPredicateColumnTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.builder.SQLTokenGeneratorBuilder;

public final class ShadowTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final ShadowRule shadowRule;

    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        Collection<SQLTokenGenerator> result = this.buildSQLTokenGenerators();
        for (SQLTokenGenerator each : result) {
            ((ShadowRuleAware)each).setShadowRule(this.shadowRule);
        }
        return result;
    }

    private Collection<SQLTokenGenerator> buildSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        result.add(new ShadowInsertValuesTokenGenerator());
        result.add(new RemoveShadowColumnTokenGenerator());
        result.add(new ShadowPredicateColumnTokenGenerator());
        return result;
    }

    @Generated
    public ShadowTokenGenerateBuilder(ShadowRule shadowRule) {
        this.shadowRule = shadowRule;
    }
}

