/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.parameter.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.shardingsphere.shadow.rewrite.parameter.ShadowParameterRewriter;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.StandardParameterBuilder;

public final class ShadowInsertValueParameterRewriter
extends ShadowParameterRewriter<InsertStatementContext> {
    @Override
    protected boolean isNeedRewriteForShadow(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getColumnNames().contains(this.getShadowRule().getColumn());
    }

    public void rewrite(ParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, List<Object> parameters) {
        String columnName = this.getShadowRule().getColumn();
        int columnIndex = this.getColumnIndex((GroupedParameterBuilder)parameterBuilder, insertStatementContext, columnName);
        int count = 0;
        for (List each : insertStatementContext.getGroupedParameters()) {
            if (!each.isEmpty()) {
                StandardParameterBuilder standardParameterBuilder = (StandardParameterBuilder)((GroupedParameterBuilder)parameterBuilder).getParameterBuilders().get(count);
                standardParameterBuilder.addRemovedParameters(columnIndex);
            }
            ++count;
        }
    }

    private int getColumnIndex(GroupedParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, String shadowColumnName) {
        ArrayList columnNames;
        if (parameterBuilder.getDerivedColumnName().isPresent()) {
            columnNames = new ArrayList(insertStatementContext.getColumnNames());
            columnNames.remove(parameterBuilder.getDerivedColumnName().get());
        } else {
            columnNames = insertStatementContext.getColumnNames();
        }
        return columnNames.indexOf(shadowColumnName);
    }
}

