/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.judgement.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShadowRule;
import org.apache.shardingsphere.shadow.rewrite.judgement.ShadowJudgementEngine;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;

public final class PreparedJudgementEngine
implements ShadowJudgementEngine {
    private final ShadowRule shadowRule;
    private final SQLStatementContext sqlStatementContext;
    private final List<Object> parameters;

    @Override
    public boolean isShadowSQL() {
        if (this.sqlStatementContext instanceof InsertStatementContext) {
            Collection columnSegments = ((InsertStatement)((InsertStatementContext)this.sqlStatementContext).getSqlStatement()).getColumns();
            int count = 0;
            for (ColumnSegment each : columnSegments) {
                if (each.getIdentifier().getValue().equals(this.shadowRule.getColumn())) {
                    Object value = this.parameters.get(count);
                    return value instanceof Boolean && (Boolean)value != false;
                }
                ++count;
            }
            return false;
        }
        if (this.sqlStatementContext instanceof WhereAvailable) {
            Optional whereSegment = ((WhereAvailable)this.sqlStatementContext).getWhere();
            if (!whereSegment.isPresent()) {
                return false;
            }
            Collection andPredicates = ((WhereSegment)whereSegment.get()).getAndPredicates();
            for (AndPredicate andPredicate : andPredicates) {
                if (!this.judgePredicateSegments(andPredicate.getPredicates())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean judgePredicateSegments(Collection<PredicateSegment> predicates) {
        for (PredicateSegment each : predicates) {
            if (!each.getColumn().getIdentifier().getValue().equals(this.shadowRule.getColumn())) continue;
            Preconditions.checkArgument((boolean)(each.getRightValue() instanceof PredicateCompareRightValue), (Object)"must be PredicateCompareRightValue");
            PredicateCompareRightValue rightValue = (PredicateCompareRightValue)each.getRightValue();
            int parameterMarkerIndex = ((ParameterMarkerExpressionSegment)rightValue.getExpression()).getParameterMarkerIndex();
            Object value = this.parameters.get(parameterMarkerIndex);
            return value instanceof Boolean && (Boolean)value != false;
        }
        return false;
    }

    @Generated
    public PreparedJudgementEngine(ShadowRule shadowRule, SQLStatementContext sqlStatementContext, List<Object> parameters) {
        this.shadowRule = shadowRule;
        this.sqlStatementContext = sqlStatementContext;
        this.parameters = parameters;
    }
}

