/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.condition;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShadowRule;
import org.apache.shardingsphere.shadow.rewrite.condition.ShadowCondition;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateBetweenRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateInRightValue;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class ShadowConditionEngine {
    private final ShadowRule shadowRule;

    public Optional<ShadowCondition> createShadowCondition(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Optional.empty();
        }
        Optional whereSegment = ((WhereAvailable)sqlStatementContext).getWhere();
        if (!whereSegment.isPresent()) {
            return Optional.empty();
        }
        for (AndPredicate each : ((WhereSegment)whereSegment.get()).getAndPredicates()) {
            Optional<ShadowCondition> condition = this.createShadowCondition(each);
            if (!condition.isPresent()) continue;
            return condition;
        }
        return Optional.empty();
    }

    private Optional<ShadowCondition> createShadowCondition(AndPredicate andPredicate) {
        Iterator iterator = andPredicate.getPredicates().iterator();
        while (iterator.hasNext()) {
            Optional<ShadowCondition> condition;
            HashSet<Integer> stopIndexes = new HashSet<Integer>();
            PredicateSegment predicate = (PredicateSegment)iterator.next();
            if (!stopIndexes.add(predicate.getStopIndex()) || !(condition = this.shadowRule.getColumn().equals(predicate.getColumn().getIdentifier().getValue()) ? this.createShadowCondition(predicate) : Optional.empty()).isPresent()) continue;
            return condition;
        }
        return Optional.empty();
    }

    private Optional<ShadowCondition> createShadowCondition(PredicateSegment predicateSegment) {
        if (predicateSegment.getRightValue() instanceof PredicateCompareRightValue) {
            PredicateCompareRightValue compareRightValue = (PredicateCompareRightValue)predicateSegment.getRightValue();
            return this.isSupportedOperator(compareRightValue.getOperator()) ? ShadowConditionEngine.createCompareShadowCondition(predicateSegment, compareRightValue) : Optional.empty();
        }
        if (predicateSegment.getRightValue() instanceof PredicateInRightValue) {
            throw new ShardingSphereException("The SQL clause 'IN...' is unsupported in shadow rule.", new Object[0]);
        }
        if (predicateSegment.getRightValue() instanceof PredicateBetweenRightValue) {
            throw new ShardingSphereException("The SQL clause 'BETWEEN...AND...' is unsupported in shadow rule.", new Object[0]);
        }
        return Optional.empty();
    }

    private static Optional<ShadowCondition> createCompareShadowCondition(PredicateSegment predicateSegment, PredicateCompareRightValue compareRightValue) {
        return compareRightValue.getExpression() instanceof SimpleExpressionSegment ? Optional.of(new ShadowCondition(predicateSegment.getColumn().getIdentifier().getValue(), compareRightValue.getExpression().getStartIndex(), predicateSegment.getStopIndex(), compareRightValue.getExpression())) : Optional.empty();
    }

    private boolean isSupportedOperator(String operator) {
        return "=".equals(operator);
    }

    @Generated
    public ShadowConditionEngine(ShadowRule shadowRule) {
        this.shadowRule = shadowRule;
    }
}

