/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.strategy;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.api.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.strategy.EncryptColumn;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class EncryptTable {
    private final Map<String, EncryptColumn> columns;

    public EncryptTable(EncryptTableRuleConfiguration config) {
        this.columns = new LinkedHashMap<String, EncryptColumn>(new LinkedHashMap(Maps.transformValues((Map)config.getColumns(), input -> new EncryptColumn(input.getCipherColumn(), input.getAssistedQueryColumn(), input.getPlainColumn(), input.getEncryptor()))));
    }

    public String getLogicColumnOfCipher(String cipherColumn) {
        for (Map.Entry<String, EncryptColumn> entry : this.columns.entrySet()) {
            if (!entry.getValue().getCipherColumn().equals(cipherColumn)) continue;
            return entry.getKey();
        }
        throw new ShardingSphereException("Can not find logic column by %s.", new Object[]{cipherColumn});
    }

    public Collection<String> getLogicColumns() {
        return this.columns.keySet();
    }

    public Optional<String> findPlainColumn(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? this.columns.get(logicColumn).getPlainColumn() : Optional.empty();
    }

    public Collection<String> getPlainColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (EncryptColumn each : this.columns.values()) {
            if (!each.getPlainColumn().isPresent()) continue;
            result.add(each.getPlainColumn().get());
        }
        return result;
    }

    public String getCipherColumn(String logicColumn) {
        return this.columns.get(logicColumn).getCipherColumn();
    }

    public Collection<String> getCipherColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (EncryptColumn each : this.columns.values()) {
            result.add(each.getCipherColumn());
        }
        return result;
    }

    public Optional<String> findAssistedQueryColumn(String logicColumn) {
        return this.columns.containsKey(logicColumn) ? this.columns.get(logicColumn).getAssistedQueryColumn() : Optional.empty();
    }

    public Collection<String> getAssistedQueryColumns() {
        LinkedList<String> result = new LinkedList<String>();
        for (EncryptColumn each : this.columns.values()) {
            if (!each.getAssistedQueryColumn().isPresent()) continue;
            result.add(each.getAssistedQueryColumn().get());
        }
        return result;
    }

    public Optional<String> findEncryptor(String logicColumn) {
        Optional<String> originLogicColumnName = this.findOriginLogicColumnName(logicColumn);
        return originLogicColumnName.isPresent() && this.columns.containsKey(originLogicColumnName.get()) ? Optional.of(this.columns.get(originLogicColumnName.get()).getEncryptor()) : Optional.empty();
    }

    private Optional<String> findOriginLogicColumnName(String logicColumn) {
        for (String each : this.columns.keySet()) {
            if (!logicColumn.equalsIgnoreCase(each)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Map<String, String> getLogicAndCipherColumns() {
        return Maps.transformValues(this.columns, EncryptColumn::getCipherColumn);
    }

    public Map<String, String> getLogicAndPlainColumns() {
        return Maps.transformValues(this.columns, input -> {
            if (input.getPlainColumn().isPresent()) {
                return input.getPlainColumn().get();
            }
            throw new ShardingSphereException("Plain column is null.", new Object[0]);
        });
    }
}

