/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationQueryer;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default")
@Singleton
public class DefaultArchetypeGenerationQueryer
implements ArchetypeGenerationQueryer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArchetypeGenerationQueryer.class);
    @Inject
    private Prompter prompter;

    @Override
    public boolean confirmConfiguration(ArchetypeConfiguration archetypeConfiguration) throws PrompterException {
        StringBuilder query = new StringBuilder("Confirm properties configuration:\n");
        for (String property : archetypeConfiguration.getRequiredProperties()) {
            query.append(property + ": " + archetypeConfiguration.getProperty(property) + "\n");
        }
        String answer = this.prompter.prompt(query.toString(), "Y");
        return "Y".equalsIgnoreCase(answer);
    }

    @Override
    public String getPropertyValue(String requiredProperty, String defaultValue, Pattern validationRegex) throws PrompterException {
        String answer;
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("Define value for property '");
        queryBuilder.append(requiredProperty);
        queryBuilder.append('\'');
        if (validationRegex != null) {
            queryBuilder.append(" (should match expression '");
            queryBuilder.append(validationRegex);
            queryBuilder.append("')");
        }
        String query = queryBuilder.toString();
        boolean validAnswer = false;
        do {
            answer = defaultValue != null && !defaultValue.equals("null") ? this.prompter.prompt(query, defaultValue) : this.prompter.prompt(query);
            if (validationRegex == null || validationRegex.matcher(answer).matches()) {
                validAnswer = true;
                continue;
            }
            query = "Value does not match the expression, please try again";
        } while (!validAnswer);
        return answer;
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }
}

