/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.ArchetypeGenerationConfigurationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.ArchetypeFactory;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationConfigurator;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationQueryer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.ASTNegateNode;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.parser.node.StandardParserVisitor;
import org.apache.velocity.runtime.visitor.BaseVisitor;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default")
@Singleton
public class DefaultArchetypeGenerationConfigurator
implements ArchetypeGenerationConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArchetypeGenerationConfigurator.class);
    private ArchetypeArtifactManager archetypeArtifactManager;
    private ArchetypeFactory archetypeFactory;
    private ArchetypeGenerationQueryer archetypeGenerationQueryer;
    private VelocityComponent velocity;
    private RepositorySystem repositorySystem;

    @Inject
    public DefaultArchetypeGenerationConfigurator(ArchetypeArtifactManager archetypeArtifactManager, ArchetypeFactory archetypeFactory, ArchetypeGenerationQueryer archetypeGenerationQueryer, VelocityComponent velocity, RepositorySystem repositorySystem) {
        this.archetypeArtifactManager = archetypeArtifactManager;
        this.archetypeFactory = archetypeFactory;
        this.archetypeGenerationQueryer = archetypeGenerationQueryer;
        this.velocity = velocity;
        this.repositorySystem = repositorySystem;
    }

    public void setArchetypeArtifactManager(ArchetypeArtifactManager archetypeArtifactManager) {
        this.archetypeArtifactManager = archetypeArtifactManager;
    }

    @Override
    public void configureArchetype(ArchetypeGenerationRequest request, Boolean interactiveMode, Properties executionProperties) throws ArchetypeNotDefined, UnknownArchetype, ArchetypeNotConfigured, PrompterException, ArchetypeGenerationConfigurationFailure {
        ArchetypeConfiguration archetypeConfiguration;
        org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor;
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        Properties properties = new Properties(executionProperties);
        ArchetypeDefinition ad = new ArchetypeDefinition(request);
        if (!ad.isDefined()) {
            if (!interactiveMode.booleanValue()) {
                throw new ArchetypeNotDefined("No archetype was chosen");
            }
            throw new ArchetypeNotDefined("The archetype is not defined");
        }
        if (request.getArchetypeRepository() != null) {
            RepositorySystemSession repositorySession = request.getRepositorySession();
            RemoteRepository archetypeRepository = this.createRepository(repositorySession, request.getArchetypeRepository(), ad.getArtifactId() + "-repo");
            repositories.add(archetypeRepository);
        }
        if (request.getRemoteRepositories() != null) {
            repositories.addAll(request.getRemoteRepositories());
        }
        if (!this.archetypeArtifactManager.exists(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), repositories, request.getRepositorySession())) {
            throw new UnknownArchetype("The desired archetype does not exist (" + ad.getGroupId() + ":" + ad.getArtifactId() + ":" + ad.getVersion() + ")");
        }
        request.setArchetypeVersion(ad.getVersion());
        File archetypeFile = this.archetypeArtifactManager.getArchetypeFile(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), repositories, request.getRepositorySession());
        if (this.archetypeArtifactManager.isFileSetArchetype(archetypeFile)) {
            archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(archetypeFile);
            archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration(archetypeDescriptor, properties);
        } else if (this.archetypeArtifactManager.isOldArchetype(archetypeFile)) {
            archetypeDescriptor = this.archetypeArtifactManager.getOldArchetypeDescriptor(archetypeFile);
            archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration((ArchetypeDescriptor)archetypeDescriptor, properties);
        } else {
            throw new ArchetypeGenerationConfigurationFailure("The defined artifact is not an archetype: " + archetypeFile);
        }
        List<String> propertiesRequired = archetypeConfiguration.getRequiredProperties();
        Collections.sort(propertiesRequired, new RequiredPropertyComparator(archetypeConfiguration));
        VelocityContext context = new VelocityContext();
        if (interactiveMode.booleanValue()) {
            boolean confirmed = false;
            context.put("groupId", (Object)ad.getGroupId());
            context.put("artifactId", (Object)ad.getArtifactId());
            context.put("version", (Object)ad.getVersion());
            while (!confirmed) {
                if (archetypeConfiguration.isConfigured()) {
                    for (String requiredProperty : propertiesRequired) {
                        LOGGER.info("Using property: " + requiredProperty + " = " + archetypeConfiguration.getProperty(requiredProperty));
                    }
                } else {
                    for (String requiredProperty : propertiesRequired) {
                        String value;
                        if (archetypeConfiguration.isConfigured(requiredProperty) && !request.isAskForDefaultPropertyValues()) {
                            LOGGER.info("Using property: " + requiredProperty + " = " + archetypeConfiguration.getProperty(requiredProperty));
                            value = archetypeConfiguration.getProperty(requiredProperty);
                        } else {
                            String defaultValue = archetypeConfiguration.getDefaultValue(requiredProperty);
                            if ("package".equals(requiredProperty) && (defaultValue == null || defaultValue.isEmpty())) {
                                defaultValue = archetypeConfiguration.getProperty("groupId");
                            }
                            value = this.archetypeGenerationQueryer.getPropertyValue(requiredProperty, this.expandEmbeddedTemplateExpressions(defaultValue, requiredProperty, (Context)context), archetypeConfiguration.getPropertyValidationRegex(requiredProperty));
                        }
                        archetypeConfiguration.setProperty(requiredProperty, value);
                        context.put(requiredProperty, (Object)value);
                    }
                }
                if (!archetypeConfiguration.isConfigured()) {
                    LOGGER.warn("Archetype is not fully configured");
                    continue;
                }
                if (!this.archetypeGenerationQueryer.confirmConfiguration(archetypeConfiguration)) {
                    LOGGER.debug("Archetype generation configuration not confirmed");
                    archetypeConfiguration.reset();
                    this.restoreCommandLineProperties(archetypeConfiguration, executionProperties);
                    continue;
                }
                LOGGER.debug("Archetype generation configuration confirmed");
                confirmed = true;
            }
        } else if (!archetypeConfiguration.isConfigured()) {
            for (String requiredProperty : propertiesRequired) {
                if (archetypeConfiguration.isConfigured(requiredProperty)) {
                    context.put(requiredProperty, (Object)archetypeConfiguration.getProperty(requiredProperty));
                    continue;
                }
                String defaultValue = archetypeConfiguration.getDefaultValue(requiredProperty);
                if (defaultValue == null) continue;
                String value = this.expandEmbeddedTemplateExpressions(defaultValue, requiredProperty, (Context)context);
                archetypeConfiguration.setProperty(requiredProperty, value);
                context.put(requiredProperty, (Object)value);
            }
            if (!archetypeConfiguration.isConfigured()) {
                StringBuilder exceptionMessage = new StringBuilder();
                exceptionMessage.append("Archetype ");
                exceptionMessage.append(request.getArchetypeGroupId());
                exceptionMessage.append(":");
                exceptionMessage.append(request.getArchetypeArtifactId());
                exceptionMessage.append(":");
                exceptionMessage.append(request.getArchetypeVersion());
                exceptionMessage.append(" is not configured");
                ArrayList<String> missingProperties = new ArrayList<String>(0);
                for (String requiredProperty : archetypeConfiguration.getRequiredProperties()) {
                    if (archetypeConfiguration.isConfigured(requiredProperty)) continue;
                    exceptionMessage.append("\n\tProperty ");
                    exceptionMessage.append(requiredProperty);
                    missingProperties.add(requiredProperty);
                    exceptionMessage.append(" is missing.");
                    LOGGER.warn("Property " + requiredProperty + " is missing. Add -D" + requiredProperty + "=someValue");
                }
                throw new ArchetypeNotConfigured(exceptionMessage.toString(), missingProperties);
            }
        }
        request.setGroupId(archetypeConfiguration.getProperty("groupId"));
        request.setArtifactId(archetypeConfiguration.getProperty("artifactId"));
        request.setVersion(archetypeConfiguration.getProperty("version"));
        request.setPackage(archetypeConfiguration.getProperty("package"));
        properties = archetypeConfiguration.getProperties();
        request.setProperties(properties);
    }

    private String expandEmbeddedTemplateExpressions(String originalText, String textDescription, Context context) {
        if (StringUtils.contains((String)originalText, (String)"${")) {
            String string;
            StringWriter target = new StringWriter();
            try {
                this.velocity.getEngine().evaluate(context, (Writer)target, textDescription, originalText);
                string = target.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        target.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Exception closing StringWriter", ex);
                }
            }
            target.close();
            return string;
        }
        return originalText;
    }

    private void restoreCommandLineProperties(ArchetypeConfiguration archetypeConfiguration, Properties executionProperties) {
        LOGGER.debug("Restoring command line properties");
        for (String property : archetypeConfiguration.getRequiredProperties()) {
            if (!executionProperties.containsKey(property)) continue;
            archetypeConfiguration.setProperty(property, executionProperties.getProperty(property));
            LOGGER.debug("Restored " + property + "=" + archetypeConfiguration.getProperty(property));
        }
    }

    void setArchetypeGenerationQueryer(ArchetypeGenerationQueryer archetypeGenerationQueryer) {
        this.archetypeGenerationQueryer = archetypeGenerationQueryer;
    }

    private RemoteRepository createRepository(RepositorySystemSession repositorySession, String url, String repositoryId) {
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy(true, "always", "warn");
        RemoteRepository remoteRepository = new RemoteRepository.Builder(repositoryId, "default", url).setSnapshotPolicy(repositoryPolicy).setReleasePolicy(repositoryPolicy).build();
        return (RemoteRepository)this.repositorySystem.newResolutionRepositories(repositorySession, Collections.singletonList(remoteRepository)).get(0);
    }

    public static class RequiredPropertyComparator
    implements Comparator<String> {
        private final ArchetypeConfiguration archetypeConfiguration;
        private Map<String, Set<String>> propertyReferenceMap;

        public RequiredPropertyComparator(ArchetypeConfiguration archetypeConfiguration) {
            this.archetypeConfiguration = archetypeConfiguration;
            this.propertyReferenceMap = this.computePropertyReferences();
        }

        @Override
        public int compare(String left, String right) {
            if (this.references(right, left)) {
                return 1;
            }
            if (this.references(left, right)) {
                return -1;
            }
            return Integer.compare(this.propertyReferenceMap.get(left).size(), this.propertyReferenceMap.get(right).size());
        }

        private Map<String, Set<String>> computePropertyReferences() {
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            List<String> requiredProperties = this.archetypeConfiguration.getRequiredProperties();
            InternalContextAdapterImpl velocityContextAdapter = new InternalContextAdapterImpl((Context)new VelocityContext());
            RuntimeInstance velocityRuntime = new RuntimeInstance();
            Properties properties = new Properties();
            properties.put("parser.allow_hyphen_in_identifiers", (Object)true);
            velocityRuntime.setProperties(properties);
            for (String propertyName : requiredProperties) {
                final LinkedHashSet referencedPropertyNames = new LinkedHashSet();
                String defaultValue = this.archetypeConfiguration.getDefaultValue(propertyName);
                if (StringUtils.contains((String)defaultValue, (String)"${")) {
                    try {
                        Template template = new Template();
                        template.setName(propertyName + ".default");
                        SimpleNode node = velocityRuntime.parse((Reader)new StringReader(defaultValue), template);
                        node.init((InternalContextAdapter)velocityContextAdapter, (Object)velocityRuntime);
                        node.jjtAccept((StandardParserVisitor)new BaseVisitor(){

                            public Object visit(ASTReference node, Object data) {
                                referencedPropertyNames.add(node.getRootString());
                                return super.visit(node, data);
                            }

                            public Object visit(ASTNegateNode astNegateNode, Object data) {
                                return astNegateNode.childrenAccept((StandardParserVisitor)this, data);
                            }
                        }, (Object)velocityRuntime);
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException("Unparsable default value for property " + propertyName, e);
                    }
                }
                referencedPropertyNames.retainAll(this.archetypeConfiguration.getRequiredProperties());
                referencedPropertyNames.remove(propertyName);
                result.put(propertyName, referencedPropertyNames);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean references(String targetProperty, String sourceProperty) {
            if (targetProperty.equals(sourceProperty)) {
                return false;
            }
            RequiredPropertyComparator requiredPropertyComparator = this;
            synchronized (requiredPropertyComparator) {
                if (!this.propertyReferenceMap.containsKey(sourceProperty)) {
                    this.propertyReferenceMap = this.computePropertyReferences();
                }
            }
            Set<String> referencedProperties = this.propertyReferenceMap.get(sourceProperty);
            if (referencedProperties.contains(targetProperty)) {
                return true;
            }
            for (String referencedProperty : referencedProperties) {
                if (!this.references(targetProperty, referencedProperty)) continue;
                return true;
            }
            return false;
        }
    }
}

