/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.creation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.ArchetypeFactory;
import org.apache.maven.archetype.ui.creation.ArchetypeCreationConfigurator;
import org.apache.maven.archetype.ui.creation.ArchetypeCreationQueryer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default")
@Singleton
public class DefaultArchetypeCreationConfigurator
implements ArchetypeCreationConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArchetypeCreationConfigurator.class);
    @Inject
    private ArchetypeCreationQueryer archetypeCreationQueryer;
    @Inject
    private ArchetypeFactory archetypeFactory;
    @Inject
    private ArchetypeFilesResolver archetypeFilesResolver;

    @Override
    public Properties configureArchetypeCreation(MavenProject project, Boolean interactiveMode, Properties commandLineProperties, File propertyFile, List<String> languages) throws IOException, ArchetypeNotDefined, ArchetypeNotConfigured, PrompterException {
        Properties properties = this.initialiseArchetypeProperties(commandLineProperties, propertyFile);
        ArchetypeDefinition archetypeDefinition = this.archetypeFactory.createArchetypeDefinition(properties);
        if (!archetypeDefinition.isDefined()) {
            archetypeDefinition = this.defineDefaultArchetype(project, properties);
        }
        ArchetypeConfiguration archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration(project, archetypeDefinition, properties);
        String resolvedPackage = this.archetypeFilesResolver.resolvePackage(project.getBasedir(), languages);
        if (!archetypeConfiguration.isConfigured()) {
            archetypeConfiguration = this.defineDefaultConfiguration(project, archetypeDefinition, resolvedPackage, properties);
        }
        if (interactiveMode.booleanValue()) {
            LOGGER.debug("Entering interactive mode");
            boolean confirmed = false;
            while (!confirmed) {
                if (!archetypeDefinition.isDefined()) {
                    LOGGER.debug("Archetype is yet not defined");
                    if (!archetypeDefinition.isGroupDefined()) {
                        LOGGER.debug("Asking for archetype's groupId");
                        archetypeDefinition.setGroupId(this.archetypeCreationQueryer.getArchetypeGroupId(project.getGroupId()));
                    }
                    if (!archetypeDefinition.isArtifactDefined()) {
                        LOGGER.debug("Asking for archetype's artifactId");
                        archetypeDefinition.setArtifactId(this.archetypeCreationQueryer.getArchetypeArtifactId(project.getArtifactId() + "-archetype"));
                    }
                    if (!archetypeDefinition.isVersionDefined()) {
                        LOGGER.debug("Asking for archetype's version");
                        archetypeDefinition.setVersion(this.archetypeCreationQueryer.getArchetypeVersion(project.getVersion()));
                    }
                    this.archetypeFactory.updateArchetypeConfiguration(archetypeConfiguration, archetypeDefinition);
                }
                if (!archetypeConfiguration.isConfigured()) {
                    LOGGER.debug("Archetype is not yet configured");
                    if (!archetypeConfiguration.isConfigured("groupId")) {
                        LOGGER.debug("Asking for project's groupId");
                        archetypeConfiguration.setProperty("groupId", this.archetypeCreationQueryer.getGroupId(archetypeConfiguration.getDefaultValue("groupId")));
                    }
                    if (!archetypeConfiguration.isConfigured("artifactId")) {
                        LOGGER.debug("Asking for project's artifactId");
                        archetypeConfiguration.setProperty("artifactId", this.archetypeCreationQueryer.getArtifactId(archetypeConfiguration.getDefaultValue("artifactId")));
                    }
                    if (!archetypeConfiguration.isConfigured("version")) {
                        LOGGER.debug("Asking for project's version");
                        archetypeConfiguration.setProperty("version", this.archetypeCreationQueryer.getVersion(archetypeConfiguration.getDefaultValue("version")));
                    }
                    if (!archetypeConfiguration.isConfigured("package")) {
                        LOGGER.debug("Asking for project's package");
                        archetypeConfiguration.setProperty("package", this.archetypeCreationQueryer.getPackage(resolvedPackage == null || resolvedPackage.isEmpty() ? archetypeConfiguration.getDefaultValue("package") : resolvedPackage));
                    }
                }
                boolean stopAddingProperties = false;
                while (!stopAddingProperties) {
                    LOGGER.debug("Asking for another required property");
                    stopAddingProperties = !this.archetypeCreationQueryer.askAddAnotherProperty();
                    if (stopAddingProperties) continue;
                    LOGGER.debug("Asking for required property key");
                    String propertyKey = this.archetypeCreationQueryer.askNewPropertyKey();
                    LOGGER.debug("Asking for required property value");
                    String replacementValue = this.archetypeCreationQueryer.askReplacementValue(propertyKey, archetypeConfiguration.getDefaultValue(propertyKey));
                    archetypeConfiguration.setDefaultProperty(propertyKey, replacementValue);
                    archetypeConfiguration.setProperty(propertyKey, replacementValue);
                }
                LOGGER.debug("Asking for configuration confirmation");
                if (this.archetypeCreationQueryer.confirmConfiguration(archetypeConfiguration)) {
                    confirmed = true;
                    continue;
                }
                LOGGER.debug("Reseting archetype's definition and configuration");
                archetypeConfiguration.reset();
                archetypeDefinition.reset();
            }
        } else {
            LOGGER.debug("Entering batch mode");
            if (!archetypeDefinition.isDefined()) {
                throw new ArchetypeNotDefined("The archetype is not defined");
            }
            if (!archetypeConfiguration.isConfigured()) {
                throw new ArchetypeNotConfigured("The archetype is not configured", null);
            }
        }
        return archetypeConfiguration.toProperties();
    }

    private ArchetypeDefinition defineDefaultArchetype(MavenProject project, Properties properties) {
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.groupId"))) {
            properties.setProperty("archetype.groupId", project.getGroupId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.artifactId"))) {
            properties.setProperty("archetype.artifactId", project.getArtifactId() + "-archetype");
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.version"))) {
            properties.setProperty("archetype.version", project.getVersion());
        }
        return this.archetypeFactory.createArchetypeDefinition(properties);
    }

    private ArchetypeConfiguration defineDefaultConfiguration(MavenProject project, ArchetypeDefinition archetypeDefinition, String resolvedPackage, Properties properties) {
        if (StringUtils.isEmpty((String)properties.getProperty("groupId"))) {
            LOGGER.info("Setting default groupId: " + project.getGroupId());
            properties.setProperty("groupId", project.getGroupId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("artifactId"))) {
            LOGGER.info("Setting default artifactId: " + project.getArtifactId());
            properties.setProperty("artifactId", project.getArtifactId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("version"))) {
            LOGGER.info("Setting default version: " + project.getVersion());
            properties.setProperty("version", project.getVersion());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.groupId"))) {
            LOGGER.info("Setting default archetype's groupId: " + project.getGroupId());
            properties.setProperty("archetype.groupId", project.getGroupId());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.artifactId"))) {
            LOGGER.info("Setting default archetype's artifactId: " + project.getArtifactId());
            properties.setProperty("archetype.artifactId", project.getArtifactId() + "-archetype");
        }
        if (StringUtils.isEmpty((String)properties.getProperty("archetype.version"))) {
            LOGGER.info("Setting default archetype's version: " + project.getVersion());
            properties.setProperty("archetype.version", project.getVersion());
        }
        if (StringUtils.isEmpty((String)properties.getProperty("package"))) {
            if (resolvedPackage == null || resolvedPackage.isEmpty()) {
                resolvedPackage = project.getGroupId();
            }
            LOGGER.info("Setting default package: " + resolvedPackage);
            properties.setProperty("package", resolvedPackage);
        }
        return this.archetypeFactory.createArchetypeConfiguration(project, archetypeDefinition, properties);
    }

    private void readProperties(Properties properties, File propertyFile) throws IOException {
        LOGGER.debug("Reading property file " + propertyFile);
        try (InputStream is = Files.newInputStream(propertyFile.toPath(), new OpenOption[0]);){
            properties.load(is);
            LOGGER.debug("Read " + properties.size() + " properties");
        }
    }

    private Properties initialiseArchetypeProperties(Properties commandLineProperties, File propertyFile) throws IOException {
        Properties properties = new Properties();
        if (propertyFile != null) {
            try {
                this.readProperties(properties, propertyFile);
            }
            catch (NoSuchFileException ex) {
                LOGGER.debug(propertyFile.getName() + "  does not exist");
            }
        }
        return properties;
    }
}

