/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;

public class ArchetypeConfiguration {
    private String groupId;
    private String artifactId;
    private String version;
    private String name;
    private String goals;
    private String url;
    private String description;
    private List<String> requiredProperties;
    private Properties properties = new Properties();
    private Properties defaultProperties = new Properties();
    Map<String, Pattern> propertiesValidationPatterns = new HashMap<String, Pattern>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void addRequiredProperty(String string) {
        this.getRequiredProperties().add(string);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGoals() {
        return this.goals;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getRequiredProperties() {
        if (this.requiredProperties == null) {
            this.requiredProperties = new ArrayList<String>();
        }
        return this.requiredProperties;
    }

    public String getVersion() {
        return this.version;
    }

    public void removeRequiredProperty(String string) {
        this.getRequiredProperties().remove(string);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRequiredProperties(List<String> requiredProperties) {
        this.requiredProperties = requiredProperties;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void reset() {
        this.properties.clear();
    }

    public void setProperty(String requiredProperty, String propertyValue) {
        this.properties.setProperty(requiredProperty, propertyValue);
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property, null);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties toProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        result.setProperty("archetype.groupId", StringUtils.isNotEmpty((String)this.getGroupId()) ? this.getGroupId() : "");
        result.setProperty("archetype.artifactId", StringUtils.isNotEmpty((String)this.getArtifactId()) ? this.getArtifactId() : "");
        result.setProperty("archetype.version", StringUtils.isNotEmpty((String)this.getVersion()) ? this.getVersion() : "");
        if (StringUtils.isNotEmpty((String)this.getGoals())) {
            result.setProperty("archetype.goals", this.getGoals());
        }
        return result;
    }

    public boolean isConfigured() {
        for (String requiredProperty : this.getRequiredProperties()) {
            if (!StringUtils.isEmpty((String)this.properties.getProperty(requiredProperty))) continue;
            return false;
        }
        return true;
    }

    public boolean isConfigured(String requiredProperties) {
        return StringUtils.isNotBlank((String)this.properties.getProperty(requiredProperties));
    }

    public void setDefaultProperty(String requiredProperty, String propertyValue) {
        this.defaultProperties.setProperty(requiredProperty, propertyValue);
    }

    public String getDefaultValue(String requiredProperty) {
        return this.defaultProperties.getProperty(requiredProperty, null);
    }

    public Properties getDefaultValues() {
        return this.defaultProperties;
    }

    public void setPropertyValidationRegex(String requiredProperty, String regex) {
        this.propertiesValidationPatterns.put(requiredProperty, Pattern.compile(regex));
    }

    public Pattern getPropertyValidationRegex(String requiredProperty) {
        return this.propertiesValidationPatterns.get(requiredProperty);
    }

    public boolean validatePropertyValue(String property, String value) {
        Pattern pattern = this.propertiesValidationPatterns.get(property);
        if (pattern == null) {
            return true;
        }
        return pattern.matcher(value).matches();
    }
}

