/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.mojos;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.mojos.FileLogger;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationConfigurator;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.scriptinterpreter.ExecutionLogger;
import org.apache.maven.shared.scriptinterpreter.ScriptException;
import org.apache.maven.shared.scriptinterpreter.ScriptRunner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Mojo(name="integration-test", requiresProject=true)
public class IntegrationTestMojo
extends AbstractMojo {
    private ArchetypeGenerator archetypeGenerator;
    private Downloader downloader;
    private Invoker invoker;
    private ArchetypeGenerationConfigurator archetypeGenerationConfigurator;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="archetype.test.skip")
    private boolean skip = false;
    @Parameter(property="archetype.test.projectsDirectory", defaultValue="${project.build.testOutputDirectory}/projects", required=true)
    private File testProjectsDirectory;
    @Parameter(property="archetype.test.verifyScript", defaultValue="verify")
    private String postBuildHookScript;
    @Parameter(property="archetype.test.noLog", defaultValue="false")
    private boolean noLog;
    @Parameter(property="archetype.test.streamLogs", defaultValue="true")
    private boolean streamLogs;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="archetype.test.localRepositoryPath", defaultValue="${settings.localRepository}", required=true)
    private File localRepositoryPath;
    @Parameter(property="archetype.test.showVersion", defaultValue="false")
    private boolean showVersion;
    @Parameter(property="archetype.test.ignoreEOLStyle", defaultValue="false")
    private boolean ignoreEOLStyle;
    @Parameter(property="archetype.test.debug", defaultValue="false")
    private boolean debug;
    @Parameter
    private Map<String, String> filterProperties;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;
    @Parameter(property="archetype.test.settingsFile")
    private File settingsFile;
    @Parameter
    private Map<String, String> properties = new HashMap<String, String>();

    @Inject
    public IntegrationTestMojo(ArchetypeGenerator archetypeGenerator, Downloader downloader, Invoker invoker, ArchetypeGenerationConfigurator archetypeGenerationConfigurator) {
        this.archetypeGenerator = archetypeGenerator;
        this.downloader = downloader;
        this.invoker = invoker;
        this.archetypeGenerationConfigurator = archetypeGenerationConfigurator;
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            return;
        }
        if (!this.testProjectsDirectory.exists()) {
            this.getLog().warn((CharSequence)"No Archetype IT projects: root 'projects' directory not found.");
            return;
        }
        File archetypeFile = this.project.getArtifact().getFile();
        if (archetypeFile == null) {
            throw new MojoExecutionException("Unable to get the archetypes' artifact which should have just been built: you probably launched 'mvn archetype:integration-test' instead of 'mvn integration-test'.");
        }
        try {
            List projectsGoalFiles = FileUtils.getFiles((File)this.testProjectsDirectory, (String)"**/goal.txt", (String)"");
            if (projectsGoalFiles.isEmpty()) {
                this.getLog().warn((CharSequence)"No Archetype IT projects: no directory with goal.txt found.");
                return;
            }
            StringWriter errorWriter = new StringWriter();
            for (File goalFile : projectsGoalFiles) {
                try {
                    this.processIntegrationTest(goalFile, archetypeFile);
                }
                catch (IntegrationTestFailure ex) {
                    errorWriter.write("\nArchetype IT '" + goalFile.getParentFile().getName() + "' failed: ");
                    errorWriter.write(ex.getMessage());
                }
            }
            String errors = errorWriter.toString();
            if (errors != null && !errors.isEmpty()) {
                throw new MojoExecutionException(errors);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private void assertDirectoryEquals(File reference, File actual) throws IntegrationTestFailure, IOException {
        List referenceFiles = FileUtils.getFileAndDirectoryNames((File)reference, (String)"**", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        this.getLog().debug((CharSequence)("reference content: " + referenceFiles));
        List actualFiles = FileUtils.getFileAndDirectoryNames((File)actual, (String)"**", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true);
        this.getLog().debug((CharSequence)("actual content: " + actualFiles));
        boolean fileNamesEquals = CollectionUtils.isEqualCollection((Collection)referenceFiles, (Collection)actualFiles);
        if (!fileNamesEquals) {
            this.getLog().debug((CharSequence)"Actual list of files is not the same as reference:");
            int missing = 0;
            for (String ref : referenceFiles) {
                if (actualFiles.contains(ref)) {
                    actualFiles.remove(ref);
                    this.getLog().debug((CharSequence)("Contained " + ref));
                    continue;
                }
                ++missing;
                this.getLog().error((CharSequence)("Not contained " + ref));
            }
            this.getLog().error((CharSequence)("Remains " + actualFiles));
            throw new IntegrationTestFailure("Reference and generated project differs (missing: " + missing + ", unexpected: " + actualFiles.size() + ")");
        }
        if (!this.ignoreEOLStyle) {
            this.getLog().warn((CharSequence)"Property ignoreEOLStyle was not set - files will be compared considering their EOL style!");
        }
        boolean contentEquals = true;
        for (String file : referenceFiles) {
            File referenceFile = new File(reference, file);
            File actualFile = new File(actual, file);
            if (referenceFile.isDirectory()) {
                if (!actualFile.isFile()) continue;
                this.getLog().error((CharSequence)("File " + file + " is a directory in the reference but a file in actual"));
                contentEquals = false;
                continue;
            }
            if (actualFile.isDirectory()) {
                if (!referenceFile.isFile()) continue;
                this.getLog().error((CharSequence)("File " + file + " is a file in the reference but a directory in actual"));
                contentEquals = false;
                continue;
            }
            if (this.contentEquals(referenceFile, actualFile)) continue;
            this.getLog().error((CharSequence)("Contents of file " + file + " are not equal"));
            contentEquals = false;
        }
        if (!contentEquals) {
            throw new IntegrationTestFailure("Some content are not equals");
        }
    }

    /*
     * Exception decompiling
     */
    private boolean contentEquals(File referenceFile, File actualFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Properties loadProperties(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);){
            properties.load(in);
        }
        return properties;
    }

    private void processIntegrationTest(File goalFile, File archetypeFile) throws IntegrationTestFailure, MojoExecutionException {
        this.getLog().info((CharSequence)("Processing Archetype IT project: " + goalFile.getParentFile().getName()));
        try {
            String goals;
            Properties properties = this.getProperties(goalFile);
            File basedir = new File(goalFile.getParentFile(), "project");
            FileUtils.deleteDirectory((File)basedir);
            FileUtils.mkdir((String)basedir.toString());
            basedir = this.setupParentProjects(goalFile.getParentFile().getParentFile(), basedir);
            ArchetypeGenerationRequest request = this.generate(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), archetypeFile, properties, basedir.toString());
            File reference = new File(goalFile.getParentFile(), "reference");
            if (reference.exists()) {
                this.getLog().info((CharSequence)("Comparing generated project with reference content: " + reference));
                this.assertDirectoryEquals(reference, new File(basedir, request.getArtifactId()));
            }
            if ((goals = FileUtils.fileRead((File)goalFile)) != null && !goals.isEmpty()) {
                this.invokePostArchetypeGenerationGoals(goals.trim(), new File(basedir, request.getArtifactId()), goalFile);
            }
        }
        catch (IOException ioe) {
            throw new IntegrationTestFailure(ioe);
        }
    }

    private ArchetypeGenerationRequest generate(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, File archetypeFile, Properties properties, String basedir) throws IntegrationTestFailure, MojoExecutionException {
        ArchetypeGenerationRequest request = new ArchetypeGenerationRequest().setArchetypeGroupId(archetypeGroupId).setArchetypeArtifactId(archetypeArtifactId).setArchetypeVersion(archetypeVersion).setGroupId(properties.getProperty("groupId")).setArtifactId(properties.getProperty("artifactId")).setVersion(properties.getProperty("version")).setPackage(properties.getProperty("package")).setRepositorySession(this.session.getRepositorySession()).setOutputDirectory(basedir).setProperties(properties);
        ArchetypeGenerationResult result = new ArchetypeGenerationResult();
        try {
            this.archetypeGenerationConfigurator.configureArchetype(request, false, properties);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot configure archetype", e);
        }
        this.archetypeGenerator.generateArchetype(request, archetypeFile, result);
        if (result.getCause() != null) {
            if (result.getCause() instanceof ArchetypeNotConfigured) {
                ArchetypeNotConfigured anc = (ArchetypeNotConfigured)result.getCause();
                throw new IntegrationTestFailure("Missing required properties in archetype.properties: " + StringUtils.join(anc.getMissingProperties().iterator(), (String)", "), (Throwable)anc);
            }
            throw new IntegrationTestFailure(result.getCause().getMessage(), result.getCause());
        }
        return request;
    }

    private File setupParentProjects(File configFolder, File buildFolder) throws IOException, MojoExecutionException, IntegrationTestFailure {
        File archetypeFile;
        File archetypePomPropertiesFile = new File(configFolder, "archetype.pom.properties");
        if (!archetypePomPropertiesFile.exists()) {
            this.getLog().debug((CharSequence)("No 'archetype.pom.properties' file found in " + configFolder));
            return buildFolder;
        }
        buildFolder = this.setupParentProjects(configFolder.getParentFile(), buildFolder);
        Properties archetypePomProperties = this.loadProperties(archetypePomPropertiesFile);
        String groupId = archetypePomProperties.getProperty("groupId");
        if (groupId == null || groupId.isEmpty()) {
            throw new MojoExecutionException("Property groupId not set in " + archetypePomPropertiesFile);
        }
        String artifactId = archetypePomProperties.getProperty("artifactId");
        if (artifactId == null || artifactId.isEmpty()) {
            throw new MojoExecutionException("Property artifactId not set in " + archetypePomPropertiesFile);
        }
        String version = archetypePomProperties.getProperty("version");
        if (version == null || version.isEmpty()) {
            throw new MojoExecutionException("Property version not set in " + archetypePomPropertiesFile);
        }
        try {
            archetypeFile = this.getArchetypeFile(groupId, artifactId, version);
        }
        catch (DownloadException e) {
            throw new MojoExecutionException("Could not resolve archetype artifact ", (Exception)((Object)e));
        }
        Properties archetypeProperties = this.getProperties(archetypePomPropertiesFile);
        this.getLog().info((CharSequence)("Setting up parent project in " + buildFolder));
        ArchetypeGenerationRequest request = this.generate(groupId, artifactId, version, archetypeFile, archetypeProperties, buildFolder.toString());
        return new File(buildFolder, request.getArtifactId());
    }

    private File getArchetypeFile(String groupId, String artifactId, String version) throws DownloadException {
        return this.downloader.download(groupId, artifactId, version, this.project.getRemoteProjectRepositories(), this.session.getRepositorySession());
    }

    private Properties getProperties(File goalFile) throws IOException {
        File propertiesFile = new File(goalFile.getParentFile(), "archetype.properties");
        return this.loadProperties(propertiesFile);
    }

    private void invokePostArchetypeGenerationGoals(String goals, File basedir, File goalFile) throws IntegrationTestFailure, IOException, MojoExecutionException {
        FileLogger logger;
        block24: {
            logger = this.setupLogger(basedir);
            if (!StringUtils.isBlank((String)goals)) {
                File userSettings;
                File archetypeItDirectory;
                this.getLog().info((CharSequence)("Invoking post-archetype-generation goals: " + goals));
                if (!this.localRepositoryPath.exists()) {
                    this.localRepositoryPath.mkdirs();
                }
                InvocationRequest request = new DefaultInvocationRequest().setBaseDirectory(basedir).setGoals(Arrays.asList(StringUtils.split((String)goals, (String)","))).setLocalRepositoryDirectory(this.localRepositoryPath).setBatchMode(true).setShowErrors(true);
                request.setDebug(this.debug);
                request.setShowVersion(this.showVersion);
                if (logger != null) {
                    request.setErrorHandler((InvocationOutputHandler)logger);
                    request.setOutputHandler((InvocationOutputHandler)logger);
                }
                if (!this.properties.isEmpty()) {
                    Properties props = new Properties();
                    for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                        if (entry.getValue() == null) continue;
                        props.setProperty(entry.getKey(), entry.getValue());
                    }
                    request.setProperties(props);
                }
                if ((archetypeItDirectory = new File(this.project.getBuild().getDirectory(), "archetype-it")).exists()) {
                    FileUtils.deleteDirectory((File)archetypeItDirectory);
                }
                archetypeItDirectory.mkdir();
                if (this.settingsFile != null) {
                    userSettings = new File(archetypeItDirectory, "interpolated-" + this.settingsFile.getName());
                    this.buildInterpolatedFile(this.settingsFile, userSettings);
                } else {
                    userSettings = new File(archetypeItDirectory, "archetype-settings.xml");
                    SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
                    try (FileWriter fileWriter = new FileWriter(userSettings);){
                        settingsWriter.write((Writer)fileWriter, this.settings);
                    }
                }
                request.setUserSettingsFile(userSettings);
                try {
                    InvocationResult result = this.invoker.execute(request);
                    this.getLog().info((CharSequence)("Post-archetype-generation invoker exit code: " + result.getExitCode()));
                    if (result.getExitCode() != 0) {
                        throw new IntegrationTestFailure("Execution failure: exit code = " + result.getExitCode(), (Throwable)result.getExecutionException());
                    }
                    break block24;
                }
                catch (MavenInvocationException e) {
                    throw new IntegrationTestFailure("Cannot run additions goals.", e);
                }
            }
            this.getLog().info((CharSequence)"No post-archetype-generation goals to invoke.");
        }
        try (ScriptRunner scriptRunner = new ScriptRunner();){
            scriptRunner.setScriptEncoding(this.encoding);
            LinkedHashMap<String, File> context = new LinkedHashMap<String, File>();
            context.put("projectDir", basedir);
            scriptRunner.run("post-build script", goalFile.getParentFile(), this.postBuildHookScript, context, (ExecutionLogger)logger);
        }
        catch (ScriptException e) {
            throw new IntegrationTestFailure("post build script failure failure: " + e.getMessage(), e);
        }
    }

    private FileLogger setupLogger(File basedir) throws IOException {
        FileLogger logger = null;
        if (!this.noLog) {
            File outputLog = new File(basedir, "build.log");
            logger = this.streamLogs ? new FileLogger(outputLog, this.getLog()) : new FileLogger(outputLog);
            this.getLog().debug((CharSequence)("build log initialized in: " + outputLog));
        }
        return logger;
    }

    private Map<String, Object> getInterpolationValueSource() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.filterProperties != null) {
            props.putAll(this.filterProperties);
        }
        if (this.filterProperties != null) {
            props.putAll(this.filterProperties);
        }
        props.put("basedir", this.project.getBasedir().getAbsolutePath());
        props.put("baseurl", IntegrationTestMojo.toUrl(this.project.getBasedir().getAbsolutePath()));
        if (this.settings.getLocalRepository() != null) {
            props.put("localRepository", this.settings.getLocalRepository());
            props.put("localRepositoryUrl", IntegrationTestMojo.toUrl(this.settings.getLocalRepository()));
        }
        return new CompositeMap(this.project, props);
    }

    protected void buildInterpolatedFile(File originalFile, File interpolatedFile) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Interpolate " + originalFile.getPath() + " to " + interpolatedFile.getPath()));
        try {
            String xml;
            Map<String, Object> composite = this.getInterpolationValueSource();
            try (XmlStreamReader xmlStreamReader = new XmlStreamReader(originalFile);
                 InterpolationFilterReader reader = new InterpolationFilterReader((Reader)xmlStreamReader, composite, "@", "@");){
                xml = IOUtil.toString((Reader)reader);
            }
            try (XmlStreamWriter writer = new XmlStreamWriter(interpolatedFile);){
                interpolatedFile.getParentFile().mkdirs();
                writer.write(xml);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to interpolate file " + originalFile.getPath(), (Exception)e);
        }
    }

    private static String toUrl(String filename) {
        String url = "file://" + new File(filename).toURI().getPath();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    static class IntegrationTestFailure
    extends Exception {
        IntegrationTestFailure() {
        }

        IntegrationTestFailure(String message) {
            super(message);
        }

        IntegrationTestFailure(Throwable cause) {
            super(cause);
        }

        IntegrationTestFailure(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class CompositeMap
    implements Map<String, Object> {
        private MavenProject mavenProject;
        private Map<String, Object> properties;

        protected CompositeMap(MavenProject mavenProject, Map<String, Object> properties) {
            if (mavenProject == null) {
                throw new IllegalArgumentException("no project specified");
            }
            this.mavenProject = mavenProject;
            this.properties = properties == null ? new HashMap() : properties;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                return false;
            }
            String expression = (String)key;
            if (expression.startsWith("project.") || expression.startsWith("pom.")) {
                try {
                    Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                    if (evaluated != null) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.properties.containsKey(key) || this.mavenProject.getProperties().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            Object value;
            if (!(key instanceof String)) {
                return null;
            }
            String expression = (String)key;
            if (expression.startsWith("project.") || expression.startsWith("pom.")) {
                try {
                    Object evaluated = ReflectionValueExtractor.evaluate((String)expression, (Object)this.mavenProject);
                    if (evaluated != null) {
                        return evaluated;
                    }
                }
                catch (Exception evaluated) {
                    // empty catch block
                }
            }
            return (value = this.properties.get(key)) != null ? value : this.mavenProject.getProperties().get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.mavenProject == null && this.mavenProject.getProperties().isEmpty() && this.properties.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException();
        }
    }
}

