/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.testing;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scope;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Plugin;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.testing.ConfigurationException;
import org.apache.maven.plugin.testing.ResolverExpressionEvaluatorStub;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.eclipse.aether.RepositorySystemSession;

public abstract class AbstractMojoTestCase
extends PlexusTestCase {
    private ComponentConfigurator configurator;
    private PlexusContainer container;
    private Map<String, MojoDescriptor> mojoDescriptors;

    protected void setUp() throws Exception {
        this.configurator = (ComponentConfigurator)this.getContainer().lookup(ComponentConfigurator.class, "basic");
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + this.getPluginDescriptorLocation());
        org.apache.commons.io.input.XmlStreamReader reader = new org.apache.commons.io.input.XmlStreamReader(is);
        InterpolationFilterReader interpolationFilterReader = new InterpolationFilterReader((Reader)new BufferedReader((Reader)reader), this.container.getContext().getContextData());
        PluginDescriptor pluginDescriptor = new PluginDescriptorBuilder().build((Reader)interpolationFilterReader);
        Artifact artifact = ((RepositorySystem)this.lookup(RepositorySystem.class)).createArtifact(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), pluginDescriptor.getVersion(), ".jar");
        artifact.setFile(this.getPluginArtifactFile());
        pluginDescriptor.setPluginArtifact(artifact);
        pluginDescriptor.setArtifacts(Arrays.asList(artifact));
        for (ComponentDescriptor desc : pluginDescriptor.getComponents()) {
            this.getContainer().addComponentDescriptor(desc);
        }
        this.mojoDescriptors = new HashMap<String, MojoDescriptor>();
        for (MojoDescriptor mojoDescriptor : pluginDescriptor.getMojos()) {
            this.mojoDescriptors.put(mojoDescriptor.getGoal(), mojoDescriptor);
        }
    }

    private File getPluginArtifactFile() throws IOException {
        String pluginDescriptorLocation = this.getPluginDescriptorLocation();
        URL resource = ((Object)((Object)this)).getClass().getResource("/" + pluginDescriptorLocation);
        File file = null;
        if (resource != null) {
            if ("file".equalsIgnoreCase(resource.getProtocol())) {
                String path = resource.getPath();
                if (path.endsWith(pluginDescriptorLocation)) {
                    file = new File(path.substring(0, path.length() - pluginDescriptorLocation.length()));
                }
            } else if ("jar".equalsIgnoreCase(resource.getProtocol())) {
                try {
                    String path;
                    URL jarfile = new URL(resource.getPath());
                    if ("file".equalsIgnoreCase(jarfile.getProtocol()) && (path = jarfile.getPath()).endsWith(pluginDescriptorLocation)) {
                        file = new File(path.substring(0, path.length() - pluginDescriptorLocation.length() - 2));
                    }
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        if (file == null || !file.exists()) {
            file = new File(AbstractMojoTestCase.getBasedir());
        }
        return file.getCanonicalFile();
    }

    protected InputStream getPublicDescriptorStream() throws Exception {
        return new FileInputStream(new File(this.getPluginDescriptorPath()));
    }

    protected String getPluginDescriptorPath() {
        return AbstractMojoTestCase.getBasedir() + "/target/classes/META-INF/maven/plugin.xml";
    }

    protected String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    protected void setupContainer() {
        ContainerConfiguration cc = this.setupContainerConfiguration();
        try {
            ArrayList<Module> modules = new ArrayList<Module>();
            modules.add((Module)new AbstractModule(){

                protected void configure() {
                    MojoExecutionScope executionScope = new MojoExecutionScope();
                    this.bindScope(MojoExecutionScoped.class, (Scope)executionScope);
                    this.bind(MojoExecutionScope.class).toInstance((Object)executionScope);
                    this.bind(MavenProject.class).toProvider(MojoExecutionScope.seededKeyProvider()).in((Scope)executionScope);
                    this.bind(MojoExecution.class).toProvider(MojoExecutionScope.seededKeyProvider()).in((Scope)executionScope);
                }
            });
            this.addGuiceModules(modules);
            this.container = new DefaultPlexusContainer(cc, modules.toArray(new Module[modules.size()]));
        }
        catch (PlexusContainerException e) {
            e.printStackTrace();
            AbstractMojoTestCase.fail((String)"Failed to create plexus container.");
        }
    }

    protected void addGuiceModules(List<Module> modules) {
    }

    protected ContainerConfiguration setupContainerConfiguration() {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(classWorld).setClassPathScanning("index").setAutoWiring(true).setName("maven");
        return cc;
    }

    protected PlexusContainer getContainer() {
        if (this.container == null) {
            this.setupContainer();
        }
        return this.container;
    }

    protected Mojo lookupMojo(String goal, String pluginPom) throws Exception {
        return this.lookupMojo(goal, new File(pluginPom));
    }

    protected Mojo lookupEmptyMojo(String goal, String pluginPom) throws Exception {
        return this.lookupEmptyMojo(goal, new File(pluginPom));
    }

    protected Mojo lookupMojo(String goal, File pom) throws Exception {
        File pluginPom = new File(AbstractMojoTestCase.getBasedir(), "pom.xml");
        Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)pluginPom));
        String artifactId = pluginPomDom.getChild("artifactId").getValue();
        String groupId = this.resolveFromRootThenParent(pluginPomDom, "groupId");
        String version = this.resolveFromRootThenParent(pluginPomDom, "version");
        PlexusConfiguration pluginConfiguration = this.extractPluginConfiguration(artifactId, pom);
        return this.lookupMojo(groupId, artifactId, version, goal, pluginConfiguration);
    }

    protected Mojo lookupEmptyMojo(String goal, File pom) throws Exception {
        File pluginPom = new File(AbstractMojoTestCase.getBasedir(), "pom.xml");
        Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)pluginPom));
        String artifactId = pluginPomDom.getChild("artifactId").getValue();
        String groupId = this.resolveFromRootThenParent(pluginPomDom, "groupId");
        String version = this.resolveFromRootThenParent(pluginPomDom, "version");
        return this.lookupMojo(groupId, artifactId, version, goal, null);
    }

    protected Mojo lookupMojo(String groupId, String artifactId, String version, String goal, PlexusConfiguration pluginConfiguration) throws Exception {
        this.validateContainerStatus();
        Mojo mojo = (Mojo)this.lookup(Mojo.ROLE, groupId + ":" + artifactId + ":" + version + ":" + goal);
        LoggerManager loggerManager = (LoggerManager)this.getContainer().lookup(LoggerManager.class);
        DefaultLog mojoLogger = new DefaultLog(loggerManager.getLoggerForComponent(Mojo.ROLE));
        mojo.setLog((Log)mojoLogger);
        if (pluginConfiguration != null) {
            ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
            this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        }
        return mojo;
    }

    protected Mojo lookupConfiguredMojo(MavenProject project, String goal) throws Exception {
        return this.lookupConfiguredMojo(this.newMavenSession(project), this.newMojoExecution(goal));
    }

    protected Mojo lookupConfiguredMojo(MavenSession session, MojoExecution execution) throws Exception, ComponentConfigurationException {
        MavenProject project = session.getCurrentProject();
        MojoDescriptor mojoDescriptor = execution.getMojoDescriptor();
        Mojo mojo = (Mojo)this.lookup(mojoDescriptor.getRole(), mojoDescriptor.getRoleHint());
        PluginParameterExpressionEvaluator evaluator = new PluginParameterExpressionEvaluator(session, execution);
        Xpp3Dom configuration = null;
        Plugin plugin = project.getPlugin(mojoDescriptor.getPluginDescriptor().getPluginLookupKey());
        if (plugin != null) {
            configuration = (Xpp3Dom)plugin.getConfiguration();
        }
        if (configuration == null) {
            configuration = new Xpp3Dom("configuration");
        }
        configuration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)configuration, (Xpp3Dom)execution.getConfiguration());
        XmlPlexusConfiguration pluginConfiguration = new XmlPlexusConfiguration(configuration);
        if (mojoDescriptor.getComponentConfigurator() != null) {
            this.configurator = (ComponentConfigurator)this.getContainer().lookup(ComponentConfigurator.class, mojoDescriptor.getComponentConfigurator());
        }
        this.configurator.configureComponent((Object)mojo, (PlexusConfiguration)pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        return mojo;
    }

    protected MavenSession newMavenSession(MavenProject project) {
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        MavenSession session = new MavenSession(this.container, (RepositorySystemSession)MavenRepositorySystemUtils.newSession(), (MavenExecutionRequest)request, (MavenExecutionResult)result);
        session.setCurrentProject(project);
        session.setProjects(Arrays.asList(project));
        return session;
    }

    protected MojoExecution newMojoExecution(String goal) {
        MojoDescriptor mojoDescriptor = this.mojoDescriptors.get(goal);
        AbstractMojoTestCase.assertNotNull((String)String.format("The MojoDescriptor for the goal %s cannot be null.", goal), (Object)mojoDescriptor);
        MojoExecution execution = new MojoExecution(mojoDescriptor);
        this.finalizeMojoConfiguration(execution);
        return execution;
    }

    private void finalizeMojoConfiguration(MojoExecution mojoExecution) {
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Xpp3Dom executionConfiguration = mojoExecution.getConfiguration();
        if (executionConfiguration == null) {
            executionConfiguration = new Xpp3Dom("configuration");
        }
        Xpp3Dom defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor);
        Xpp3Dom finalConfiguration = new Xpp3Dom("configuration");
        if (mojoDescriptor.getParameters() != null) {
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                Xpp3Dom parameterDefaults;
                Xpp3Dom parameterConfiguration = executionConfiguration.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = executionConfiguration.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)parameterConfiguration, (Xpp3Dom)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                if (StringUtils.isEmpty((String)(parameterConfiguration = new Xpp3Dom(parameterConfiguration, parameter.getName())).getAttribute("implementation")) && StringUtils.isNotEmpty((String)parameter.getImplementation())) {
                    parameterConfiguration.setAttribute("implementation", parameter.getImplementation());
                }
                finalConfiguration.addChild(parameterConfiguration);
            }
        }
        mojoExecution.setConfiguration(finalConfiguration);
    }

    protected PlexusConfiguration extractPluginConfiguration(String artifactId, File pom) throws Exception {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)pom);
        Xpp3Dom pomDom = Xpp3DomBuilder.build((Reader)reader);
        return this.extractPluginConfiguration(artifactId, pomDom);
    }

    protected PlexusConfiguration extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        Xpp3Dom pluginsRootElement;
        Xpp3Dom pluginConfigurationElement = null;
        Xpp3Dom buildElement = pomDom.getChild("build");
        if (buildElement != null && (pluginsRootElement = buildElement.getChild("plugins")) != null) {
            Xpp3Dom[] pluginElements;
            for (Xpp3Dom pluginElement : pluginElements = pluginsRootElement.getChildren()) {
                String pluginElementArtifactId = pluginElement.getChild("artifactId").getValue();
                if (!pluginElementArtifactId.equals(artifactId)) continue;
                pluginConfigurationElement = pluginElement.getChild("configuration");
                break;
            }
            if (pluginConfigurationElement == null) {
                throw new ConfigurationException("Cannot find a configuration element for a plugin with an artifactId of " + artifactId + ".");
            }
        }
        if (pluginConfigurationElement == null) {
            throw new ConfigurationException("Cannot find a configuration element for a plugin with an artifactId of " + artifactId + ".");
        }
        return new XmlPlexusConfiguration(pluginConfigurationElement);
    }

    protected Mojo configureMojo(Mojo mojo, String artifactId, File pom) throws Exception {
        this.validateContainerStatus();
        PlexusConfiguration pluginConfiguration = this.extractPluginConfiguration(artifactId, pom);
        ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
        this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        return mojo;
    }

    protected Mojo configureMojo(Mojo mojo, PlexusConfiguration pluginConfiguration) throws Exception {
        this.validateContainerStatus();
        ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
        this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        return mojo;
    }

    protected Object getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        return field.get(object);
    }

    protected Map<String, Object> getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return this.getVariablesAndValuesFromObject(object.getClass(), object);
    }

    protected Map<String, Object> getVariablesAndValuesFromObject(Class<?> clazz, Object object) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            map.put(((Field)field).getName(), ((Field)field).get(object));
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            map.putAll(this.getVariablesAndValuesFromObject(superclass, object));
        }
        return map;
    }

    protected void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        field.set(object, value);
    }

    private String resolveFromRootThenParent(Xpp3Dom pluginPomDom, String element) throws Exception {
        Xpp3Dom elementDom = pluginPomDom.getChild(element);
        if (elementDom == null) {
            Xpp3Dom pluginParentDom = pluginPomDom.getChild("parent");
            if (pluginParentDom != null) {
                elementDom = pluginParentDom.getChild(element);
                if (elementDom == null) {
                    throw new Exception("unable to determine " + element);
                }
                return elementDom.getValue();
            }
            throw new Exception("unable to determine " + element);
        }
        return elementDom.getValue();
    }

    private void validateContainerStatus() throws Exception {
        if (this.getContainer() != null) {
            return;
        }
        throw new Exception("container is null, make sure super.setUp() is called");
    }
}

