/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.archetype.source.CatalogArchetypeDataSource;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="catalog")
@Singleton
public class LocalCatalogArchetypeDataSource
extends CatalogArchetypeDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalCatalogArchetypeDataSource.class);

    @Override
    public File updateCatalog(RepositorySystemSession repositorySession, Archetype archetype) throws ArchetypeDataSourceException {
        ArchetypeCatalog catalog;
        File localRepo = repositorySession.getLocalRepository().getBasedir();
        File catalogFile = new File(localRepo, "archetype-catalog.xml");
        LOGGER.debug("Catalog to be used for update: " + catalogFile.getAbsolutePath());
        if (catalogFile.exists()) {
            try (XmlStreamReader reader = new XmlStreamReader(catalogFile);){
                LOGGER.debug("Reading catalog to be updated: " + catalogFile);
                catalog = this.readCatalog((Reader)reader);
            }
            catch (FileNotFoundException ex) {
                LOGGER.debug("Catalog file don't exist");
                catalog = new ArchetypeCatalog();
            }
            catch (IOException e) {
                throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
            }
        } else {
            LOGGER.debug("Catalog file don't exist");
            catalog = new ArchetypeCatalog();
        }
        Iterator archetypes = catalog.getArchetypes().iterator();
        boolean found = false;
        Archetype newArchetype = archetype;
        while (!found && archetypes.hasNext()) {
            Archetype a = (Archetype)archetypes.next();
            if (!a.getGroupId().equals(archetype.getGroupId()) || !a.getArtifactId().equals(archetype.getArtifactId())) continue;
            newArchetype = a;
            found = true;
        }
        if (!found) {
            catalog.addArchetype(newArchetype);
        }
        newArchetype.setVersion(archetype.getVersion());
        newArchetype.setRepository(archetype.getRepository());
        newArchetype.setDescription(archetype.getDescription());
        newArchetype.setProperties(archetype.getProperties());
        newArchetype.setGoals(archetype.getGoals());
        this.writeLocalCatalog(catalog, catalogFile);
        return catalogFile;
    }

    @Override
    public ArchetypeCatalog getArchetypeCatalog(RepositorySystemSession repositorySession, List<RemoteRepository> remoteRepositories) throws ArchetypeDataSourceException {
        File localRepo = repositorySession.getLocalRepository().getBasedir();
        File catalogFile = new File(localRepo, "archetype-catalog.xml");
        if (catalogFile.exists() && catalogFile.isDirectory()) {
            catalogFile = new File(catalogFile, "archetype-catalog.xml");
        }
        LOGGER.debug("Getting archetypes from catalog: " + catalogFile);
        if (catalogFile.exists()) {
            try {
                return this.readCatalog((Reader)new XmlStreamReader(catalogFile));
            }
            catch (FileNotFoundException e) {
                throw new ArchetypeDataSourceException("The specific archetype catalog does not exist.", e);
            }
            catch (IOException e) {
                throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
            }
        }
        return new ArchetypeCatalog();
    }
}

