/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.generator;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.ArchetypeFilesResolver;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.exception.ArchetypeGenerationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.exception.OutputFileExists;
import org.apache.maven.archetype.exception.PomFileExists;
import org.apache.maven.archetype.exception.ProjectDirectoryExists;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.generator.FilesetArchetypeGenerator;
import org.apache.maven.archetype.metadata.AbstractArchetypeDescriptor;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Named
@Singleton
public class DefaultFilesetArchetypeGenerator
implements FilesetArchetypeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilesetArchetypeGenerator.class);
    private ArchetypeArtifactManager archetypeArtifactManager;
    private ArchetypeFilesResolver archetypeFilesResolver;
    private PomManager pomManager;
    private VelocityComponent velocity;
    private static final Pattern TOKEN_PATTERN = Pattern.compile("__((?:[^_]+_)*[^_]+)__");

    @Inject
    public DefaultFilesetArchetypeGenerator(ArchetypeArtifactManager archetypeArtifactManager, ArchetypeFilesResolver archetypeFilesResolver, PomManager pomManager, VelocityComponent velocity) {
        this.archetypeArtifactManager = archetypeArtifactManager;
        this.archetypeFilesResolver = archetypeFilesResolver;
        this.pomManager = pomManager;
        this.velocity = velocity;
    }

    @Override
    public void generateArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws UnknownArchetype, ArchetypeNotConfigured, ProjectDirectoryExists, PomFileExists, OutputFileExists, ArchetypeGenerationFailure, InvalidPackaging {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            String postGenerationScript;
            ArchetypeDescriptor archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(archetypeFile);
            if (!this.isArchetypeConfigured(archetypeDescriptor, request)) {
                if (request.isInteractiveMode()) {
                    throw new ArchetypeNotConfigured("No archetype was chosen.", null);
                }
                StringBuilder exceptionMessage = new StringBuilder("Archetype " + request.getArchetypeGroupId() + ":" + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion() + " is not configured");
                ArrayList<String> missingProperties = new ArrayList<String>(0);
                for (RequiredProperty requiredProperty : archetypeDescriptor.getRequiredProperties()) {
                    if (!StringUtils.isEmpty((String)request.getProperties().getProperty(requiredProperty.getKey()))) continue;
                    exceptionMessage.append("\n\tProperty " + requiredProperty.getKey() + " is missing.");
                    missingProperties.add(requiredProperty.getKey());
                }
                throw new ArchetypeNotConfigured(exceptionMessage.toString(), missingProperties);
            }
            Context context = this.prepareVelocityContext(request);
            String packageName = request.getPackage();
            String artifactId = request.getArtifactId();
            File outputDirectoryFile = new File(request.getOutputDirectory(), artifactId);
            File basedirPom = new File(request.getOutputDirectory(), "pom.xml");
            File pom = new File(outputDirectoryFile, "pom.xml");
            List<String> archetypeResources = this.archetypeArtifactManager.getFilesetArchetypeResources(archetypeFile);
            ZipFile archetypeZipFile = this.archetypeArtifactManager.getArchetypeZipFile(archetypeFile);
            ClassLoader archetypeJarLoader = this.archetypeArtifactManager.getArchetypeJarLoader(archetypeFile);
            Thread.currentThread().setContextClassLoader(archetypeJarLoader);
            if (archetypeDescriptor.isPartial()) {
                LOGGER.debug("Processing partial archetype " + archetypeDescriptor.getName());
                if (outputDirectoryFile.exists()) {
                    if (!pom.exists()) {
                        throw new PomFileExists("This is a partial archetype and the pom.xml file doesn't exist.");
                    }
                    this.processPomWithMerge(context, pom, "");
                    this.processArchetypeTemplatesWithWarning(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, outputDirectoryFile);
                } else if (basedirPom.exists()) {
                    this.processPomWithMerge(context, basedirPom, "");
                    this.processArchetypeTemplatesWithWarning(archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, new File(request.getOutputDirectory()));
                } else {
                    this.processPom(context, pom, "");
                    this.processArchetypeTemplates((AbstractArchetypeDescriptor)archetypeDescriptor, archetypeResources, archetypeZipFile, "", context, packageName, outputDirectoryFile);
                }
                if (!archetypeDescriptor.getModules().isEmpty()) {
                    LOGGER.info("Modules ignored in partial mode");
                }
            } else {
                LOGGER.debug("Processing complete archetype " + archetypeDescriptor.getName());
                if (outputDirectoryFile.exists() && pom.exists()) {
                    throw new ProjectDirectoryExists("A Maven project already exists in the directory " + outputDirectoryFile.getPath());
                }
                if (outputDirectoryFile.exists()) {
                    LOGGER.warn("The directory " + outputDirectoryFile.getPath() + " already exists.");
                }
                context.put("rootArtifactId", (Object)artifactId);
                this.processFilesetModule(artifactId, artifactId, archetypeResources, pom, archetypeZipFile, "", basedirPom, outputDirectoryFile, packageName, (AbstractArchetypeDescriptor)archetypeDescriptor, context);
            }
            if ((postGenerationScript = this.archetypeArtifactManager.getPostGenerationScript(archetypeFile)) != null) {
                LOGGER.info("Executing META-INF/archetype-post-generate.groovy post-generation script");
                Binding binding = new Binding();
                Properties archetypeGeneratorProperties = new Properties();
                archetypeGeneratorProperties.putAll((Map<?, ?>)System.getProperties());
                if (request.getProperties() != null) {
                    archetypeGeneratorProperties.putAll((Map<?, ?>)request.getProperties());
                }
                for (Map.Entry<Object, Object> entry : archetypeGeneratorProperties.entrySet()) {
                    binding.setVariable(entry.getKey().toString(), entry.getValue());
                }
                binding.setVariable("request", (Object)request);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate(postGenerationScript);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Project created from Archetype in dir: " + outputDirectoryFile.getAbsolutePath());
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | XmlPullParserException | SAXException e) {
            throw new ArchetypeGenerationFailure(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public String getPackageAsDirectory(String packageName) {
        return StringUtils.replace((String)packageName, (String)".", (String)"/");
    }

    private boolean copyFile(File outFile, String template, boolean failIfExists, ZipFile archetypeZipFile) throws OutputFileExists, IOException {
        LOGGER.debug("Copying file " + template);
        if (failIfExists && outFile.exists()) {
            throw new OutputFileExists("Don't rewrite file " + outFile.getName());
        }
        if (outFile.exists()) {
            LOGGER.warn("CP Don't override file " + outFile);
            return false;
        }
        ZipEntry input = archetypeZipFile.getEntry("archetype-resources/" + template);
        if (input.isDirectory()) {
            outFile.mkdirs();
        } else {
            outFile.getParentFile().mkdirs();
            if (!outFile.exists() && !outFile.createNewFile()) {
                LOGGER.warn("Could not create new file \"" + outFile.getPath() + "\" or the file already exists.");
            }
            try (InputStream inputStream = archetypeZipFile.getInputStream(input);
                 OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);){
                IOUtil.copy((InputStream)inputStream, (OutputStream)out);
            }
        }
        return true;
    }

    private int copyFiles(String directory, List<String> fileSetResources, boolean packaged, String packageName, File outputDirectoryFile, ZipFile archetypeZipFile, String moduleOffset, boolean failIfExists, Context context) throws OutputFileExists, IOException {
        int count = 0;
        for (String template : fileSetResources) {
            File outputFile = this.getOutputFile(template, directory, outputDirectoryFile, packaged, packageName, moduleOffset, context);
            if (!this.copyFile(outputFile, template, failIfExists, archetypeZipFile)) continue;
            ++count;
        }
        return count;
    }

    private String getEncoding(String archetypeEncoding) {
        return archetypeEncoding == null || archetypeEncoding.isEmpty() ? "UTF-8" : archetypeEncoding;
    }

    private String getOffsetSeparator(String moduleOffset) {
        return moduleOffset == null || moduleOffset.isEmpty() ? "/" : "/" + moduleOffset + "/";
    }

    private File getOutputFile(String template, String directory, File outputDirectoryFile, boolean packaged, String packageName, String moduleOffset, Context context) {
        String templateName = StringUtils.replaceOnce((String)template, (String)directory, (String)"");
        String outputFileName = directory + "/" + (packaged ? this.getPackageAsDirectory(packageName) : "") + "/" + templateName.substring(moduleOffset.length());
        outputFileName = this.replaceFilenameTokens(outputFileName, context);
        return new File(outputDirectoryFile, outputFileName);
    }

    private String replaceFilenameTokens(String filePath, Context context) {
        StringBuffer interpolatedResult = new StringBuffer();
        Matcher matcher = TOKEN_PATTERN.matcher(filePath);
        while (matcher.find()) {
            String propertyToken = matcher.group(1);
            String contextPropertyValue = (String)context.get(propertyToken);
            if (contextPropertyValue != null && !contextPropertyValue.trim().isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Replacing property '" + propertyToken + "' in file path '" + filePath + "' with value '" + contextPropertyValue + "'.");
                }
                matcher.appendReplacement(interpolatedResult, contextPropertyValue);
                continue;
            }
            LOGGER.warn("Property '" + propertyToken + "' was not specified, so the token in '" + filePath + "' is not being replaced.");
        }
        matcher.appendTail(interpolatedResult);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Final interpolated file path: '" + interpolatedResult + "'");
        }
        return interpolatedResult.toString();
    }

    private String getPackageInPathFormat(String aPackage) {
        return StringUtils.replace((String)aPackage, (String)".", (String)"/");
    }

    private boolean isArchetypeConfigured(ArchetypeDescriptor archetypeDescriptor, ArchetypeGenerationRequest request) {
        for (RequiredProperty requiredProperty : archetypeDescriptor.getRequiredProperties()) {
            if (!StringUtils.isEmpty((String)request.getProperties().getProperty(requiredProperty.getKey()))) continue;
            return false;
        }
        return true;
    }

    private void setParentArtifactId(Context context, String artifactId) {
        context.put("parentArtifactId", (Object)artifactId);
    }

    private Context prepareVelocityContext(ArchetypeGenerationRequest request) {
        VelocityContext context = new VelocityContext();
        context.put("groupId", (Object)request.getGroupId());
        context.put("artifactId", (Object)request.getArtifactId());
        context.put("version", (Object)request.getVersion());
        context.put("package", (Object)request.getPackage());
        String packageInPathFormat = this.getPackageInPathFormat(request.getPackage());
        context.put("packageInPathFormat", (Object)packageInPathFormat);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("Using following parameters for creating project from Archetype: " + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion());
            LOGGER.info("----------------------------------------------------------------------------");
            LOGGER.info("Parameter: groupId, Value: " + request.getGroupId());
            LOGGER.info("Parameter: artifactId, Value: " + request.getArtifactId());
            LOGGER.info("Parameter: version, Value: " + request.getVersion());
            LOGGER.info("Parameter: package, Value: " + request.getPackage());
            LOGGER.info("Parameter: packageInPathFormat, Value: " + packageInPathFormat);
        }
        for (String string : request.getProperties().keySet()) {
            String value = request.getProperties().getProperty(string);
            if (this.maybeVelocityExpression(value)) {
                value = this.evaluateExpression((Context)context, string, value);
            }
            context.put(string, (Object)value);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("Parameter: " + string + ", Value: " + value);
        }
        return context;
    }

    private boolean maybeVelocityExpression(String value) {
        return value != null && value.contains("${");
    }

    private String evaluateExpression(Context context, String key, String value) {
        String string;
        StringWriter stringWriter = new StringWriter();
        try {
            this.velocity.getEngine().evaluate(context, (Writer)stringWriter, key, value);
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return value;
            }
        }
        stringWriter.close();
        return string;
    }

    private void processArchetypeTemplates(AbstractArchetypeDescriptor archetypeDescriptor, List<String> archetypeResources, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile) throws OutputFileExists, ArchetypeGenerationFailure, IOException {
        this.processTemplates(packageName, outputDirectoryFile, context, archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, false);
    }

    private void processArchetypeTemplatesWithWarning(ArchetypeDescriptor archetypeDescriptor, List<String> archetypeResources, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile) throws OutputFileExists, ArchetypeGenerationFailure, IOException {
        this.processTemplates(packageName, outputDirectoryFile, context, (AbstractArchetypeDescriptor)archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, true);
    }

    private int processFileSet(String directory, List<String> fileSetResources, boolean packaged, String packageName, Context context, File outputDirectoryFile, String moduleOffset, String archetypeEncoding, boolean failIfExists) throws IOException, OutputFileExists, ArchetypeGenerationFailure {
        int count = 0;
        for (String template : fileSetResources) {
            File outputFile = this.getOutputFile(template, directory, outputDirectoryFile, packaged, packageName, moduleOffset, context);
            if (!this.processTemplate(outputFile, context, "archetype-resources/" + template, archetypeEncoding, failIfExists)) continue;
            ++count;
        }
        return count;
    }

    private void processFilesetModule(String rootArtifactId, String artifactId, List<String> archetypeResources, File pom, ZipFile archetypeZipFile, String moduleOffset, File basedirPom, File outputDirectoryFile, String packageName, AbstractArchetypeDescriptor archetypeDescriptor, Context context) throws XmlPullParserException, IOException, ParserConfigurationException, SAXException, TransformerException, OutputFileExists, ArchetypeGenerationFailure, InvalidPackaging {
        outputDirectoryFile.mkdirs();
        LOGGER.debug("Processing module " + artifactId);
        LOGGER.debug("Processing module rootArtifactId " + rootArtifactId);
        LOGGER.debug("Processing module pom " + pom);
        LOGGER.debug("Processing module moduleOffset " + moduleOffset);
        LOGGER.debug("Processing module outputDirectoryFile " + outputDirectoryFile);
        this.processFilesetProject(archetypeDescriptor, StringUtils.replace((String)artifactId, (String)"${rootArtifactId}", (String)rootArtifactId), archetypeResources, pom, archetypeZipFile, moduleOffset, context, packageName, outputDirectoryFile, basedirPom);
        String parentArtifactId = (String)context.get("parentArtifactId");
        Iterator subprojects = archetypeDescriptor.getModules().iterator();
        if (subprojects.hasNext()) {
            LOGGER.debug(artifactId + " has modules (" + archetypeDescriptor.getModules() + ")");
            this.setParentArtifactId(context, StringUtils.replace((String)artifactId, (String)"${rootArtifactId}", (String)rootArtifactId));
        }
        while (subprojects.hasNext()) {
            ModuleDescriptor project = (ModuleDescriptor)subprojects.next();
            String modulePath = StringUtils.replace((String)project.getDir(), (String)"__rootArtifactId__", (String)rootArtifactId);
            modulePath = this.replaceFilenameTokens(modulePath, context);
            File moduleOutputDirectoryFile = new File(outputDirectoryFile, modulePath);
            context.put("artifactId", (Object)StringUtils.replace((String)project.getId(), (String)"${rootArtifactId}", (String)rootArtifactId));
            String moduleArtifactId = StringUtils.replace((String)project.getDir(), (String)"__rootArtifactId__", (String)rootArtifactId);
            moduleArtifactId = this.replaceFilenameTokens(moduleArtifactId, context);
            this.processFilesetModule(rootArtifactId, moduleArtifactId, archetypeResources, new File(moduleOutputDirectoryFile, "pom.xml"), archetypeZipFile, (moduleOffset == null || moduleOffset.isEmpty() ? "" : moduleOffset + "/") + StringUtils.replace((String)project.getDir(), (String)"${rootArtifactId}", (String)rootArtifactId), pom, moduleOutputDirectoryFile, packageName, (AbstractArchetypeDescriptor)project, context);
        }
        this.restoreParentArtifactId(context, parentArtifactId);
        LOGGER.debug("Processed " + artifactId);
    }

    private void processFilesetProject(AbstractArchetypeDescriptor archetypeDescriptor, String moduleId, List<String> archetypeResources, File pom, ZipFile archetypeZipFile, String moduleOffset, Context context, String packageName, File outputDirectoryFile, File basedirPom) throws XmlPullParserException, IOException, ParserConfigurationException, SAXException, TransformerException, OutputFileExists, ArchetypeGenerationFailure, InvalidPackaging {
        LOGGER.debug("Processing fileset project moduleId " + moduleId);
        LOGGER.debug("Processing fileset project pom " + pom);
        LOGGER.debug("Processing fileset project moduleOffset " + moduleOffset);
        LOGGER.debug("Processing fileset project outputDirectoryFile " + outputDirectoryFile);
        LOGGER.debug("Processing fileset project basedirPom " + basedirPom);
        if (basedirPom.exists()) {
            this.processPomWithParent(context, pom, moduleOffset, basedirPom, moduleId);
        } else {
            this.processPom(context, pom, moduleOffset);
        }
        this.processArchetypeTemplates(archetypeDescriptor, archetypeResources, archetypeZipFile, moduleOffset, context, packageName, outputDirectoryFile);
    }

    private void processPom(Context context, File pom, String moduleOffset) throws IOException, OutputFileExists, ArchetypeGenerationFailure {
        LOGGER.debug("Processing pom " + pom);
        this.processTemplate(pom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
    }

    private void processPomWithMerge(Context context, File pom, String moduleOffset) throws OutputFileExists, IOException, XmlPullParserException, ArchetypeGenerationFailure {
        LOGGER.debug("Processing pom " + pom + " with merge");
        File temporaryPom = this.getTemporaryFile(pom);
        this.processTemplate(temporaryPom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
        this.pomManager.mergePoms(pom, temporaryPom);
        try {
            FileUtils.forceDelete((File)temporaryPom);
        }
        catch (IOException e) {
            temporaryPom.deleteOnExit();
        }
    }

    private void processPomWithParent(Context context, File pom, String moduleOffset, File basedirPom, String moduleId) throws XmlPullParserException, IOException, ParserConfigurationException, SAXException, TransformerException, OutputFileExists, ArchetypeGenerationFailure, InvalidPackaging {
        LOGGER.debug("Processing pom " + pom + " with parent " + basedirPom);
        this.processTemplate(pom, context, "archetype-resources" + this.getOffsetSeparator(moduleOffset) + "pom.xml", this.getEncoding(null), true);
        LOGGER.debug("Adding module " + moduleId);
        this.pomManager.addModule(basedirPom, moduleId);
        this.pomManager.addParent(pom, basedirPom);
    }

    private boolean processTemplate(File outFile, Context context, String templateFileName, String encoding, boolean failIfExists) throws IOException, OutputFileExists, ArchetypeGenerationFailure {
        String localTemplateFileName;
        if (!(templateFileName = templateFileName.replace(File.separatorChar, '/')).equals(localTemplateFileName = templateFileName.replace('/', File.separatorChar)) && !this.velocity.getEngine().resourceExists(templateFileName) && this.velocity.getEngine().resourceExists(localTemplateFileName)) {
            templateFileName = localTemplateFileName;
        }
        LOGGER.debug("Processing template " + templateFileName);
        if (outFile.exists()) {
            if (failIfExists) {
                throw new OutputFileExists("Don't override file " + outFile.getAbsolutePath());
            }
            LOGGER.warn("Don't override file " + outFile);
            return false;
        }
        if (templateFileName.endsWith("/")) {
            LOGGER.debug("Creating directory " + outFile);
            outFile.mkdirs();
            return true;
        }
        if (!outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        if (!outFile.exists() && !outFile.createNewFile()) {
            LOGGER.warn("Could not create new file \"" + outFile.getPath() + "\" or the file already exists.");
        }
        LOGGER.debug("Merging into " + outFile);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(outFile.toPath(), new OpenOption[0]), encoding);){
            StringWriter stringWriter = new StringWriter();
            this.velocity.getEngine().mergeTemplate(templateFileName, encoding, context, (Writer)stringWriter);
            writer.write(StringUtils.unifyLineSeparators((String)stringWriter.toString()));
        }
        catch (Exception e) {
            throw new ArchetypeGenerationFailure("Error merging velocity templates: " + e.getMessage(), e);
        }
        return true;
    }

    private void processTemplates(String packageName, File outputDirectoryFile, Context context, AbstractArchetypeDescriptor archetypeDescriptor, List<String> archetypeResources, ZipFile archetypeZipFile, String moduleOffset, boolean failIfExists) throws OutputFileExists, ArchetypeGenerationFailure, IOException {
        Iterator iterator = archetypeDescriptor.getFileSets().iterator();
        if (iterator.hasNext()) {
            LOGGER.debug("Processing filesets\n  " + archetypeResources);
        }
        int count = 0;
        while (iterator.hasNext()) {
            String evaluatedCondition;
            FileSet fileSet = (FileSet)iterator.next();
            ++count;
            String includeCondition = fileSet.getIncludeCondition();
            if (includeCondition != null && !includeCondition.isEmpty() && !Boolean.parseBoolean(evaluatedCondition = this.evaluateExpression(context, "includeCondition", includeCondition))) {
                LOGGER.debug(String.format("Skipping fileset %s due to includeCondition: %s being: %s", fileSet, includeCondition, evaluatedCondition));
                continue;
            }
            List<String> fileSetResources = this.archetypeFilesResolver.filterFiles(moduleOffset, fileSet, archetypeResources);
            this.getOutputFile(moduleOffset, fileSet.getDirectory(), outputDirectoryFile, fileSet.isPackaged(), packageName, moduleOffset, context).mkdirs();
            if (fileSet.isFiltered()) {
                LOGGER.debug("    Processing fileset " + fileSet + " -> " + fileSetResources.size() + ":\n      " + fileSetResources);
                int processed = this.processFileSet(fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, context, outputDirectoryFile, moduleOffset, this.getEncoding(fileSet.getEncoding()), failIfExists);
                LOGGER.debug("    Processed " + processed + " files.");
                continue;
            }
            LOGGER.debug("    Copying fileset " + fileSet + " -> " + fileSetResources.size() + ":\n      " + fileSetResources);
            int copied = this.copyFiles(fileSet.getDirectory(), fileSetResources, fileSet.isPackaged(), packageName, outputDirectoryFile, archetypeZipFile, moduleOffset, failIfExists, context);
            LOGGER.debug("    Copied " + copied + " files.");
        }
        LOGGER.debug("Processed " + count + " filesets");
    }

    private void restoreParentArtifactId(Context context, String parentArtifactId) {
        if (parentArtifactId == null || parentArtifactId.isEmpty()) {
            context.remove("parentArtifactId");
        } else {
            context.put("parentArtifactId", (Object)parentArtifactId);
        }
    }

    private File getTemporaryFile(File file) {
        File tmp = FileUtils.createTempFile((String)file.getName(), (String)".tmp", (File)file.getParentFile());
        tmp.deleteOnExit();
        return tmp;
    }
}

