/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.ArchetypeException;
import org.apache.maven.archetype.exception.ArchetypeGenerationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.generator.FilesetArchetypeGenerator;
import org.apache.maven.archetype.old.OldArchetype;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;

@Named
@Singleton
public class DefaultArchetypeGenerator
implements ArchetypeGenerator {
    private ArchetypeArtifactManager archetypeArtifactManager;
    private FilesetArchetypeGenerator filesetGenerator;
    private OldArchetype oldArchetype;
    private RepositorySystem repositorySystem;

    @Inject
    public DefaultArchetypeGenerator(ArchetypeArtifactManager archetypeArtifactManager, FilesetArchetypeGenerator filesetGenerator, OldArchetype oldArchetype, RepositorySystem repositorySystem) {
        this.archetypeArtifactManager = archetypeArtifactManager;
        this.filesetGenerator = filesetGenerator;
        this.oldArchetype = oldArchetype;
        this.repositorySystem = repositorySystem;
    }

    private File getArchetypeFile(ArchetypeGenerationRequest request) throws ArchetypeException {
        if (!this.isArchetypeDefined(request)) {
            throw new ArchetypeNotDefined("The archetype is not defined");
        }
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>(request.getRemoteRepositories());
        if (request != null && request.getArchetypeRepository() != null) {
            RepositorySystemSession repositorySession = request.getRepositorySession();
            RemoteRepository remoteRepo = this.createRepository(repositorySession, request.getArchetypeRepository(), request.getArchetypeArtifactId() + "-repo");
            repos.add(remoteRepo);
        }
        if (!this.archetypeArtifactManager.exists(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), repos, request.getRepositorySession())) {
            throw new UnknownArchetype("The desired archetype does not exist (" + request.getArchetypeGroupId() + ":" + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion() + ")");
        }
        return this.archetypeArtifactManager.getArchetypeFile(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), repos, request.getRepositorySession());
    }

    private void generateArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeException {
        if (this.archetypeArtifactManager.isFileSetArchetype(archetypeFile)) {
            this.processFileSetArchetype(request, archetypeFile);
        } else if (this.archetypeArtifactManager.isOldArchetype(archetypeFile)) {
            this.processOldArchetype(request, archetypeFile);
        } else {
            throw new ArchetypeGenerationFailure("The defined artifact is not an archetype: " + archetypeFile);
        }
    }

    public String getPackageAsDirectory(String packageName) {
        return StringUtils.replace((String)packageName, (String)".", (String)"/");
    }

    private boolean isArchetypeDefined(ArchetypeGenerationRequest request) {
        return StringUtils.isNotEmpty((String)request.getArchetypeGroupId()) && StringUtils.isNotEmpty((String)request.getArchetypeArtifactId()) && StringUtils.isNotEmpty((String)request.getArchetypeVersion());
    }

    private void processFileSetArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeException {
        this.filesetGenerator.generateArchetype(request, archetypeFile);
    }

    private void processOldArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeGenerationFailure, InvalidPackaging {
        this.oldArchetype.createArchetype(request, archetypeFile);
    }

    @Override
    public void generateArchetype(ArchetypeGenerationRequest request, File archetypeFile, ArchetypeGenerationResult result) {
        try {
            this.generateArchetype(request, archetypeFile);
        }
        catch (ArchetypeException e) {
            result.setCause(e);
        }
    }

    @Override
    public void generateArchetype(ArchetypeGenerationRequest request, ArchetypeGenerationResult result) {
        try {
            File archetypeFile = this.getArchetypeFile(request);
            this.generateArchetype(request, archetypeFile, result);
        }
        catch (ArchetypeException ex) {
            result.setCause(ex);
        }
    }

    private RemoteRepository createRepository(RepositorySystemSession repositorySession, String url, String repositoryId) {
        RepositoryPolicy repositoryPolicy = new RepositoryPolicy(true, "always", "warn");
        RemoteRepository remoteRepository = new RemoteRepository.Builder(repositoryId, "default", url).setSnapshotPolicy(repositoryPolicy).setReleasePolicy(repositoryPolicy).build();
        return (RemoteRepository)this.repositorySystem.newResolutionRepositories(repositorySession, Collections.singletonList(remoteRepository)).get(0);
    }
}

