/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Reader;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptorBuilder;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultArchetypeArtifactManager
implements ArchetypeArtifactManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArchetypeArtifactManager.class);
    @Inject
    private Downloader downloader;
    @Inject
    private PomManager pomManager;
    private Map<String, File> archetypeCache = new TreeMap<String, File>();

    @Override
    public File getArchetypeFile(String groupId, String artifactId, String version, List<RemoteRepository> repositories, RepositorySystemSession repositorySystemSession) throws UnknownArchetype {
        try {
            File archetype = this.getArchetype(groupId, artifactId, version);
            if (archetype == null) {
                archetype = this.downloader.download(groupId, artifactId, version, repositories, repositorySystemSession);
                this.setArchetype(groupId, artifactId, version, archetype);
            }
            return archetype;
        }
        catch (DownloadException ex) {
            throw new UnknownArchetype(ex);
        }
    }

    @Override
    public ClassLoader getArchetypeJarLoader(File archetypeFile) throws UnknownArchetype {
        try {
            URL[] urls = new URL[]{archetypeFile.toURI().toURL()};
            return new URLClassLoader(urls);
        }
        catch (MalformedURLException e) {
            throw new UnknownArchetype(e);
        }
    }

    @Override
    public Model getArchetypePom(File jar) throws XmlPullParserException, UnknownArchetype, IOException {
        try (ZipFile zipFile = this.getArchetypeZipFile(jar);){
            Model model;
            ZipEntry el;
            String pomFileName = null;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                el = enumeration.nextElement();
                String entry = el.getName();
                if (!entry.startsWith("META-INF") || !entry.endsWith("pom.xml")) continue;
                pomFileName = entry;
            }
            if (pomFileName == null) {
                el = null;
                return el;
            }
            ZipEntry pom = zipFile.getEntry(pomFileName);
            if (pom == null) {
                model = null;
                return model;
            }
            model = this.pomManager.readPom(zipFile.getInputStream(pom));
            return model;
        }
    }

    @Override
    public ZipFile getArchetypeZipFile(File archetypeFile) throws UnknownArchetype {
        try {
            return new ZipFile(archetypeFile);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    @Override
    public boolean isFileSetArchetype(File archetypeFile) {
        boolean bl;
        block8: {
            LOGGER.debug("checking fileset archetype status on " + archetypeFile);
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            try {
                bl = this.isFileSetArchetype(zipFile);
                if (zipFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UnknownArchetype e) {
                    LOGGER.debug(e.toString());
                    return false;
                }
            }
            zipFile.close();
        }
        return bl;
    }

    @Override
    public boolean isOldArchetype(File archetypeFile) {
        boolean bl;
        block8: {
            LOGGER.debug("checking old archetype status on " + archetypeFile);
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            try {
                bl = this.isOldArchetype(zipFile);
                if (zipFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UnknownArchetype e) {
                    LOGGER.debug(e.toString());
                    return false;
                }
            }
            zipFile.close();
        }
        return bl;
    }

    @Override
    public boolean exists(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, List<RemoteRepository> remoteRepositories, RepositorySystemSession repositorySystemSession) {
        try {
            File archetype = this.getArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion);
            if (archetype == null) {
                archetype = this.downloader.download(archetypeGroupId, archetypeArtifactId, archetypeVersion, remoteRepositories, repositorySystemSession);
                this.setArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetype);
            }
            return archetype.exists();
        }
        catch (DownloadException e) {
            LOGGER.debug("Archetype " + archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion + " doesn't exist", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getPostGenerationScript(File archetypeFile) throws UnknownArchetype {
        String string;
        block8: {
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            try {
                Reader reader = this.getDescriptorReader(zipFile, "META-INF/archetype-post-generate.groovy");
                String string2 = string = reader == null ? null : IOUtils.toString((Reader)reader);
                if (zipFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnknownArchetype(e);
                }
            }
            zipFile.close();
        }
        return string;
    }

    @Override
    public org.apache.maven.archetype.metadata.ArchetypeDescriptor getFileSetArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor;
        block8: {
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            try {
                archetypeDescriptor = this.loadFileSetArchetypeDescriptor(zipFile);
                if (zipFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new UnknownArchetype(e);
                }
            }
            zipFile.close();
        }
        return archetypeDescriptor;
    }

    @Override
    public List<String> getFilesetArchetypeResources(File archetypeFile) throws UnknownArchetype {
        ArrayList<String> arrayList;
        block10: {
            LOGGER.debug("getFilesetArchetypeResources( \"" + archetypeFile.getAbsolutePath() + "\" )");
            ArrayList<String> archetypeResources = new ArrayList<String>();
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            try {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry entry = enumeration.nextElement();
                    if (entry.getName().startsWith("archetype-resources")) {
                        String resource = entry.getName().substring("archetype-resources".length() + 1);
                        LOGGER.debug("  - found resource (archetype-resources/)" + resource);
                        archetypeResources.add(resource);
                        continue;
                    }
                    LOGGER.debug("  - ignored resource " + entry.getName());
                }
                arrayList = archetypeResources;
                if (zipFile == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnknownArchetype(e);
                }
            }
            zipFile.close();
        }
        return arrayList;
    }

    @Override
    public ArchetypeDescriptor getOldArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        ArchetypeDescriptor archetypeDescriptor;
        block8: {
            ZipFile zipFile = this.getArchetypeZipFile(archetypeFile);
            try {
                archetypeDescriptor = this.loadOldArchetypeDescriptor(zipFile);
                if (zipFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new UnknownArchetype(e);
                }
            }
            zipFile.close();
        }
        return archetypeDescriptor;
    }

    private File getArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        if (this.archetypeCache.containsKey(key)) {
            LOGGER.debug("Found archetype " + key + " in cache: " + this.archetypeCache.get(key));
            return this.archetypeCache.get(key);
        }
        LOGGER.debug("Not found archetype " + key + " in cache");
        return null;
    }

    private void setArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, File archetype) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        this.archetypeCache.put(key, archetype);
    }

    private boolean isFileSetArchetype(ZipFile zipFile) throws IOException {
        try (Reader reader = this.getArchetypeDescriptorReader(zipFile);){
            boolean bl = reader != null;
            return bl;
        }
    }

    private boolean isOldArchetype(ZipFile zipFile) throws IOException {
        try (Reader reader = this.getOldArchetypeDescriptorReader(zipFile);){
            boolean bl = reader != null;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private org.apache.maven.archetype.metadata.ArchetypeDescriptor loadFileSetArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        try (Reader reader = this.getArchetypeDescriptorReader(zipFile);){
            if (reader == null) {
                org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor2 = null;
                return archetypeDescriptor2;
            }
            ArchetypeDescriptorXpp3Reader archetypeReader = new ArchetypeDescriptorXpp3Reader();
            org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = archetypeReader.read(reader, false);
            return archetypeDescriptor;
        }
    }

    private ArchetypeDescriptor loadOldArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        try (Reader reader = this.getOldArchetypeDescriptorReader(zipFile);){
            if (reader == null) {
                ArchetypeDescriptor archetypeDescriptor = null;
                return archetypeDescriptor;
            }
            ArchetypeDescriptorBuilder builder = new ArchetypeDescriptorBuilder();
            ArchetypeDescriptor archetypeDescriptor = builder.build(reader);
            return archetypeDescriptor;
        }
    }

    private Reader getArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        return this.getDescriptorReader(zipFile, "META-INF/maven/archetype-metadata.xml");
    }

    private Reader getOldArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        Reader reader = this.getDescriptorReader(zipFile, "META-INF/maven/archetype.xml");
        if (reader == null) {
            reader = this.getDescriptorReader(zipFile, "META-INF/archetype.xml");
        }
        return reader;
    }

    private Reader getDescriptorReader(ZipFile zipFile, String descriptor) throws IOException {
        ZipEntry entry = this.searchEntry(zipFile, descriptor);
        if (entry == null) {
            return null;
        }
        InputStream is = zipFile.getInputStream(entry);
        if (is == null) {
            throw new IOException("The " + descriptor + " descriptor cannot be read in " + zipFile.getName() + ".");
        }
        return new InputStreamReader(is, StandardCharsets.UTF_8);
    }

    private ZipEntry searchEntry(ZipFile zipFile, String searchString) {
        LOGGER.debug("Searching for " + searchString + " inside " + zipFile.getName());
        Enumeration<? extends ZipEntry> enu = zipFile.entries();
        while (enu.hasMoreElements()) {
            ZipEntry entryfound = enu.nextElement();
            LOGGER.debug("  - " + entryfound.getName());
            if (!searchString.equals(entryfound.getName())) continue;
            LOGGER.debug("Entry found");
            return entryfound;
        }
        return null;
    }
}

