/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.ArchetypeCreationRequest;
import org.apache.maven.archetype.ArchetypeCreationResult;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.creator.ArchetypeCreator;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultArchetypeManager
implements ArchetypeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArchetypeManager.class);
    @Inject
    @Named(value="fileset")
    private ArchetypeCreator creator;
    @Inject
    private ArchetypeGenerator generator;
    @Inject
    private Map<String, ArchetypeDataSource> archetypeSources;

    @Override
    public ArchetypeCreationResult createArchetypeFromProject(ArchetypeCreationRequest request) {
        ArchetypeCreationResult result = new ArchetypeCreationResult();
        this.creator.createArchetype(request, result);
        return result;
    }

    @Override
    public ArchetypeGenerationResult generateProjectFromArchetype(ArchetypeGenerationRequest request) {
        ArchetypeGenerationResult result = new ArchetypeGenerationResult();
        this.generator.generateArchetype(request, result);
        return result;
    }

    @Override
    public File archiveArchetype(File archetypeDirectory, File outputDirectory, String finalName) throws IOException {
        File jarFile = new File(outputDirectory, finalName + ".jar");
        this.zip(archetypeDirectory, jarFile);
        return jarFile;
    }

    public void zip(File sourceDirectory, File archive) throws IOException {
        if (!archive.getParentFile().exists()) {
            archive.getParentFile().mkdirs();
        }
        if (!archive.exists() && !archive.createNewFile()) {
            LOGGER.warn("Could not create new file \"" + archive.getPath() + "\" or the file already exists.");
        }
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(archive.toPath(), new OpenOption[0]));){
            zos.setLevel(9);
            this.zipper(zos, sourceDirectory.getAbsolutePath().length(), sourceDirectory);
        }
    }

    private void zipper(ZipOutputStream zos, int offset, File currentSourceDirectory) throws IOException {
        File[] files = currentSourceDirectory.listFiles();
        if (files.length == 0) {
            String dirName = currentSourceDirectory.getAbsolutePath().substring(offset + 1);
            if (File.separatorChar != '/') {
                dirName = dirName.replace('\\', '/');
            }
            zos.putNextEntry(new ZipEntry(dirName + '/'));
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.zipper(zos, offset, files[i]);
                continue;
            }
            String fileName = files[i].getAbsolutePath().substring(offset + 1);
            if (File.separatorChar != '/') {
                fileName = fileName.replace('\\', '/');
            }
            ZipEntry e = new ZipEntry(fileName);
            zos.putNextEntry(e);
            try (FileInputStream is = new FileInputStream(files[i]);){
                IOUtil.copy((InputStream)is, (OutputStream)zos);
            }
            zos.closeEntry();
        }
    }

    @Override
    public ArchetypeCatalog getInternalCatalog() {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("internal-catalog");
            return source.getArchetypeCatalog(null, null);
        }
        catch (ArchetypeDataSourceException e) {
            LOGGER.warn("failed to read catalog: " + e.getMessage(), (Throwable)(LOGGER.isDebugEnabled() ? e : null));
            return new ArchetypeCatalog();
        }
    }

    @Override
    public ArchetypeCatalog getLocalCatalog(RepositorySystemSession repositorySession) {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("catalog");
            return source.getArchetypeCatalog(repositorySession, null);
        }
        catch (ArchetypeDataSourceException e) {
            LOGGER.warn("failed to read catalog: " + e.getMessage(), (Throwable)(LOGGER.isDebugEnabled() ? e : null));
            return new ArchetypeCatalog();
        }
    }

    @Override
    public ArchetypeCatalog getRemoteCatalog(RepositorySystemSession repositorySession, List<RemoteRepository> remoteRepositories) {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("remote-catalog");
            return source.getArchetypeCatalog(repositorySession, remoteRepositories);
        }
        catch (ArchetypeDataSourceException e) {
            LOGGER.warn("failed to download from remote" + e.getMessage(), (Throwable)(LOGGER.isDebugEnabled() ? e : null));
            return new ArchetypeCatalog();
        }
    }

    @Override
    public File updateLocalCatalog(RepositorySystemSession repositorySystemSession, Archetype archetype) {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("catalog");
            return source.updateCatalog(repositorySystemSession, archetype);
        }
        catch (ArchetypeDataSourceException e) {
            LOGGER.warn("failed to update catalog", (Throwable)e);
            return null;
        }
    }
}

