/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.archetype.source.CatalogArchetypeDataSource;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="remote-catalog")
@Singleton
public class RemoteCatalogArchetypeDataSource
extends CatalogArchetypeDataSource
implements ArchetypeDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteCatalogArchetypeDataSource.class);
    @Inject
    private RepositorySystem repositorySystem;
    public static final String ARCHETYPE_REPOSITORY_ID = "archetype";
    public static final String CENTRAL_REPOSITORY_ID = "central";

    @Override
    public ArchetypeCatalog getArchetypeCatalog(RepositorySystemSession repositorySession, List<RemoteRepository> remoteRepositories) throws ArchetypeDataSourceException {
        MetadataRequest request = new MetadataRequest();
        request.setRepository(this.getRemoteRepo(remoteRepositories));
        request.setMetadata((Metadata)new DefaultMetadata("archetype-catalog.xml", Metadata.Nature.RELEASE));
        MetadataResult metadataResult = (MetadataResult)this.repositorySystem.resolveMetadata(repositorySession, Collections.singletonList(request)).get(0);
        if (metadataResult.isResolved()) {
            try {
                return this.readCatalog((Reader)new XmlStreamReader(metadataResult.getMetadata().getFile()));
            }
            catch (IOException e) {
                throw new ArchetypeDataSourceException(e);
            }
        }
        throw new ArchetypeDataSourceException(metadataResult.getException());
    }

    private RemoteRepository getRemoteRepo(List<RemoteRepository> remoteRepositories) {
        if (remoteRepositories == null || remoteRepositories.isEmpty()) {
            return null;
        }
        for (RemoteRepository remoteRepository : remoteRepositories) {
            if (ARCHETYPE_REPOSITORY_ID.equals(remoteRepository.getId())) {
                return remoteRepository;
            }
            if (CENTRAL_REPOSITORY_ID.equals(remoteRepository.getId())) {
                return remoteRepository;
            }
            if (this.getRemoteRepo(remoteRepository.getMirroredRepositories()) == null) continue;
            return remoteRepository;
        }
        return null;
    }

    @Override
    public File updateCatalog(RepositorySystemSession repositorySession, Archetype archetype) throws ArchetypeDataSourceException {
        throw new ArchetypeDataSourceException("Not supported yet.");
    }
}

