/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.archetype.source.CatalogArchetypeDataSource;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="internal-catalog")
@Singleton
public class InternalCatalogArchetypeDataSource
extends CatalogArchetypeDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalCatalogArchetypeDataSource.class);

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ArchetypeCatalog getArchetypeCatalog(RepositorySystemSession repositorySession, List<RemoteRepository> remoteRepositories) throws ArchetypeDataSourceException {
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("archetype-catalog.xml");){
            ArchetypeCatalog archetypeCatalog;
            try (XmlStreamReader reader = new XmlStreamReader(in);){
                archetypeCatalog = this.readCatalog((Reader)reader);
            }
            return archetypeCatalog;
        }
        catch (IOException e) {
            throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
        }
    }

    @Override
    public File updateCatalog(RepositorySystemSession repositorySession, Archetype archetype) throws ArchetypeDataSourceException {
        throw new ArchetypeDataSourceException("Not supported yet.");
    }
}

