/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Writer;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CatalogArchetypeDataSource
implements ArchetypeDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogArchetypeDataSource.class);

    protected void writeLocalCatalog(ArchetypeCatalog catalog, File catalogFile) throws ArchetypeDataSourceException {
        try (XmlStreamWriter writer = new XmlStreamWriter(catalogFile);){
            ArchetypeCatalogXpp3Writer catalogWriter = new ArchetypeCatalogXpp3Writer();
            catalogWriter.write((Writer)writer, catalog);
        }
        catch (IOException e) {
            throw new ArchetypeDataSourceException("Error writing archetype catalog.", e);
        }
    }

    protected ArchetypeCatalog readCatalog(Reader reader) throws ArchetypeDataSourceException {
        ArchetypeCatalog archetypeCatalog;
        block9: {
            Reader catReader = reader;
            try {
                ArchetypeCatalogXpp3Reader catalogReader = new ArchetypeCatalogXpp3Reader();
                archetypeCatalog = catalogReader.read(catReader);
                if (catReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (catReader != null) {
                        try {
                            catReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ArchetypeDataSourceException("Error reading archetype catalog.", e);
                }
                catch (XmlPullParserException e) {
                    throw new ArchetypeDataSourceException("Error parsing archetype catalog.", e);
                }
            }
            catReader.close();
        }
        return archetypeCatalog;
    }
}

