/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.status.StatusLogger;

public final class Configurator {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String FQCN = Configurator.class.getName();

    private Configurator() {
    }

    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation) {
        return Configurator.initialize(name, loader, configLocation, null);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, String configLocation, Object externalContext) {
        try {
            URI uri = configLocation == null ? null : FileUtils.getCorrectedFilePathUri(configLocation);
            return Configurator.initialize(name, loader, uri, externalContext);
        }
        catch (URISyntaxException ex) {
            LOGGER.error("There was a problem parsing the configuration location [{}].", new Object[]{configLocation, ex});
            return null;
        }
    }

    public static LoggerContext initialize(String name, String configLocation) {
        return Configurator.initialize(name, null, configLocation);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation) {
        return Configurator.initialize(name, loader, configLocation, null);
    }

    public static LoggerContext initialize(String name, ClassLoader loader, URI configLocation, Object externalContext) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            return factory == null ? null : factory.getContext(FQCN, loader, externalContext, false, configLocation, name);
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem initializing the LoggerContext [{}] using configuration at [{}].", new Object[]{name, configLocation, ex});
            return null;
        }
    }

    public static LoggerContext initialize(ClassLoader loader, ConfigurationSource source) {
        return Configurator.initialize(loader, source, null);
    }

    public static LoggerContext initialize(ClassLoader loader, ConfigurationSource source, Object externalContext) {
        try {
            Log4jContextFactory factory = Configurator.getFactory();
            return factory == null ? null : factory.getContext(FQCN, loader, externalContext, false, source);
        }
        catch (Exception ex) {
            LOGGER.error("There was a problem obtaining a LoggerContext using the configuration source [{}]", new Object[]{source, ex});
            return null;
        }
    }

    private static Log4jContextFactory getFactory() {
        LoggerContextFactory factory = LogManager.getFactory();
        if (factory instanceof Log4jContextFactory) {
            return (Log4jContextFactory)factory;
        }
        if (factory != null) {
            LOGGER.error("LogManager returned an instance of {} which does not implement {}. Unable to initialize Log4j.", new Object[]{factory.getClass().getName(), Log4jContextFactory.class.getName()});
            return null;
        }
        LOGGER.error("LogManager did not return a LoggerContextFactory. This indicates something has gone terribly wrong!");
        return null;
    }

    public static void shutdown(LoggerContext ctx) {
        if (ctx != null) {
            ctx.stop();
        }
    }
}

