/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.Log;
import kafka.log.LogSegment;
import kafka.log.OffsetsToClean;
import kafka.utils.Logging;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$ = new LogCleanerManager$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public long maxCompactionDelay(Log log, long firstDirtyOffset, long now) {
        long max_y;
        Iterable<LogSegment> dirtyNonActiveSegments = log.nonActiveLogSegmentsFrom(firstDirtyOffset);
        Iterable firstBatchTimestamps = (Iterable)log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 > 0L);
        long earliestDirtySegmentTimestamp = firstBatchTimestamps.nonEmpty() ? BoxesRunTime.unboxToLong((Object)firstBatchTimestamps.min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long l = BoxesRunTime.unboxToLong((Object)log.config().maxCompactionLagMs());
        long l2 = Math.max(l, max_y = 0L);
        long cleanUntilTime = now - l2;
        if (earliestDirtySegmentTimestamp < cleanUntilTime) {
            return cleanUntilTime - earliestDirtySegmentTimestamp;
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public OffsetsToClean cleanableOffsets(Log log, Option<Object> lastCleanOffset, long now) {
        void var12_12;
        None$ none$;
        void var10_11;
        Tuple2.mcJZ.sp sp2;
        Object object;
        long logStartOffset = log.logStartOffset();
        if (lastCleanOffset == null) {
            throw null;
        }
        if (lastCleanOffset.isEmpty()) {
            Long l;
            Long l2 = l = Long.valueOf(logStartOffset);
            l = null;
            object = l2;
        } else {
            object = lastCleanOffset.get();
        }
        Object object2 = object;
        object = null;
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong((Object)object2);
        if (checkpointDirtyOffset < logStartOffset) {
            if (!this.isCompactAndDelete(log) && this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$2(log, logStartOffset, checkpointDirtyOffset);
                Object var24_8 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            sp2 = new Tuple2.mcJZ.sp(logStartOffset, true);
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$3(log, checkpointDirtyOffset, logStartOffset);
                Object var25_9 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            sp2 = new Tuple2.mcJZ.sp(logStartOffset, true);
        } else {
            sp2 = new Tuple2.mcJZ.sp(checkpointDirtyOffset, false);
        }
        Tuple2.mcJZ.sp sp3 = sp2;
        long firstDirtyOffset = sp3._1$mcJ$sp();
        boolean forceUpdateCheckpoint = sp3._2$mcZ$sp();
        long l = BoxesRunTime.unboxToLong((Object)log.config().compactionLagMs());
        long max_y = 0L;
        long l3 = Math.max(l, max_y);
        Object[] objectArray = new Option[3];
        objectArray[0] = log.firstUnstableOffset();
        objectArray[1] = Option$.MODULE$.apply((Object)log.activeSegment().baseOffset());
        if (l3 > 0L) {
            Option option = log.nonActiveLogSegmentsFrom((long)var10_11).find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$4(now, l3, log, s)));
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object3 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((LogSegment)map_this.get()).baseOffset());
            none$ = object3;
            Object var16_16 = null;
            object3 = null;
        } else {
            none$ = None$.MODULE$;
        }
        objectArray[2] = none$;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).flatten((Function1)$less$colon$less$.MODULE$.refl())).min((Ordering)Ordering.Long$.MODULE$));
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$7(log, lastCleanOffset, now, (long)var10_11, firstUncleanableDirtyOffset);
            Object var26_19 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return new OffsetsToClean((long)var10_11, Math.max((long)var10_11, firstUncleanableDirtyOffset), (boolean)var12_12);
    }

    public Tuple2<Object, Object> calculateCleanableBytes(Log log, long firstDirtyOffset, long uncleanableOffset) {
        Object object;
        Option option = log.nonActiveLogSegmentsFrom(uncleanableOffset).headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            LogSegment logSegment;
            LogSegment logSegment2 = logSegment = log.activeSegment();
            logSegment = null;
            object = logSegment2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var10_4 = null;
        object = null;
        long firstUncleanableOffset = ((LogSegment)object2).baseOffset();
        long cleanableBytes = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)log.logSegments(Math.min(firstDirtyOffset, firstUncleanableOffset), firstUncleanableOffset).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2.mcJJ.sp(firstUncleanableOffset, cleanableBytes);
    }

    public static final /* synthetic */ long $anonfun$cleanableOffsets$1(long logStartOffset$1) {
        return logStartOffset$1;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$2(Log log$2, long logStartOffset$1, long checkpointDirtyOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(54).append("Resetting first dirty offset of ").append(log$2.name()).append(" to log start offset ").append(logStartOffset$1).append(" ").toString()).append(new StringBuilder(42).append("since the checkpointed offset ").append(checkpointDirtyOffset$1).append(" is invalid.").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$3(Log log$2, long checkpointDirtyOffset$1, long logStartOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(53).append("The last checkpoint dirty offset for partition ").append(log$2.name()).append(" is ").append(checkpointDirtyOffset$1).append(", ").toString()).append(new StringBuilder(77).append("which is larger than the log end offset ").append(log$2.logEndOffset()).append(". Resetting to the log start offset ").append(logStartOffset$1).append(".").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$5(Log log$2, LogSegment s$1, long now$3, long minCompactionLagMs$1, boolean isUncleanable$1) {
        return new StringBuilder(0).append(new StringBuilder(67).append("Checking if log segment may be cleaned: log='").append(log$2.name()).append("' segment.baseOffset=").append(s$1.baseOffset()).append(" ").toString()).append(new StringBuilder(49).append("segment.largestTimestamp=").append(s$1.largestTimestamp()).append("; now - compactionLag=").append(now$3 - minCompactionLagMs$1).append("; ").toString()).append(new StringBuilder(15).append("is uncleanable=").append(isUncleanable$1).toString()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, Log log$2, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        LogCleanerManager$ debug_this = MODULE$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = LogCleanerManager$.$anonfun$cleanableOffsets$5(log$2, s, now$3, minCompactionLagMs$1, isUncleanable);
            Object var8_6 = null;
            debug_this.logger().underlying().debug(Logging.msgWithLogIdent$(debug_this, msgWithLogIdent_msg));
        }
        return isUncleanable;
    }

    public static final /* synthetic */ String $anonfun$cleanableOffsets$7(Log log$2, Option lastCleanOffset$1, long now$3, long firstDirtyOffset$1, long firstUncleanableDirtyOffset$1) {
        return new StringBuilder(0).append(new StringBuilder(64).append("Finding range of cleanable offsets for log=").append(log$2.name()).append(". Last clean offset=").append(lastCleanOffset$1).append(" ").toString()).append(new StringBuilder(50).append("now=").append(now$3).append(" => firstDirtyOffset=").append(firstDirtyOffset$1).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset$1).append(" ").toString()).append(new StringBuilder(25).append("activeSegment.baseOffset=").append(log$2.activeSegment().baseOffset()).toString()).toString();
    }

    public static final /* synthetic */ LogSegment $anonfun$calculateCleanableBytes$1(Log log$3) {
        return log$3.activeSegment();
    }

    private LogCleanerManager$() {
    }

    public static final /* synthetic */ Object $anonfun$cleanableOffsets$6$adapted(LogSegment x$5) {
        return BoxesRunTime.boxToLong((long)x$5.baseOffset());
    }
}

