/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.common.StateChangeFailedException;
import kafka.controller.Callbacks;
import kafka.controller.Callbacks$;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$$anonfun$kafka$controller$ReplicaStateMachine$;
import kafka.controller.StateChangeLogger;
import kafka.controller.TopicDeletionManager;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003\u0019\u0019wN\u001c4jOB\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005mA\"aC&bM.\f7i\u001c8gS\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\bCA\u0010!\u001b\u0005\u0011\u0011BA\u0011\u0003\u0005E\u0019F/\u0019;f\u0007\"\fgnZ3M_\u001e<WM\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0011\u0005})\u0013B\u0001\u0014\u0003\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005!Bo\u001c9jG\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u0004\"a\b\u0016\n\u0005-\u0012!\u0001\u0006+pa&\u001cG)\u001a7fi&|g.T1oC\u001e,'\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003!Q8n\u00117jK:$\bCA\u00183\u001b\u0005\u0001$BA\u0019\u0005\u0003\tQ8.\u0003\u00024a\ti1*\u00194lCj[7\t\\5f]RD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\re\u0016\u0004H.[2b'R\fG/\u001a\t\u0005oqr\u0014)D\u00019\u0015\tI$(A\u0004nkR\f'\r\\3\u000b\u0005mR\u0011AC2pY2,7\r^5p]&\u0011Q\b\u000f\u0002\u0004\u001b\u0006\u0004\bCA\u0010@\u0013\t\u0001%AA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017\r\u0005\u0002 \u0005&\u00111I\u0001\u0002\r%\u0016\u0004H.[2b'R\fG/\u001a\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\u0006a2m\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007CA\u0010H\u0013\tA%A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\u000b)\u0003A\u0011A&\u0002\rqJg.\u001b;?)!aUJT(Q#J\u001b\u0006CA\u0010\u0001\u0011\u0015)\u0012\n1\u0001\u0017\u0011\u0015i\u0012\n1\u0001\u001f\u0011\u0015\u0019\u0013\n1\u0001%\u0011\u0015A\u0013\n1\u0001*\u0011\u0015i\u0013\n1\u0001/\u0011\u0015)\u0014\n1\u00017\u0011\u0015)\u0015\n1\u0001G\u0011\u001d)\u0006A1A\u0005\nY\u000bAbY8oiJ|G\u000e\\3s\u0013\u0012,\u0012a\u0016\t\u0003\u0013aK!!\u0017\u0006\u0003\u0007%sG\u000f\u0003\u0004\\\u0001\u0001\u0006IaV\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\t\u000bu\u0003A\u0011\u00010\u0002\u000fM$\u0018M\u001d;vaR\tq\f\u0005\u0002\nA&\u0011\u0011M\u0003\u0002\u0005+:LG\u000fC\u0003d\u0001\u0011\u0005a,\u0001\u0005tQV$Hm\\<o\u0011\u0015)\u0007\u0001\"\u0003_\u0003YIg.\u001b;jC2L'0\u001a*fa2L7-Y*uCR,\u0007\"B4\u0001\t\u0003A\u0017A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$BaX5xs\")!N\u001aa\u0001W\u0006A!/\u001a9mS\u000e\f7\u000fE\u0002mizr!!\u001c:\u000f\u00059\fX\"A8\u000b\u0005A4\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\t\u0019(\"A\u0004qC\u000e\\\u0017mZ3\n\u0005U4(aA*fc*\u00111O\u0003\u0005\u0006q\u001a\u0004\r!Q\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\rC\u0004{MB\u0005\t\u0019A>\u0002\u0013\r\fG\u000e\u001c2bG.\u001c\bCA\u0010}\u0013\ti(AA\u0005DC2d'-Y2lg\"1q\u0010\u0001C\u0005\u0003\u0003\tA\u0003Z8IC:$G.Z*uCR,7\t[1oO\u0016\u001cH#C0\u0002\u0004\u0005\u001d\u00111EA\u0013\u0011\u0019\t)A a\u0001/\u0006I!/\u001a9mS\u000e\f\u0017\n\u001a\u0005\b\u0003\u0013q\b\u0019AA\u0006\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0005YR\fi\u0001\u0005\u0003\u0002\u0010\u0005}QBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\r\r|W.\\8o\u0015\r)\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003;\t1a\u001c:h\u0013\u0011\t\t#!\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")\u0001P a\u0001\u0003\")!P a\u0001w\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012!\u0006:f[>4XMU3qY&\u001c\u0017m\u001d$s_6L5O\u001d\u000b\u0007\u0003[\ty$!\u0011\u0011\u0011\u0005=\u0012QGA\u0007\u0003sq1!CA\u0019\u0013\r\t\u0019DC\u0001\u0007!J,G-\u001a4\n\u0007u\n9DC\u0002\u00024)\u00012aHA\u001e\u0013\r\tiD\u0001\u0002\u001c\u0019\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\t\u000f\u0005\u0015\u0011q\u0005a\u0001/\"A\u0011\u0011BA\u0014\u0001\u0004\tY\u0001C\u0004\u0002F\u0001!I!a\u0012\u0002/\u0011|'+Z7pm\u0016\u0014V\r\u001d7jG\u0006\u001chI]8n\u0013N\u0014HCBA%\u0003/\nI\u0006E\u0005\n\u0003\u0017\ni#a\u0003\u0002P%\u0019\u0011Q\n\u0006\u0003\rQ+\b\u000f\\34!!\ty#!\u000e\u0002\u000e\u0005E\u0003c\u00017\u0002T%\u0019\u0011Q\u000b<\u0003\u0013\u0015C8-\u001a9uS>t\u0007bBA\u0003\u0003\u0007\u0002\ra\u0016\u0005\t\u0003\u0013\t\u0019\u00051\u0001\u0002\f!9\u0011Q\f\u0001\u0005\n\u0005}\u0013!H4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3t\rJ|WNW6\u0015\t\u0005\u0005\u0014\u0011\u000f\t\n\u0013\u0005-\u00131MA\u0006\u0003\u001f\u0002\u0002\"a\f\u00026\u00055\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002p\u0005%$\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\b\u0002CA\u0005\u00037\u0002\r!a\u0003\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x\u0005I\u0013n]!u\u0019\u0016\f7\u000f^(oKJ+\u0007\u000f\\5dC&sG)\u001a7fi&|gn\u0015;beR,Gm\u0015;bi\u0016$B!!\u001f\u0002\u0000A\u0019\u0011\"a\u001f\n\u0007\u0005u$BA\u0004C_>dW-\u00198\t\u0011\u0005\u0005\u00151\u000fa\u0001\u0003\u0007\u000bQ\u0001^8qS\u000e\u0004B!a\f\u0002\u0006&!\u0011qQA\u001c\u0005\u0019\u0019FO]5oO\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0015a\u0004:fa2L7-Y:J]N#\u0018\r^3\u0015\r\u0005=\u0015QSAL!\u0015\ty#!%?\u0013\u0011\t\u0019*a\u000e\u0003\u0007M+G\u000f\u0003\u0005\u0002\u0002\u0006%\u0005\u0019AAB\u0011\u001d\tI*!#A\u0002\u0005\u000bQa\u001d;bi\u0016Dq!!(\u0001\t\u0003\ty*A\u000fbe\u0016\fE\u000e\u001c*fa2L7-Y:G_J$v\u000e]5d\t\u0016dW\r^3e)\u0011\tI(!)\t\u0011\u0005\u0005\u00151\u0014a\u0001\u0003\u0007Cq!!*\u0001\t\u0003\t9+A\njg\u0006s\u0017PU3qY&\u001c\u0017-\u00138Ti\u0006$X\r\u0006\u0004\u0002z\u0005%\u00161\u0016\u0005\t\u0003\u0003\u000b\u0019\u000b1\u0001\u0002\u0004\"9\u0011\u0011TAR\u0001\u0004\t\u0005bBAX\u0001\u0011%\u0011\u0011W\u0001\u0012SN4\u0016\r\\5e)J\fgn]5uS>tGCBA=\u0003g\u000b9\fC\u0004\u00026\u00065\u0006\u0019\u0001 \u0002\u000fI,\u0007\u000f\\5dC\"1\u00010!,A\u0002\u0005Cq!a/\u0001\t\u0013\ti,A\fm_\u001e\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]RIq,a0\u0002B\u0006\u0015\u0017\u0011\u001a\u0005\b\u0003\u000b\tI\f1\u0001X\u0011!\t\u0019-!/A\u0002\u00055\u0011!\u00039beRLG/[8o\u0011\u001d\t9-!/A\u0002\u0005\u000b\u0011bY;seN#\u0018\r^3\t\ra\fI\f1\u0001B\u0011\u001d\ti\r\u0001C\u0005\u0003\u001f\fA\u0003\\8h\u0013:4\u0018\r\\5e)J\fgn]5uS>tG#B0\u0002R\u0006M\u0007bBA[\u0003\u0017\u0004\rA\u0010\u0005\u0007q\u0006-\u0007\u0019A!\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\u0006!Bn\\4GC&dW\rZ*uCR,7\t[1oO\u0016$\u0012bXAn\u0003;\fy.!9\t\u000f\u0005U\u0016Q\u001ba\u0001}!9\u0011qYAk\u0001\u0004\t\u0005B\u0002=\u0002V\u0002\u0007\u0011\t\u0003\u0005\u0002d\u0006U\u0007\u0019AAs\u0003\u0005!\bc\u00017\u0002h&\u0019\u0011\u0011\u001e<\u0003\u0013QC'o\\<bE2,\u0007\"CAw\u0001E\u0005I\u0011AAx\u0003qA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-Z:%I\u00164\u0017-\u001e7uIM*\"!!=+\u0007m\f\u0019p\u000b\u0002\u0002vB!\u0011q\u001fB\u0001\u001b\t\tIP\u0003\u0003\u0002|\u0006u\u0018!C;oG\",7m[3e\u0015\r\tyPC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0002\u0003s\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ReplicaStateMachine
implements Logging {
    private final StateChangeLogger stateChangeLogger;
    public final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    public final TopicDeletionManager kafka$controller$ReplicaStateMachine$$topicDeletionManager;
    private final KafkaZkClient zkClient;
    public final Map<PartitionAndReplica, ReplicaState> kafka$controller$ReplicaStateMachine$$replicaState;
    public final ControllerBrokerRequestBatch kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch;
    private final int kafka$controller$ReplicaStateMachine$$controllerId;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int kafka$controller$ReplicaStateMachine$$controllerId() {
        return this.kafka$controller$ReplicaStateMachine$$controllerId;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Initializing replica state";
            }
        });
        this.initializeReplicaState();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Triggering online replica state changes";
            }
        });
        this.handleStateChanges((Seq<PartitionAndReplica>)this.kafka$controller$ReplicaStateMachine$$controllerContext.allLiveReplicas().toSeq(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started replica state machine with initial state -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$ReplicaStateMachine$$replicaState}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$replicaState.clear();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped replica state machine";
            }
        });
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final void apply(Tuple2<TopicPartition, Seq<Object>> x0$1) {
                Tuple2<TopicPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    Seq replicas = (Seq)tuple2._2();
                    replicas.foreach((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$initializeReplicaState$1 $outer;
                        private final TopicPartition partition$1;

                        public final Option<ReplicaState> apply(int replicaId) {
                            PartitionAndReplica partitionAndReplica = new PartitionAndReplica(this.partition$1, replicaId);
                            return this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext.isReplicaOnline(replicaId, this.partition$1, this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext.isReplicaOnline$default$3()) ? this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$replicaState.put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$replicaState.put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.partition$1 = partition$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleStateChanges(Seq<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        if (replicas.nonEmpty()) {
            try {
                this.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch.newBatch();
                replicas.groupBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(PartitionAndReplica x$1) {
                        return x$1.replica();
                    }
                }).map((Function1)new Serializable(this, targetState, callbacks){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaStateMachine $outer;
                    private final ReplicaState targetState$1;
                    private final Callbacks callbacks$1;

                    public final void apply(Tuple2<Object, Seq<PartitionAndReplica>> x0$2) {
                        Tuple2<Object, Seq<PartitionAndReplica>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int replicaId = tuple2._1$mcI$sp();
                            Seq replicas = (Seq)tuple2._2();
                            Seq partitions = (Seq)replicas.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final TopicPartition apply(PartitionAndReplica x$2) {
                                    return x$2.topicPartition();
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            this.$outer.kafka$controller$ReplicaStateMachine$$doHandleStateChanges(replicaId, (Seq<TopicPartition>)partitions, this.targetState$1, this.callbacks$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.targetState$1 = targetState$1;
                        this.callbacks$1 = callbacks$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                this.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch.sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controllerContext.epoch());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this, targetState){
                    public static final long serialVersionUID = 0L;
                    private final ReplicaState targetState$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while moving some replicas to ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                    }
                    {
                        this.targetState$1 = targetState$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$1;

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks(Callbacks$.MODULE$.$lessinit$greater$default$1());
    }

    public void kafka$controller$ReplicaStateMachine$$doHandleStateChanges(int replicaId, Seq<TopicPartition> partitions, ReplicaState targetState, Callbacks callbacks) {
        Tuple2 tuple2;
        block2: {
            ReplicaState replicaState;
            block10: {
                block4: {
                    Seq validReplicas;
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block5: {
                                        block3: {
                                            Tuple2 tuple22;
                                            Seq replicas = (Seq)partitions.map((Function1)new Serializable(this, replicaId){
                                                public static final long serialVersionUID = 0L;
                                                private final int replicaId$1;

                                                public final PartitionAndReplica apply(TopicPartition partition) {
                                                    return new PartitionAndReplica(partition, this.replicaId$1);
                                                }
                                                {
                                                    this.replicaId$1 = replicaId$1;
                                                }
                                            }, Seq$.MODULE$.canBuildFrom());
                                            replicas.foreach((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ ReplicaStateMachine $outer;

                                                public final ReplicaState apply(PartitionAndReplica replica) {
                                                    return (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.getOrElseUpdate((Object)replica, (Function0)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final NonExistentReplica$ apply() {
                                                            return NonExistentReplica$.MODULE$;
                                                        }
                                                    });
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            });
                                            tuple2 = replicas.partition((Function1)new Serializable(this, targetState){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ ReplicaStateMachine $outer;
                                                private final ReplicaState targetState$2;

                                                public final boolean apply(PartitionAndReplica replica) {
                                                    return this.$outer.kafka$controller$ReplicaStateMachine$$isValidTransition(replica, this.targetState$2);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.targetState$2 = targetState$2;
                                                }
                                            });
                                            if (tuple2 == null) break block2;
                                            Seq validReplicas2 = (Seq)tuple2._1();
                                            Seq invalidReplicas = (Seq)tuple2._2();
                                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)validReplicas2, (Object)invalidReplicas);
                                            validReplicas = (Seq)tuple23._1();
                                            Seq invalidReplicas2 = (Seq)tuple23._2();
                                            invalidReplicas2.foreach((Function1)new Serializable(this, targetState){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ ReplicaStateMachine $outer;
                                                private final ReplicaState targetState$2;

                                                public final void apply(PartitionAndReplica replica) {
                                                    this.$outer.kafka$controller$ReplicaStateMachine$$logInvalidTransition(replica, this.targetState$2);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.targetState$2 = targetState$2;
                                                }
                                            });
                                            replicaState = targetState;
                                            if (!NewReplica$.MODULE$.equals(replicaState)) break block3;
                                            validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ ReplicaStateMachine $outer;
                                                private final int replicaId$1;

                                                public final Object apply(PartitionAndReplica replica) {
                                                    Option option;
                                                    block7: {
                                                        Option option2;
                                                        block6: {
                                                            TopicPartition partition;
                                                            block5: {
                                                                Option option3;
                                                                partition = replica.topicPartition();
                                                                option = this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionLeadershipInfo().get((Object)partition);
                                                                if (!(option instanceof Some)) break block5;
                                                                Some some = (Some)option;
                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == this.replicaId$1) {
                                                                    StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " for partition ", " cannot be moved to NewReplica state as it is being requested to become leader"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), partition})));
                                                                    this.$outer.kafka$controller$ReplicaStateMachine$$logFailedStateChange(replica, (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), OfflineReplica$.MODULE$, exception);
                                                                    option3 = BoxedUnit.UNIT;
                                                                } else {
                                                                    this.$outer.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, (Seq<Object>)((Seq)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().apply((Object)replica.topicPartition())), true);
                                                                    this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), NewReplica$.MODULE$);
                                                                    option3 = this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.put((Object)replica, (Object)NewReplica$.MODULE$);
                                                                }
                                                                option2 = option3;
                                                                break block6;
                                                            }
                                                            if (!None$.MODULE$.equals(option)) break block7;
                                                            this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), NewReplica$.MODULE$);
                                                            option2 = this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.put((Object)replica, (Object)NewReplica$.MODULE$);
                                                        }
                                                        return option2;
                                                    }
                                                    throw new MatchError((Object)option);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.replicaId$1 = replicaId$1;
                                                }
                                            });
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block4;
                                        }
                                        if (!OnlineReplica$.MODULE$.equals(replicaState)) break block5;
                                        validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ReplicaStateMachine $outer;
                                            private final int replicaId$1;

                                            public final Option<ReplicaState> apply(PartitionAndReplica replica) {
                                                Option option;
                                                block6: {
                                                    TopicPartition partition;
                                                    block3: {
                                                        BoxedUnit boxedUnit;
                                                        block5: {
                                                            block4: {
                                                                block2: {
                                                                    partition = replica.topicPartition();
                                                                    ReplicaState replicaState = (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica);
                                                                    if (!NewReplica$.MODULE$.equals(replicaState)) break block2;
                                                                    Seq assignment = (Seq)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().apply((Object)partition);
                                                                    boxedUnit = assignment.contains((Object)BoxesRunTime.boxToInteger((int)this.replicaId$1)) ? BoxedUnit.UNIT : this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().put((Object)partition, assignment.$colon$plus((Object)BoxesRunTime.boxToInteger((int)this.replicaId$1), Seq$.MODULE$.canBuildFrom()));
                                                                    break block3;
                                                                }
                                                                option = this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionLeadershipInfo().get((Object)partition);
                                                                if (!(option instanceof Some)) break block4;
                                                                Some some = (Some)option;
                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                                                this.$outer.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), leaderIsrAndControllerEpoch, (Seq<Object>)((Seq)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().apply((Object)partition)), false);
                                                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                                                break block5;
                                                            }
                                                            if (!None$.MODULE$.equals(option)) break block6;
                                                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                                        }
                                                        boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), OnlineReplica$.MODULE$);
                                                    return this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.put((Object)replica, (Object)OnlineReplica$.MODULE$);
                                                }
                                                throw new MatchError((Object)option);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.replicaId$1 = replicaId$1;
                                            }
                                        });
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!OfflineReplica$.MODULE$.equals(replicaState)) break block6;
                                    validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReplicaStateMachine $outer;
                                        private final int replicaId$1;

                                        public final void apply(PartitionAndReplica replica) {
                                            this.$outer.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), false, (Function2<AbstractResponse, Object, BoxedUnit>)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final void apply(AbstractResponse x$4, int x$5) {
                                                }
                                            });
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.replicaId$1 = replicaId$1;
                                        }
                                    });
                                    Seq replicasToRemoveFromIsr = (Seq)validReplicas.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReplicaStateMachine $outer;

                                        public final boolean apply(PartitionAndReplica replica) {
                                            return this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionLeadershipInfo().contains((Object)replica.topicPartition());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> updatedLeaderIsrAndControllerEpochs = this.removeReplicasFromIsr(replicaId, (Seq<TopicPartition>)((Seq)replicasToRemoveFromIsr.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final TopicPartition apply(PartitionAndReplica x$6) {
                                            return x$6.topicPartition();
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())));
                                    updatedLeaderIsrAndControllerEpochs.foreach((Function1)new Serializable(this, replicaId){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReplicaStateMachine $outer;
                                        public final int replicaId$1;

                                        public final Option<ReplicaState> apply(Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> x0$3) {
                                            Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> tuple2 = x0$3;
                                            if (tuple2 != null) {
                                                TopicPartition partition = (TopicPartition)tuple2._1();
                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)tuple2._2();
                                                if (!this.$outer.kafka$controller$ReplicaStateMachine$$topicDeletionManager.isPartitionToBeDeleted(partition)) {
                                                    Seq recipients = (Seq)((TraversableLike)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().apply((Object)partition)).filterNot((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$kafka$controller$ReplicaStateMachine$$doHandleStateChanges$6 $outer;

                                                        public final boolean apply(int x$7) {
                                                            return this.apply$mcZI$sp(x$7);
                                                        }

                                                        public boolean apply$mcZI$sp(int x$7) {
                                                            return x$7 == this.$outer.replicaId$1;
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    });
                                                    this.$outer.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch.addLeaderAndIsrRequestForBrokers((Seq<Object>)recipients, partition, leaderIsrAndControllerEpoch, (Seq<Object>)((Seq)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().apply((Object)partition)), false);
                                                }
                                                PartitionAndReplica replica = new PartitionAndReplica(partition, this.replicaId$1);
                                                this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, partition, (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), OfflineReplica$.MODULE$);
                                                Option option = this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.put((Object)replica, (Object)OfflineReplica$.MODULE$);
                                                return option;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.replicaId$1 = replicaId$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (!ReplicaDeletionStarted$.MODULE$.equals(replicaState)) break block7;
                                validReplicas.foreach((Function1)new Serializable(this, replicaId, callbacks){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ReplicaStateMachine $outer;
                                    private final int replicaId$1;
                                    private final Callbacks callbacks$2;

                                    public final void apply(PartitionAndReplica replica) {
                                        this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), ReplicaDeletionStarted$.MODULE$);
                                        this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.put((Object)replica, (Object)ReplicaDeletionStarted$.MODULE$);
                                        this.$outer.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch.addStopReplicaRequestForBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.replicaId$1}))), replica.topicPartition(), true, this.callbacks$2.stopReplicaResponseCallback());
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.replicaId$1 = replicaId$1;
                                        this.callbacks$2 = callbacks$2;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (!ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) break block8;
                            validReplicas.foreach((Function1)new Serializable(this, replicaId){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ReplicaStateMachine $outer;
                                private final int replicaId$1;

                                public final Option<ReplicaState> apply(PartitionAndReplica replica) {
                                    this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), ReplicaDeletionIneligible$.MODULE$);
                                    return this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.put((Object)replica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.replicaId$1 = replicaId$1;
                                }
                            });
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (!ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) break block9;
                        validReplicas.foreach((Function1)new Serializable(this, replicaId){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReplicaStateMachine $outer;
                            private final int replicaId$1;

                            public final Option<ReplicaState> apply(PartitionAndReplica replica) {
                                this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), ReplicaDeletionSuccessful$.MODULE$);
                                return this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.put((Object)replica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.replicaId$1 = replicaId$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!NonExistentReplica$.MODULE$.equals(replicaState)) break block10;
                    validReplicas.foreach((Function1)new Serializable(this, replicaId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ReplicaStateMachine $outer;
                        private final int replicaId$1;

                        public final Option<ReplicaState> apply(PartitionAndReplica replica) {
                            Seq currentAssignedReplicas = (Seq)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().apply((Object)replica.topicPartition());
                            this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment().put((Object)replica.topicPartition(), currentAssignedReplicas.filterNot((Function1)new Serializable(this, replica){
                                public static final long serialVersionUID = 0L;
                                private final PartitionAndReplica replica$2;

                                public final boolean apply(int x$8) {
                                    return this.apply$mcZI$sp(x$8);
                                }

                                public boolean apply$mcZI$sp(int x$8) {
                                    return x$8 == this.replica$2.replica();
                                }
                                {
                                    this.replica$2 = replica$2;
                                }
                            }));
                            this.$outer.kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(this.replicaId$1, replica.topicPartition(), (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), NonExistentReplica$.MODULE$);
                            return this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.remove((Object)replica);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.replicaId$1 = replicaId$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)replicaState);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch> removeReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        void var3_3;
        scala.collection.immutable.Map results = Predef$.MODULE$.Map().empty();
        Seq remaining = partitions;
        while (remaining.nonEmpty()) {
            Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.doRemoveReplicasFromIsr(replicaId, remaining);
            if (tuple3 != null) {
                Tuple3 tuple32;
                scala.collection.immutable.Map successfulRemovals = (scala.collection.immutable.Map)tuple3._1();
                Seq removalsToRetry = (Seq)tuple3._2();
                scala.collection.immutable.Map failedRemovals = (scala.collection.immutable.Map)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)successfulRemovals, (Object)removalsToRetry, (Object)failedRemovals);
                scala.collection.immutable.Map successfulRemovals2 = (scala.collection.immutable.Map)tuple33._1();
                Seq removalsToRetry2 = (Seq)tuple33._2();
                scala.collection.immutable.Map failedRemovals2 = (scala.collection.immutable.Map)tuple33._3();
                results = results.$plus$plus((GenTraversableOnce)successfulRemovals2);
                remaining = removalsToRetry2;
                failedRemovals2.foreach((Function1)new Serializable(this, replicaId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaStateMachine $outer;
                    private final int replicaId$3;

                    public final void apply(Tuple2<TopicPartition, Exception> x0$4) {
                        Tuple2<TopicPartition, Exception> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition partition = (TopicPartition)tuple2._1();
                            Exception e = (Exception)tuple2._2();
                            PartitionAndReplica replica = new PartitionAndReplica(partition, this.replicaId$3);
                            this.$outer.kafka$controller$ReplicaStateMachine$$logFailedStateChange(replica, (ReplicaState)this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica), OfflineReplica$.MODULE$, e);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.replicaId$3 = replicaId$3;
                    }
                });
                continue;
            }
            throw new MatchError(tuple3);
        }
        return var3_3;
    }

    private Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderIsrAndControllerEpoch>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> doRemoveReplicasFromIsr(int replicaId, Seq<TopicPartition> partitions) {
        Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> tuple3 = this.getTopicPartitionStatesFromZk(partitions);
        if (tuple3 != null) {
            Tuple3 tuple32;
            scala.collection.immutable.Map leaderAndIsrs = (scala.collection.immutable.Map)tuple3._1();
            Seq partitionsWithNoLeaderAndIsrInZk = (Seq)tuple3._2();
            scala.collection.immutable.Map failedStateReads = (scala.collection.immutable.Map)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)leaderAndIsrs, (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failedStateReads);
            scala.collection.immutable.Map leaderAndIsrs2 = (scala.collection.immutable.Map)tuple33._1();
            Seq partitionsWithNoLeaderAndIsrInZk2 = (Seq)tuple33._2();
            scala.collection.immutable.Map failedStateReads2 = (scala.collection.immutable.Map)tuple33._3();
            Tuple2 tuple2 = leaderAndIsrs2.partition((Function1)new Serializable(this, replicaId){
                public static final long serialVersionUID = 0L;
                private final int replicaId$4;

                public final boolean apply(Tuple2<TopicPartition, LeaderAndIsr> x0$5) {
                    Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$5;
                    if (tuple2 != null) {
                        LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                        boolean bl = leaderAndIsr.isr().contains((Object)BoxesRunTime.boxToInteger((int)this.replicaId$4));
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.replicaId$4 = replicaId$4;
                }
            });
            if (tuple2 != null) {
                Tuple2 tuple22;
                scala.collection.immutable.Map leaderAndIsrsWithReplica = (scala.collection.immutable.Map)tuple2._1();
                scala.collection.immutable.Map leaderAndIsrsWithoutReplica = (scala.collection.immutable.Map)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)leaderAndIsrsWithReplica, (Object)leaderAndIsrsWithoutReplica);
                scala.collection.immutable.Map leaderAndIsrsWithReplica2 = (scala.collection.immutable.Map)tuple23._1();
                scala.collection.immutable.Map leaderAndIsrsWithoutReplica2 = (scala.collection.immutable.Map)tuple23._2();
                scala.collection.immutable.Map adjustedLeaderAndIsrs = leaderAndIsrsWithReplica2.mapValues((Function1)new Serializable(this, replicaId){
                    public static final long serialVersionUID = 0L;
                    public final int replicaId$4;

                    public final LeaderAndIsr apply(LeaderAndIsr leaderAndIsr) {
                        int newLeader = this.replicaId$4 == leaderAndIsr.leader() ? LeaderAndIsr$.MODULE$.NoLeader() : leaderAndIsr.leader();
                        List adjustedIsr = leaderAndIsr.isr().size() == 1 ? leaderAndIsr.isr() : (List)leaderAndIsr.isr().filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9 $outer;

                            public final boolean apply(int x$12) {
                                return this.apply$mcZI$sp(x$12);
                            }

                            public boolean apply$mcZI$sp(int x$12) {
                                return x$12 != this.$outer.replicaId$4;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        return leaderAndIsr.newLeaderAndIsr(newLeader, adjustedIsr);
                    }
                    {
                        this.replicaId$4 = replicaId$4;
                    }
                });
                KafkaZkClient.UpdateLeaderAndIsrResult updateLeaderAndIsrResult = this.zkClient.updateLeaderAndIsr((scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>)adjustedLeaderAndIsrs, this.kafka$controller$ReplicaStateMachine$$controllerContext.epoch());
                if (updateLeaderAndIsrResult != null) {
                    Tuple3 tuple34;
                    scala.collection.immutable.Map<TopicPartition, LeaderAndIsr> successfulUpdates = updateLeaderAndIsrResult.successfulPartitions();
                    Seq<TopicPartition> updatesToRetry = updateLeaderAndIsrResult.partitionsToRetry();
                    scala.collection.immutable.Map<TopicPartition, Exception> failedUpdates = updateLeaderAndIsrResult.failedPartitions();
                    Tuple3 tuple35 = tuple34 = new Tuple3(successfulUpdates, updatesToRetry, failedUpdates);
                    scala.collection.immutable.Map successfulUpdates2 = (scala.collection.immutable.Map)tuple35._1();
                    Seq updatesToRetry2 = (Seq)tuple35._2();
                    scala.collection.immutable.Map failedUpdates2 = (scala.collection.immutable.Map)tuple35._3();
                    scala.collection.immutable.Map exceptionsForPartitionsWithNoLeaderAndIsrInZk = ((TraversableOnce)partitionsWithNoLeaderAndIsrInZk2.flatMap((Function1)new Serializable(this, replicaId){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ReplicaStateMachine $outer;
                        private final int replicaId$4;

                        public final Iterable<Tuple2<TopicPartition, StateChangeFailedException>> apply(TopicPartition partition) {
                            Iterable iterable;
                            if (this.$outer.kafka$controller$ReplicaStateMachine$$topicDeletionManager.isPartitionToBeDeleted(partition)) {
                                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            } else {
                                StateChangeFailedException exception = new StateChangeFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to change state of replica ", " for partition ", " since the leader and isr path in zookeeper is empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$4), partition})));
                                iterable = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)exception)));
                            }
                            return iterable;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.replicaId$4 = replicaId$4;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    scala.collection.immutable.Map leaderIsrAndControllerEpochs = (scala.collection.immutable.Map)leaderAndIsrsWithoutReplica2.$plus$plus((GenTraversableOnce)successfulUpdates2).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ReplicaStateMachine $outer;

                        public final Tuple2<TopicPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicPartition, LeaderAndIsr> x0$6) {
                            Tuple2<TopicPartition, LeaderAndIsr> tuple2 = x0$6;
                            if (tuple2 != null) {
                                TopicPartition partition = (TopicPartition)tuple2._1();
                                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)tuple2._2();
                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.epoch());
                                this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)leaderIsrAndControllerEpoch);
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    return new Tuple3((Object)leaderIsrAndControllerEpochs, (Object)updatesToRetry2, (Object)failedStateReads2.$plus$plus((GenTraversableOnce)exceptionsForPartitionsWithNoLeaderAndIsrInZk).$plus$plus((GenTraversableOnce)failedUpdates2));
                }
                throw new MatchError((Object)updateLeaderAndIsrResult);
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(tuple3);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple3<scala.collection.immutable.Map<TopicPartition, LeaderAndIsr>, Seq<TopicPartition>, scala.collection.immutable.Map<TopicPartition, Exception>> getTopicPartitionStatesFromZk(Seq<TopicPartition> partitions) {
        Seq<GetDataResponse> getDataResponses;
        Map leaderAndIsrs = Map$.MODULE$.empty();
        Buffer partitionsWithNoLeaderAndIsrInZk = (Buffer)Buffer$.MODULE$.empty();
        Map failed = Map$.MODULE$.empty();
        try {
            getDataResponses = this.zkClient.getTopicPartitionStatesRaw(partitions);
        }
        catch (Exception exception) {
            void var3_3;
            void var2_2;
            void var4_4;
            partitions.foreach((Function1)new Serializable(this, (Map)var4_4, exception){
                public static final long serialVersionUID = 0L;
                private final Map failed$1;
                private final Exception e$2;

                public final Option<Exception> apply(TopicPartition partition) {
                    return this.failed$1.put((Object)partition, (Object)this.e$2);
                }
                {
                    this.failed$1 = failed$1;
                    this.e$2 = e$2;
                }
            });
            return new Tuple3((Object)var2_2.toMap(Predef$.MODULE$.$conforms()), (Object)var3_3, (Object)var4_4.toMap(Predef$.MODULE$.$conforms()));
        }
        getDataResponses.foreach((Function1)new Serializable(this, leaderAndIsrs, partitionsWithNoLeaderAndIsrInZk, failed){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;
            private final Map leaderAndIsrs$1;
            private final Buffer partitionsWithNoLeaderAndIsrInZk$1;
            private final Map failed$1;

            public final Object apply(GetDataResponse getDataResponse) {
                Object object;
                TopicPartition partition = (TopicPartition)getDataResponse.ctx().get();
                KeeperException.Code code = getDataResponse.resultCode();
                KeeperException.Code code2 = KeeperException.Code.OK;
                if (!(code != null ? !code.equals(code2) : code2 != null)) {
                    Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = TopicPartitionStateZNode$.MODULE$.decode(getDataResponse.data(), getDataResponse.stat());
                    if (leaderIsrAndControllerEpochOpt.isEmpty()) {
                        object = this.partitionsWithNoLeaderAndIsrInZk$1.$plus$eq((Object)partition);
                    } else {
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochOpt.get();
                        if (leaderIsrAndControllerEpoch.controllerEpoch() > this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.epoch()) {
                            StateChangeFailedException exception = new StateChangeFailedException(new StringBuilder().append((Object)"Leader and isr path written by another controller. This probably").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"means the current controller with epoch ", " went through a soft failure and another "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.epoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"controller was elected with epoch ", ". Aborting state change by this controller"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}))).toString());
                            object = this.failed$1.put((Object)partition, (Object)exception);
                        } else {
                            object = this.leaderAndIsrs$1.put((Object)partition, (Object)leaderIsrAndControllerEpoch.leaderAndIsr());
                        }
                    }
                } else {
                    KeeperException.Code code3 = getDataResponse.resultCode();
                    KeeperException.Code code4 = KeeperException.Code.NONODE;
                    object = !(code3 != null ? !code3.equals(code4) : code4 != null) ? this.partitionsWithNoLeaderAndIsrInZk$1.$plus$eq((Object)partition) : this.failed$1.put((Object)partition, getDataResponse.resultException().get());
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderAndIsrs$1 = leaderAndIsrs$1;
                this.partitionsWithNoLeaderAndIsrInZk$1 = partitionsWithNoLeaderAndIsrInZk$1;
                this.failed$1 = failed$1;
            }
        });
        return new Tuple3((Object)leaderAndIsrs.toMap(Predef$.MODULE$.$conforms()), (Object)partitionsWithNoLeaderAndIsrInZk, (Object)failed.toMap(Predef$.MODULE$.$conforms()));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext.replicasForTopic(topic).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final boolean apply(PartitionAndReplica replica) {
                Object object = this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica);
                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                return !(object != null ? !object.equals(replicaDeletionStarted$) : replicaDeletionStarted$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$replicaState.filter((Function1)new Serializable(this, topic, state){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final ReplicaState state$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> x0$7) {
                Tuple2<PartitionAndReplica, ReplicaState> tuple2 = x0$7;
                if (tuple2 == null) throw new MatchError(tuple2);
                PartitionAndReplica replica = (PartitionAndReplica)tuple2._1();
                ReplicaState s = (ReplicaState)tuple2._2();
                if (!replica.topic().equals(this.topic$1)) return false;
                ReplicaState replicaState = s;
                ReplicaState replicaState2 = this.state$1;
                if (replicaState != null) {
                    if (!replicaState.equals(replicaState2)) return false;
                    return true;
                }
                if (replicaState2 == null) return true;
                return false;
            }
            {
                this.topic$1 = topic$1;
                this.state$1 = state$1;
            }
        })).keySet().toSet();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext.replicasForTopic(topic).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final boolean apply(PartitionAndReplica replica) {
                Object object = this.$outer.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica);
                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.kafka$controller$ReplicaStateMachine$$replicaState.exists((Function1)new Serializable(this, topic, state){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final ReplicaState state$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> x0$8) {
                Tuple2<PartitionAndReplica, ReplicaState> tuple2 = x0$8;
                if (tuple2 == null) throw new MatchError(tuple2);
                PartitionAndReplica replica = (PartitionAndReplica)tuple2._1();
                ReplicaState s = (ReplicaState)tuple2._2();
                if (!replica.topic().equals(this.topic$2)) return false;
                ReplicaState replicaState = s;
                ReplicaState replicaState2 = this.state$2;
                if (replicaState != null) {
                    if (!replicaState.equals(replicaState2)) return false;
                    return true;
                }
                if (replicaState2 == null) return true;
                return false;
            }
            {
                this.topic$2 = topic$2;
                this.state$2 = state$2;
            }
        });
    }

    public boolean kafka$controller$ReplicaStateMachine$$isValidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        return targetState.validPreviousStates().contains(this.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica));
    }

    public void kafka$controller$ReplicaStateMachine$$logSuccessfulTransition(int replicaId, TopicPartition partition, ReplicaState currState, ReplicaState targetState) {
        this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ReplicaStateMachine$$controllerContext.epoch()).trace((Function0<String>)new Serializable(this, replicaId, partition, currState, targetState){
            public static final long serialVersionUID = 0L;
            private final int replicaId$2;
            private final TopicPartition partition$2;
            private final ReplicaState currState$2;
            private final ReplicaState targetState$4;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changed state of replica ", " for partition ", " from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$2), this.partition$2, this.currState$2, this.targetState$4}));
            }
            {
                this.replicaId$2 = replicaId$2;
                this.partition$2 = partition$2;
                this.currState$2 = currState$2;
                this.targetState$4 = targetState$4;
            }
        });
    }

    public void kafka$controller$ReplicaStateMachine$$logInvalidTransition(PartitionAndReplica replica, ReplicaState targetState) {
        ReplicaState currState = (ReplicaState)this.kafka$controller$ReplicaStateMachine$$replicaState.apply((Object)replica);
        IllegalStateException e = new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica ", " should be in the ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica, targetState.validPreviousStates().mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"states before moving to ", " state. Instead it is in ", " state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, currState}))).toString());
        this.kafka$controller$ReplicaStateMachine$$logFailedStateChange(replica, currState, targetState, e);
    }

    public void kafka$controller$ReplicaStateMachine$$logFailedStateChange(PartitionAndReplica replica, ReplicaState currState, ReplicaState targetState, Throwable t) {
        this.stateChangeLogger.withControllerEpoch(this.kafka$controller$ReplicaStateMachine$$controllerContext.epoch()).error((Function0<String>)new Serializable(this, replica, currState, targetState){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;
            private final PartitionAndReplica replica$1;
            private final ReplicaState currState$1;
            private final ReplicaState targetState$3;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Controller ", " epoch ", " initiated state change of replica ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.epoch()), BoxesRunTime.boxToInteger((int)this.replica$1.replica())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", " from ", " to ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replica$1.topicPartition(), this.currState$1, this.targetState$3}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replica$1 = replica$1;
                this.currState$1 = currState$1;
                this.targetState$3 = targetState$3;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public ReplicaStateMachine(KafkaConfig config, StateChangeLogger stateChangeLogger, ControllerContext controllerContext, TopicDeletionManager topicDeletionManager, KafkaZkClient zkClient, Map<PartitionAndReplica, ReplicaState> replicaState, ControllerBrokerRequestBatch controllerBrokerRequestBatch) {
        this.stateChangeLogger = stateChangeLogger;
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controllerContext;
        this.kafka$controller$ReplicaStateMachine$$topicDeletionManager = topicDeletionManager;
        this.zkClient = zkClient;
        this.kafka$controller$ReplicaStateMachine$$replicaState = replicaState;
        this.kafka$controller$ReplicaStateMachine$$controllerBrokerRequestBatch = controllerBrokerRequestBatch;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerId = config.brokerId();
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaStateMachine controllerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controllerId())})));
    }
}

