/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.GraphListener;
import org.apache.jmeter.visualizers.ImageVisualizer;
import org.apache.jmeter.visualizers.Sample;
import org.apache.jmeter.visualizers.SplineModel;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.gui.layout.VerticalLayout;

@Deprecated
public class SplineVisualizer
extends AbstractVisualizer
implements ImageVisualizer,
GraphListener {
    private static final long serialVersionUID = 240L;
    private static final String SUFFIX_MS = " ms";
    protected final Color BACKGROUND_COLOR = this.getBackground();
    protected final Color MINIMUM_COLOR = new Color(0.0f, 0.5f, 0.0f);
    protected final Color MAXIMUM_COLOR = new Color(0.9f, 0.0f, 0.0f);
    protected final Color AVERAGE_COLOR = new Color(0.0f, 0.0f, 0.75f);
    protected final Color INCOMING_COLOR = Color.black;
    protected final int NUMBERS_TO_DISPLAY = 4;
    protected final boolean FILL_UP_WITH_ZEROS = false;
    private transient SplineGraph graph = null;
    private JLabel minimumLabel = null;
    private JLabel maximumLabel = null;
    private JLabel averageLabel = null;
    private JLabel incomingLabel = null;
    private JLabel minimumNumberLabel = null;
    private JLabel maximumNumberLabel = null;
    private JLabel averageNumberLabel = null;
    private JLabel incomingNumberLabel = null;
    private transient SplineModel model = new SplineModel();

    public SplineVisualizer() {
        this.graph = new SplineGraph();
        this.model.setListener(this);
        this.setGUI();
    }

    public void add(final SampleResult res) {
        JMeterUtils.runSafe((boolean)false, (Runnable)new Runnable(){

            @Override
            public void run() {
                SplineVisualizer.this.model.add(res);
            }
        });
    }

    public String getLabelResource() {
        return "spline_visualizer_title";
    }

    @Override
    public void updateGui(Sample s) {
        this.updateGui();
    }

    public void clearData() {
        this.model.clearData();
    }

    private void setGUI() {
        Color backColor = this.BACKGROUND_COLOR;
        this.setBackground(backColor);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        mainPanel.add(this.makeTitlePanel());
        this.maximumLabel = new JLabel(JMeterUtils.getResString((String)"spline_visualizer_maximum"));
        this.maximumLabel.setForeground(this.MAXIMUM_COLOR);
        this.maximumLabel.setBackground(backColor);
        this.averageLabel = new JLabel(JMeterUtils.getResString((String)"spline_visualizer_average"));
        this.averageLabel.setForeground(this.AVERAGE_COLOR);
        this.averageLabel.setBackground(backColor);
        this.incomingLabel = new JLabel(JMeterUtils.getResString((String)"spline_visualizer_incoming"));
        this.incomingLabel.setForeground(this.INCOMING_COLOR);
        this.incomingLabel.setBackground(backColor);
        this.minimumLabel = new JLabel(JMeterUtils.getResString((String)"spline_visualizer_minimum"));
        this.minimumLabel.setForeground(this.MINIMUM_COLOR);
        this.minimumLabel.setBackground(backColor);
        this.maximumNumberLabel = new JLabel("0 ms");
        this.maximumNumberLabel.setHorizontalAlignment(4);
        this.maximumNumberLabel.setForeground(this.MAXIMUM_COLOR);
        this.maximumNumberLabel.setBackground(backColor);
        this.averageNumberLabel = new JLabel("0 ms");
        this.averageNumberLabel.setHorizontalAlignment(4);
        this.averageNumberLabel.setForeground(this.AVERAGE_COLOR);
        this.averageNumberLabel.setBackground(backColor);
        this.incomingNumberLabel = new JLabel("0 ms");
        this.incomingNumberLabel.setHorizontalAlignment(4);
        this.incomingNumberLabel.setForeground(this.INCOMING_COLOR);
        this.incomingNumberLabel.setBackground(backColor);
        this.minimumNumberLabel = new JLabel("0 ms");
        this.minimumNumberLabel.setHorizontalAlignment(4);
        this.minimumNumberLabel.setForeground(this.MINIMUM_COLOR);
        this.minimumNumberLabel.setBackground(backColor);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        labelPanel.setBackground(backColor);
        labelPanel.add(this.maximumLabel);
        labelPanel.add(this.averageLabel);
        this.model.getClass();
        labelPanel.add(this.incomingLabel);
        labelPanel.add(this.minimumLabel);
        JPanel numberPanel = new JPanel();
        numberPanel.setLayout(new GridLayout(0, 1));
        numberPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        numberPanel.setBackground(backColor);
        numberPanel.add(this.maximumNumberLabel);
        numberPanel.add(this.averageNumberLabel);
        this.model.getClass();
        numberPanel.add(this.incomingNumberLabel);
        numberPanel.add(this.minimumNumberLabel);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.add((Component)labelPanel, "Center");
        infoPanel.add((Component)numberPanel, "East");
        this.add(mainPanel, "North");
        this.add(infoPanel, "West");
        this.add(this.graph, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGui() {
        this.repaint();
        SplineVisualizer splineVisualizer = this;
        synchronized (splineVisualizer) {
            this.setMinimum(this.model.getMinimum());
            this.setMaximum(this.model.getMaximum());
            this.setAverage(this.model.getAverage());
            this.setIncoming(this.model.getCurrent());
        }
    }

    public String toString() {
        return "Show the samples analysis as a Spline curve";
    }

    private String formatMeasureToDisplay(long measure) {
        String numberString = String.valueOf(measure);
        return numberString;
    }

    private void setMinimum(long n) {
        String text = this.formatMeasureToDisplay(n) + SUFFIX_MS;
        this.minimumNumberLabel.setText(text);
    }

    private void setMaximum(long n) {
        String text = this.formatMeasureToDisplay(n) + SUFFIX_MS;
        this.maximumNumberLabel.setText(text);
    }

    private void setAverage(long n) {
        String text = this.formatMeasureToDisplay(n) + SUFFIX_MS;
        this.averageNumberLabel.setText(text);
    }

    private void setIncoming(long n) {
        String text = this.formatMeasureToDisplay(n) + SUFFIX_MS;
        this.incomingNumberLabel.setText(text);
    }

    public JPanel getControlPanel() {
        return this;
    }

    public Image getImage() {
        Image result = this.graph.createImage(this.graph.getWidth(), this.graph.getHeight());
        this.graph.paintComponent(result.getGraphics());
        return result;
    }

    public class SplineGraph
    extends JComponent {
        private static final long serialVersionUID = 240L;
        private final Color WAITING_COLOR = Color.darkGray;
        private int lastWidth = -1;
        private int lastHeight = -1;
        private int[] plot = null;

        public void clear() {
            this.lastWidth = -1;
            this.lastHeight = -1;
            this.plot = null;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dimension = this.getSize();
            int width = dimension.width;
            int height = dimension.height;
            if (SplineVisualizer.this.model.getDataCurve() == null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
                g.setColor(this.WAITING_COLOR);
                g.drawString(JMeterUtils.getResString((String)"spline_visualizer_waitingmessage"), (width - 120) / 2, height - (height - 12) / 2);
                return;
            }
            if (width != this.lastWidth || height != this.lastHeight) {
                this.lastWidth = width;
                this.lastHeight = height;
            }
            this.plot = SplineVisualizer.this.model.getDataCurve().getPlots(width, height);
            int n = this.plot.length;
            int curY = this.plot[0];
            for (int i = 1; i < n; ++i) {
                g.setColor(Color.black);
                g.drawLine(i - 1, height - curY - 1, i, height - this.plot[i] - 1);
                curY = this.plot[i];
            }
        }
    }
}

