/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;

public class AssertionVisualizer
extends AbstractVisualizer
implements Clearable {
    private static final long serialVersionUID = 240L;
    private JTextArea textArea;

    public AssertionVisualizer() {
        this.init();
        this.setName(this.getStaticLabel());
    }

    public String getLabelResource() {
        return "assertion_visualizer_title";
    }

    public void add(SampleResult sample) {
        final StringBuilder sb = new StringBuilder(100);
        sb.append(sample.getSampleLabel());
        sb.append(this.getAssertionResult(sample));
        sb.append("\n");
        JMeterUtils.runSafe((boolean)false, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JTextArea jTextArea = AssertionVisualizer.this.textArea;
                synchronized (jTextArea) {
                    AssertionVisualizer.this.textArea.append(sb.toString());
                    AssertionVisualizer.this.textArea.setCaretPosition(AssertionVisualizer.this.textArea.getText().length());
                }
            }
        });
    }

    public void clearData() {
        this.textArea.setText("");
    }

    private String getAssertionResult(SampleResult res) {
        if (res != null) {
            AssertionResult[] assertionResults;
            StringBuilder display = new StringBuilder();
            for (AssertionResult item : assertionResults = res.getAssertionResults()) {
                if (!item.isFailure() && !item.isError()) continue;
                display.append("\n\t");
                display.append(item.getName() != null ? item.getName() + " : " : "");
                display.append(item.getFailureMessage());
            }
            return display.toString();
        }
        return "";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        this.setBorder(margin);
        this.add(this.makeTitlePanel(), "North");
        JLabel textAreaLabel = new JLabel(JMeterUtils.getResString((String)"assertion_textarea_label"));
        Box mainPanel = Box.createVerticalBox();
        mainPanel.add(textAreaLabel);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(false);
        JScrollPane areaScrollPane = new JScrollPane(this.textArea);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setHorizontalScrollBarPolicy(30);
        areaScrollPane.setPreferredSize(new Dimension(mainPanel.getWidth(), mainPanel.getHeight()));
        mainPanel.add(areaScrollPane);
        this.add(mainPanel, "Center");
    }
}

