/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.LongProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.w3c.tidy.Node;
import org.w3c.tidy.Tidy;

public class HTMLAssertion
extends AbstractTestElement
implements Serializable,
Assertion {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DEFAULT_DOCTYPE = "omit";
    public static final String DOCTYPE_KEY = "html_assertion_doctype";
    public static final String ERRORS_ONLY_KEY = "html_assertion_errorsonly";
    public static final String ERROR_THRESHOLD_KEY = "html_assertion_error_threshold";
    public static final String WARNING_THRESHOLD_KEY = "html_assertion_warning_threshold";
    public static final String FORMAT_KEY = "html_assertion_format";
    public static final String FILENAME_KEY = "html_assertion_filename";

    public HTMLAssertion() {
        log.debug("HTMLAssertion(): called");
    }

    public AssertionResult getResult(SampleResult inResponse) {
        log.debug("HTMLAssertions.getResult() called");
        AssertionResult result = new AssertionResult(this.getName());
        if (inResponse.getResponseData().length == 0) {
            return result.setResultForNull();
        }
        result.setFailure(false);
        Tidy tidy = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("HTMLAssertions.getResult(): Setup tidy ...");
                log.debug("doctype: " + this.getDoctype());
                log.debug("errors only: " + this.isErrorsOnly());
                log.debug("error threshold: " + this.getErrorThreshold());
                log.debug("warning threshold: " + this.getWarningThreshold());
                log.debug("html mode: " + this.isHTML());
                log.debug("xhtml mode: " + this.isXHTML());
                log.debug("xml mode: " + this.isXML());
            }
            tidy = new Tidy();
            tidy.setInputEncoding("UTF8");
            tidy.setOutputEncoding("UTF8");
            tidy.setQuiet(false);
            tidy.setShowWarnings(true);
            tidy.setOnlyErrors(this.isErrorsOnly());
            tidy.setDocType(this.getDoctype());
            if (this.isXHTML()) {
                tidy.setXHTML(true);
            } else if (this.isXML()) {
                tidy.setXmlTags(true);
            }
            tidy.setErrfile(this.getFilename());
            if (log.isDebugEnabled()) {
                log.debug("err file: " + this.getFilename());
                log.debug("getParser : tidy parser created - " + tidy);
                log.debug("HTMLAssertions.getResult(): Tidy instance created!");
            }
        }
        catch (Exception e) {
            log.error("Unable to instantiate tidy parser", (Throwable)e);
            result.setFailure(true);
            result.setFailureMessage("Unable to instantiate tidy parser");
            return result;
        }
        try {
            log.debug("HTMLAssertions.getResult(): start parsing with tidy ...");
            StringWriter errbuf = new StringWriter();
            tidy.setErrout(new PrintWriter(errbuf));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            log.debug("Start : parse");
            Node node = tidy.parse((InputStream)new ByteArrayInputStream(inResponse.getResponseData()), (OutputStream)os);
            if (log.isDebugEnabled()) {
                log.debug("node : " + node);
                log.debug("End   : parse");
                log.debug("HTMLAssertions.getResult(): parsing with tidy done!");
                log.debug("Output: " + os.toString());
            }
            this.writeOutput(errbuf.toString());
            if ((long)tidy.getParseErrors() > this.getErrorThreshold() || !this.isErrorsOnly() && (long)tidy.getParseWarnings() > this.getWarningThreshold()) {
                if (log.isDebugEnabled()) {
                    log.debug("HTMLAssertions.getResult(): errors/warnings detected:");
                    log.debug(errbuf.toString());
                }
                result.setFailure(true);
                result.setFailureMessage(MessageFormat.format("Tidy Parser errors:   " + tidy.getParseErrors() + " (allowed " + this.getErrorThreshold() + ") " + "Tidy Parser warnings: " + tidy.getParseWarnings() + " (allowed " + this.getWarningThreshold() + ")", new Object[0]));
            } else if (tidy.getParseErrors() > 0 || tidy.getParseWarnings() > 0) {
                log.debug("HTMLAssertions.getResult(): there were errors/warnings but threshold to high");
                result.setFailure(false);
            } else {
                log.debug("HTMLAssertions.getResult(): no errors/warnings detected:");
                result.setFailure(false);
            }
        }
        catch (Exception e) {
            log.warn("Cannot parse result content", (Throwable)e);
            result.setFailure(true);
            result.setFailureMessage(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOutput(String inOutput) {
        String lFilename = this.getFilename();
        if (lFilename != null && !"".equals(lFilename.trim())) {
            FileWriter lOutputWriter;
            block5: {
                lOutputWriter = null;
                try {
                    lOutputWriter = new FileWriter(lFilename, false);
                    lOutputWriter.write(inOutput);
                    lOutputWriter.flush();
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("writeOutput() -> output successfully written to file " + lFilename);
                }
                catch (IOException ex) {
                    try {
                        log.warn("writeOutput() -> could not write output to file " + lFilename, (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(lOutputWriter);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Writer)lOutputWriter);
                }
            }
            IOUtils.closeQuietly((Writer)lOutputWriter);
        }
    }

    public String getDoctype() {
        return this.getPropertyAsString(DOCTYPE_KEY);
    }

    public boolean isErrorsOnly() {
        return this.getPropertyAsBoolean(ERRORS_ONLY_KEY);
    }

    public long getErrorThreshold() {
        return this.getPropertyAsLong(ERROR_THRESHOLD_KEY);
    }

    public long getWarningThreshold() {
        return this.getPropertyAsLong(WARNING_THRESHOLD_KEY);
    }

    public void setDoctype(String inDoctype) {
        if (inDoctype == null || inDoctype.trim().isEmpty()) {
            this.setProperty((JMeterProperty)new StringProperty(DOCTYPE_KEY, DEFAULT_DOCTYPE));
        } else {
            this.setProperty((JMeterProperty)new StringProperty(DOCTYPE_KEY, inDoctype));
        }
    }

    public void setErrorsOnly(boolean inErrorsOnly) {
        this.setProperty((JMeterProperty)new BooleanProperty(ERRORS_ONLY_KEY, inErrorsOnly));
    }

    public void setErrorThreshold(long inErrorThreshold) {
        if (inErrorThreshold < 0L) {
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"argument_must_not_be_negative"));
        }
        if (inErrorThreshold == Long.MAX_VALUE) {
            this.setProperty((JMeterProperty)new LongProperty(ERROR_THRESHOLD_KEY, 0L));
        } else {
            this.setProperty((JMeterProperty)new LongProperty(ERROR_THRESHOLD_KEY, inErrorThreshold));
        }
    }

    public void setWarningThreshold(long inWarningThreshold) {
        if (inWarningThreshold < 0L) {
            throw new IllegalArgumentException(JMeterUtils.getResString((String)"argument_must_not_be_negative"));
        }
        if (inWarningThreshold == Long.MAX_VALUE) {
            this.setProperty((JMeterProperty)new LongProperty(WARNING_THRESHOLD_KEY, 0L));
        } else {
            this.setProperty((JMeterProperty)new LongProperty(WARNING_THRESHOLD_KEY, inWarningThreshold));
        }
    }

    public void setHTML() {
        this.setProperty((JMeterProperty)new LongProperty(FORMAT_KEY, 0L));
    }

    public boolean isHTML() {
        return this.getPropertyAsLong(FORMAT_KEY) == 0L;
    }

    public void setXHTML() {
        this.setProperty((JMeterProperty)new LongProperty(FORMAT_KEY, 1L));
    }

    public boolean isXHTML() {
        return this.getPropertyAsLong(FORMAT_KEY) == 1L;
    }

    public void setXML() {
        this.setProperty((JMeterProperty)new LongProperty(FORMAT_KEY, 2L));
    }

    public boolean isXML() {
        return this.getPropertyAsLong(FORMAT_KEY) == 2L;
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME_KEY);
    }

    public void setFilename(String inName) {
        this.setProperty(FILENAME_KEY, inName);
    }
}

