/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterEntities {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterEntities.class);
    public static final String PACKAGE_PREFIX_KEY = "isis.persistor.datanucleus.RegisterEntities.packagePrefix";
    private final boolean appManifestSpecified;
    private final List<String> domPackages;
    private final Set<String> entityTypes;

    public List<String> getDomPackages() {
        return this.domPackages;
    }

    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    public RegisterEntities(Map<String, String> configuration) {
        String packagePrefixes = configuration.get(PACKAGE_PREFIX_KEY);
        if (Strings.isNullOrEmpty((String)packagePrefixes)) {
            throw new IllegalArgumentException(String.format("Could not locate '%s' key in property files - aborting", PACKAGE_PREFIX_KEY));
        }
        this.domPackages = RegisterEntities.parseDomPackages(packagePrefixes);
        this.appManifestSpecified = configuration.get("isis.appManifest") != null;
        this.entityTypes = RegisterEntities.scanForEntityTypesIn(this.domPackages, this.appManifestSpecified);
    }

    private static List<String> parseDomPackages(String packagePrefixes) {
        return Collections.unmodifiableList(Lists.newArrayList((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").split((CharSequence)packagePrefixes), RegisterEntities.trim())));
    }

    private static Set<String> scanForEntityTypesIn(List<String> domPackages, boolean appManifestSpecified) {
        LinkedHashSet entityTypes = Sets.newLinkedHashSet();
        Set persistenceCapableTypes = AppManifest.Registry.instance().getPersistenceCapableTypes();
        if (persistenceCapableTypes == null) {
            persistenceCapableTypes = Sets.newLinkedHashSet();
            for (String packageName : domPackages) {
                Reflections reflections = new Reflections(packageName, new Scanner[0]);
                Set entityTypesInPackage = reflections.getTypesAnnotatedWith(PersistenceCapable.class);
                if (!RegisterEntities.entitiesIn(entityTypesInPackage)) {
                    throw new IllegalArgumentException(String.format("Bad configuration.\n\nCould not locate any @PersistenceCapable entities in package '%s'\nCheck value of '%s' key in WEB-INF/*.properties\n", packageName, PACKAGE_PREFIX_KEY));
                }
                persistenceCapableTypes.addAll(entityTypesInPackage);
            }
        }
        for (Class persistenceCapableType : persistenceCapableTypes) {
            if (RegisterEntities.ignore(persistenceCapableType)) continue;
            entityTypes.add(persistenceCapableType.getCanonicalName());
        }
        return entityTypes;
    }

    private static boolean ignore(Class<?> entityType) {
        try {
            if (entityType.isAnonymousClass() || entityType.isLocalClass() || entityType.isMemberClass()) {
                return true;
            }
            PersistenceCapable persistenceCapable = entityType.getAnnotation(PersistenceCapable.class);
            return persistenceCapable == null;
        }
        catch (NoClassDefFoundError ex) {
            return true;
        }
    }

    private static Function<String, String> trim() {
        return new Function<String, String>(){

            public String apply(String input) {
                return input.trim();
            }
        };
    }

    private static boolean entitiesIn(Set<Class<?>> entityTypes) {
        return Iterables.filter(entityTypes, RegisterEntities.notNullClass()).iterator().hasNext();
    }

    private static <T> Predicate<T> notNullClass() {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return input != null;
            }
        };
    }

    SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

