/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.spi;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;

public final class ResolveStateUtil {
    private ResolveStateUtil() {
    }

    public static void moveToResolving(ObjectAdapter adapter) {
        ResolveStateUtil.moveUpToResolving(adapter);
    }

    public static void markAsResolved(ObjectAdapter adapter) {
        ResolveStateUtil.moveUpToResolving(adapter);
        if (adapter.isResolving()) {
            adapter.changeState(ResolveState.RESOLVED);
        } else if (!adapter.isResolved() && adapter.isUpdating()) {
            adapter.changeState(ResolveState.RESOLVED);
        }
    }

    private static void moveUpToResolving(ObjectAdapter adapter) {
        if (adapter.isTransient()) {
            adapter.changeState(ResolveState.RESOLVED);
            adapter.changeState(ResolveState.GHOST);
            adapter.changeState(ResolveState.RESOLVING);
        } else if (adapter.isNew()) {
            adapter.changeState(ResolveState.GHOST);
            adapter.changeState(ResolveState.RESOLVING);
        } else if (adapter.isGhost()) {
            adapter.changeState(ResolveState.RESOLVING);
        }
    }

    public static void markAsGhost(ObjectAdapter adapter) {
        if (adapter.isValue()) {
            // empty if block
        }
        if (adapter.isDestroyed()) {
            // empty if block
        }
        if (adapter.isTransient()) {
            adapter.changeState(ResolveState.RESOLVED);
            adapter.changeState(ResolveState.GHOST);
        } else if (adapter.isNew()) {
            adapter.changeState(ResolveState.GHOST);
        } else if (adapter.isResolving()) {
            adapter.changeState(ResolveState.RESOLVED);
            adapter.changeState(ResolveState.GHOST);
        } else if (adapter.isUpdating()) {
            adapter.changeState(ResolveState.RESOLVED);
            adapter.changeState(ResolveState.GHOST);
        } else if (adapter.isResolved()) {
            adapter.changeState(ResolveState.GHOST);
        } else if (adapter.isGhost()) {
            // empty if block
        }
    }

    public static void markAsUpdating(ObjectAdapter adapter) {
        if (adapter.isTransient()) {
            adapter.changeState(ResolveState.RESOLVED);
        }
        if (adapter.isResolved()) {
            adapter.changeState(ResolveState.UPDATING);
        }
    }
}

