/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.listener.InstanceLifecycleListener;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusPersistenceMechanismInstaller;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusPropertiesAware;
import org.apache.isis.objectstore.jdo.datanucleus.PersistenceManagerFactoryAware;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.FrameworkSynchronizer;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.IsisLifecycleListener;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoNamedQuery;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.query.JdoQueryFacet;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.SchemaAwareStoreManager;

public class DataNucleusApplicationComponents
implements ApplicationScopedComponent {
    private static DataNucleusApplicationComponents instance;
    private boolean stale = false;
    private final Set<String> persistableClassNameSet;
    private final IsisConfiguration jdoObjectstoreConfig;
    private final Map<String, String> datanucleusProps;
    private final IsisLifecycleListener lifecycleListener;
    private final FrameworkSynchronizer synchronizer;
    private Map<String, JdoNamedQuery> namedQueryByName;
    private PersistenceManagerFactory persistenceManagerFactory;

    public static MetaDataManager getMetaDataManager() {
        return instance != null ? ((JDOPersistenceManagerFactory)DataNucleusApplicationComponents.instance.persistenceManagerFactory).getNucleusContext().getMetaDataManager() : null;
    }

    public static void markAsStale() {
        if (instance != null) {
            DataNucleusApplicationComponents.instance.stale = true;
        }
    }

    public boolean isStale() {
        return this.stale;
    }

    public DataNucleusApplicationComponents(IsisConfiguration jdoObjectstoreConfig, Map<String, String> datanucleusProps, Set<String> persistableClassNameSet) {
        this.datanucleusProps = datanucleusProps;
        this.persistableClassNameSet = persistableClassNameSet;
        this.jdoObjectstoreConfig = jdoObjectstoreConfig;
        this.synchronizer = new FrameworkSynchronizer();
        this.lifecycleListener = new IsisLifecycleListener(this.synchronizer);
        this.initialize();
        instance = this;
    }

    private void initialize() {
        this.persistenceManagerFactory = this.createPmfAndSchemaIfRequired(this.persistableClassNameSet, this.datanucleusProps);
        this.namedQueryByName = DataNucleusApplicationComponents.catalogNamedQueries(this.persistableClassNameSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSchemaAwareStoreManager(Map<String, String> datanucleusProps) {
        try (JDOPersistenceManagerFactory probePmf = (JDOPersistenceManagerFactory)JDOHelper.getPersistenceManagerFactory(datanucleusProps);){
            PersistenceNucleusContext nucleusContext = probePmf.getNucleusContext();
            StoreManager storeManager = nucleusContext.getStoreManager();
            boolean bl = storeManager instanceof SchemaAwareStoreManager;
            return bl;
        }
    }

    private PersistenceManagerFactory createPmfAndSchemaIfRequired(Set<String> persistableClassNameSet, Map<String, String> datanucleusProps) {
        PersistenceManagerFactory persistenceManagerFactory;
        if (DataNucleusApplicationComponents.isSchemaAwareStoreManager(datanucleusProps)) {
            boolean createSchema = this.isSet(datanucleusProps, "datanucleus.schema.autoCreateAll");
            if (createSchema) {
                datanucleusProps.put("datanucleus.schema.autoCreateAll", "false");
                datanucleusProps.put("datanucleus.schema.autoCreateSchema", "false");
                datanucleusProps.put("datanucleus.schema.autoCreateTables", "true");
                datanucleusProps.put("datanucleus.schema.autoCreateColumns", "true");
                datanucleusProps.put("datanucleus.schema.autoCreateConstraints", "true");
                persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory(datanucleusProps);
                this.createSchema(persistenceManagerFactory, persistableClassNameSet, datanucleusProps);
            } else {
                persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory(datanucleusProps);
            }
        } else {
            this.configureAutoStart(persistableClassNameSet, datanucleusProps);
            persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory(this.datanucleusProps);
        }
        return persistenceManagerFactory;
    }

    private void configureAutoStart(Set<String> persistableClassNameSet, Map<String, String> datanucleusProps) {
        String persistableClassNames = Joiner.on((char)',').join(persistableClassNameSet);
        datanucleusProps.put("datanucleus.autoStartMechanism", "Classes");
        datanucleusProps.put("datanucleus.autoStartMechanismMode", "Checked");
        datanucleusProps.put("datanucleus.autoStartClassNames", persistableClassNames);
    }

    private void createSchema(PersistenceManagerFactory persistenceManagerFactory, Set<String> persistableClassNameSet, Map<String, String> datanucleusProps) {
        JDOPersistenceManagerFactory jdopmf = (JDOPersistenceManagerFactory)persistenceManagerFactory;
        PersistenceNucleusContext nucleusContext = jdopmf.getNucleusContext();
        SchemaAwareStoreManager schemaAwareStoreManager = (SchemaAwareStoreManager)nucleusContext.getStoreManager();
        MetaDataManager metaDataManager = nucleusContext.getMetaDataManager();
        this.registerMetadataListener(metaDataManager, persistenceManagerFactory, datanucleusProps);
        schemaAwareStoreManager.createSchemaForClasses(persistableClassNameSet, DataNucleusApplicationComponents.asProperties(datanucleusProps));
    }

    private boolean isSet(Map<String, String> props, String key) {
        return Boolean.parseBoolean(props.get(key));
    }

    private void registerMetadataListener(MetaDataManager metaDataManager, PersistenceManagerFactory persistenceManagerFactory, Map<String, String> datanucleusProps) {
        MetaDataListener listener = this.createMetaDataListener();
        if (listener == null) {
            return;
        }
        if (listener instanceof PersistenceManagerFactoryAware) {
            ((PersistenceManagerFactoryAware)listener).setPersistenceManagerFactory(persistenceManagerFactory);
        }
        if (listener instanceof DataNucleusPropertiesAware) {
            ((DataNucleusPropertiesAware)listener).setDataNucleusProperties(datanucleusProps);
        }
        metaDataManager.registerListener(listener);
    }

    private MetaDataListener createMetaDataListener() {
        String classMetadataListenerClassName = this.jdoObjectstoreConfig.getString("classMetadataLoadedListener", DataNucleusPersistenceMechanismInstaller.CLASS_METADATA_LOADED_LISTENER_DEFAULT);
        return classMetadataListenerClassName != null ? (MetaDataListener)InstanceUtil.createInstance((String)classMetadataListenerClassName, MetaDataListener.class) : null;
    }

    private static Properties asProperties(Map<String, String> props) {
        Properties properties = new Properties();
        properties.putAll(props);
        return properties;
    }

    private static Map<String, JdoNamedQuery> catalogNamedQueries(Set<String> persistableClassNames) {
        HashMap namedQueryByName = Maps.newHashMap();
        for (String persistableClassName : persistableClassNames) {
            ObjectSpecification spec = IsisContext.getSpecificationLoader().loadSpecification(persistableClassName);
            JdoQueryFacet facet = (JdoQueryFacet)spec.getFacet(JdoQueryFacet.class);
            if (facet == null) continue;
            for (JdoNamedQuery namedQuery : facet.getNamedQueries()) {
                namedQueryByName.put(namedQuery.getName(), namedQuery);
            }
        }
        return namedQueryByName;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void init() {
    }

    public void shutdown() {
    }

    public FrameworkSynchronizer getFrameworkSynchronizer() {
        return this.synchronizer;
    }

    public PersistenceManager createPersistenceManager() {
        PersistenceManager persistenceManager = this.persistenceManagerFactory.getPersistenceManager();
        persistenceManager.addInstanceLifecycleListener((InstanceLifecycleListener)this.lifecycleListener, (Class[])null);
        return persistenceManager;
    }

    public JdoNamedQuery getNamedQuery(String queryName) {
        return this.namedQueryByName.get(queryName);
    }

    public void suspendListener() {
        this.lifecycleListener.setSuspended(true);
    }

    public void resumeListener() {
        this.lifecycleListener.setSuspended(false);
    }
}

