/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.viewer.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.lang.MapUtil;
import org.apache.isis.core.runtime.viewer.web.FilterSpecification;
import org.apache.isis.core.runtime.viewer.web.ServletSpecification;

public final class WebAppSpecification {
    private Map<String, String> contextParams = new LinkedHashMap<String, String>();
    private final List<Class<?>> servletContextListeners = new ArrayList();
    private final List<ServletSpecification> servletSpecifications = new ArrayList<ServletSpecification>();
    private final List<FilterSpecification> filterSpecifications = new ArrayList<FilterSpecification>();
    private final List<String> resourcePaths = new ArrayList<String>();
    private final List<String> welcomeFiles = new ArrayList<String>();
    private String logHint;

    public void addContextParams(String ... contextParams) {
        this.contextParams = MapUtil.asMap((Object[])contextParams);
    }

    public Map<String, String> getContextParams() {
        return Collections.unmodifiableMap(this.contextParams);
    }

    public void addServletContextListener(Class<?> servletContextListenerClass) {
        this.servletContextListeners.add(servletContextListenerClass);
    }

    public List<Class<?>> getServletContextListeners() {
        return this.servletContextListeners;
    }

    public void addServletSpecification(Class<?> servletClass, String ... pathSpecs) {
        this.servletSpecifications.add(new ServletSpecification(servletClass, pathSpecs));
    }

    public void addServletSpecification(Class<?> servletClass, Map<String, String> initParams, String ... pathSpecs) {
        this.servletSpecifications.add(new ServletSpecification(servletClass, initParams, pathSpecs));
    }

    public List<ServletSpecification> getServletSpecifications() {
        return this.servletSpecifications;
    }

    public void addFilterSpecification(Class<?> filterClass, String ... pathSpecs) {
        this.filterSpecifications.add(new FilterSpecification(filterClass, pathSpecs));
    }

    public void addFilterSpecification(Class<?> filterClass, Map<String, String> initParams, String ... pathSpecs) {
        this.filterSpecifications.add(new FilterSpecification(filterClass, initParams, pathSpecs));
    }

    public List<FilterSpecification> getFilterSpecifications() {
        return this.filterSpecifications;
    }

    public void addResourcePath(String path) {
        this.resourcePaths.add(path);
    }

    public List<String> getResourcePaths() {
        return this.resourcePaths;
    }

    public void addWelcomeFile(String path) {
        this.welcomeFiles.add(path);
    }

    public List<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public String getLogHint() {
        return this.logHint;
    }

    public void setLogHint(String logHint) {
        this.logHint = logHint;
    }
}

