/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import java.util.Collection;
import java.util.List;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.FacetDecoratorInstaller;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.runtime.authentication.AuthenticationManagerInstaller;
import org.apache.isis.core.runtime.authorization.AuthorizationManagerInstaller;
import org.apache.isis.core.runtime.installerregistry.InstallerLookup;
import org.apache.isis.core.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.core.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.core.runtime.services.ServicesInstaller;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProviderAbstract;
import org.apache.isis.core.runtime.transaction.facetdecorator.standard.TransactionFacetDecoratorInstaller;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IsisComponentProviderUsingInstallers
extends IsisComponentProviderAbstract {
    private final InstallerLookup installerLookup;
    private ObjectReflectorInstaller reflectorInstaller;
    private PersistenceMechanismInstaller persistenceMechanismInstaller;

    public IsisComponentProviderUsingInstallers(DeploymentType deploymentType, AppManifest appManifestIfAny, InstallerLookup installerLookup) {
        super(deploymentType, IsisComponentProviderUsingInstallers.appManifestIfAny(appManifestIfAny, installerLookup));
        Ensure.ensureThatArg((Object)deploymentType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)installerLookup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.installerLookup = installerLookup;
        if (this.appManifest != null) {
            this.putAppManifestKey(this.appManifest);
            this.registerPackageNames(this.appManifest);
            this.specifyServicesAndRegisteredEntitiesUsing(this.appManifest);
            this.putConfigurationProperty("isis.services-installer", "configuration-and-annotation");
            String authenticationMechanism = this.appManifest.getAuthenticationMechanism();
            this.putConfigurationProperty("isis.authentication", authenticationMechanism);
            String authorizationMechanism = this.appManifest.getAuthorizationMechanism();
            this.putConfigurationProperty("isis.authorization", authorizationMechanism);
            List fixtureClasses = this.appManifest.getFixtures();
            String fixtureClassNamesCsv = this.classNamesFrom(fixtureClasses);
            this.putConfigurationProperty("isis.fixtures", fixtureClassNamesCsv);
            this.overrideConfigurationUsing(this.appManifest);
        }
        AuthenticationManagerInstaller authenticationInstaller = this.installerLookup.authenticationManagerInstaller(this.configProperty("isis.authentication"));
        AuthorizationManagerInstaller authorizationInstaller = this.installerLookup.authorizationManagerInstaller(this.configProperty("isis.authorization"));
        this.fixturesInstaller = this.installerLookup.fixturesInstaller(this.configProperty("isis.fixtures-installer"));
        ServicesInstaller servicesInstaller = this.installerLookup.servicesInstaller(null);
        this.persistenceMechanismInstaller = this.installerLookup.persistenceMechanismInstaller(this.configProperty("isis.persistor"));
        this.reflectorInstaller = this.installerLookup.reflectorInstaller(this.configProperty("isis.reflector"));
        TransactionFacetDecoratorInstaller transactionFacetDecoratorInstaller = this.installerLookup.getInstaller(TransactionFacetDecoratorInstaller.class);
        Ensure.ensureThatState((Object)authenticationInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"authenticationInstaller could not be looked up");
        Ensure.ensureThatState((Object)authorizationInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"authorizationInstaller could not be looked up");
        Ensure.ensureThatState((Object)servicesInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"servicesInstaller could not be looked up");
        Ensure.ensureThatState((Object)this.fixturesInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"fixtureInstaller could not be looked up");
        Ensure.ensureThatState((Object)((Object)transactionFacetDecoratorInstaller), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"transactionFacetDecoratorInstaller could not be looked up");
        Ensure.ensureThatState((Object)this.persistenceMechanismInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistenceMechanismInstaller could not be looked up");
        Ensure.ensureThatState((Object)this.reflectorInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"reflectorInstaller could not be looked up");
        this.reflectorInstaller.addFacetDecoratorInstaller((FacetDecoratorInstaller)transactionFacetDecoratorInstaller);
        this.configuration = this.installerLookup.getConfiguration();
        this.authenticationManager = authenticationInstaller.createAuthenticationManager();
        this.authorizationManager = authorizationInstaller.createAuthorizationManager();
        this.services = servicesInstaller.getServices();
        this.ensureInitialized();
    }

    private static AppManifest appManifestIfAny(AppManifest appManifestFromConstructor, InstallerLookup installerLookup) {
        if (appManifestFromConstructor != null) {
            return appManifestFromConstructor;
        }
        String appManifestFromConfiguration = installerLookup.getConfiguration().getString("isis.appManifest");
        return appManifestFromConfiguration != null ? (AppManifest)InstanceUtil.createInstance((String)appManifestFromConfiguration, AppManifest.class) : null;
    }

    @Override
    protected void doPutConfigurationProperty(String key, String value) {
        this.installerLookup.putConfigurationProperty(key, value);
    }

    @Override
    public SpecificationLoaderSpi provideSpecificationLoaderSpi(Collection<MetaModelRefiner> metaModelRefiners) {
        return this.reflectorInstaller.createReflector(metaModelRefiners);
    }

    @Override
    public PersistenceSessionFactory providePersistenceSessionFactory(DeploymentType deploymentType, ServicesInjectorSpi servicesInjectorSpi, RuntimeContextFromSession runtimeContext) {
        return this.persistenceMechanismInstaller.createPersistenceSessionFactory(deploymentType, servicesInjectorSpi, this.getConfiguration(), runtimeContext);
    }

    private String configProperty(String key) {
        return this.installerLookup.getConfiguration().getString(key);
    }
}

