/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.transaction;

import java.util.List;
import java.util.UUID;
import org.apache.isis.applib.annotation.Bulk;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.command.CommandDefault;
import org.apache.isis.applib.services.command.spi.CommandService;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.TransactionalResource;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureWithReturn;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisTransactionManager
implements SessionScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IsisTransactionManager.class);
    private final PersistenceSession persistenceSession;
    private int transactionLevel;
    private IsisSession session;
    private IsisTransaction transaction;
    private final TransactionalResource transactionalResource;
    private final ServicesInjector servicesInjector;

    public IsisTransactionManager(PersistenceSession persistenceSession, TransactionalResource transactionalResource, ServicesInjector servicesInjector) {
        this.persistenceSession = persistenceSession;
        this.transactionalResource = transactionalResource;
        this.servicesInjector = servicesInjector;
    }

    public void open() {
        Ensure.ensureThatState((Object)this.session, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"session is required");
    }

    public void close() {
        if (this.getTransaction() != null) {
            try {
                this.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error("failure during abort", (Throwable)e2);
            }
        }
        this.session = null;
    }

    public IsisTransaction getTransaction() {
        return this.transaction;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    protected MessageBroker getMessageBroker() {
        return this.getTransaction().getMessageBroker();
    }

    public void executeWithinTransaction(TransactionalClosure closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            closure.preExecute();
            closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                try {
                    this.abortTransaction();
                }
                catch (Exception e) {
                    LOG.error("Abort failure after exception", (Throwable)e);
                    throw new IsisTransactionManagerException("Abort failure: " + e.getMessage(), ex);
                }
            } else {
                this.getTransaction().setAbortCause(new IsisException((Throwable)ex));
            }
            throw ex;
        }
    }

    public <Q> Q executeWithinTransaction(TransactionalClosureWithReturn<Q> closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            closure.preExecute();
            Q retVal = closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
            return retVal;
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                this.abortTransaction();
            } else {
                this.getTransaction().setAbortCause(new IsisException((Throwable)ex));
            }
            throw ex;
        }
    }

    public boolean inTransaction() {
        return this.getTransaction() != null && !this.getTransaction().getState().isComplete();
    }

    protected final IsisTransaction createTransaction() {
        MessageBroker messageBroker = this.createMessageBroker();
        this.transaction = this.createTransaction(messageBroker, this.transactionalResource);
        return this.transaction;
    }

    private IsisTransaction createTransaction(MessageBroker messageBroker, TransactionalResource transactionalResource) {
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        return new IsisTransaction(this, messageBroker, transactionalResource, this.servicesInjector);
    }

    public synchronized void startTransaction() {
        boolean noneInProgress = false;
        if (this.getTransaction() == null || this.getTransaction().getState().isComplete()) {
            noneInProgress = true;
            this.startRequestOnRequestScopedServices();
            this.createCommandIfConfigured();
            this.initOtherApplibServicesIfConfigured();
            IsisTransaction isisTransaction = this.createTransaction();
            this.transactionLevel = 0;
            this.transactionalResource.startTransaction();
            this.startTransactionOnCommandIfConfigured(isisTransaction.getTransactionId());
        }
        ++this.transactionLevel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("startTransaction: level " + (this.transactionLevel - 1) + "->" + this.transactionLevel + (noneInProgress ? " (no transaction in progress or was previously completed; transaction created)" : ""));
        }
    }

    private void initOtherApplibServicesIfConfigured() {
        Bulk.InteractionContext bic = this.getServiceOrNull(Bulk.InteractionContext.class);
        if (bic != null) {
            Bulk.InteractionContext.current.set(bic);
        }
    }

    private void startRequestOnRequestScopedServices() {
        List registeredServices = this.servicesInjector.getRegisteredServices();
        for (Object service : registeredServices) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_startRequest(this.servicesInjector);
        }
        for (Object service : registeredServices) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_postConstruct();
        }
    }

    private void endRequestOnRequestScopeServices() {
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_preDestroy();
        }
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            if (!(service instanceof RequestScopedService)) continue;
            ((RequestScopedService)service).__isis_endRequest();
        }
    }

    private void createCommandIfConfigured() {
        CommandContext commandContext = this.getServiceOrNull(CommandContext.class);
        if (commandContext == null) {
            return;
        }
        CommandService commandService = this.getServiceOrNull(CommandService.class);
        Command command = commandService != null ? commandService.create() : new CommandDefault();
        commandContext.setCommand(command);
        if (command.getTimestamp() == null) {
            command.setTimestamp(Clock.getTimeAsJavaSqlTimestamp());
        }
        if (command.getUser() == null) {
            command.setUser(this.getAuthenticationSession().getUserName());
        }
    }

    public void startTransactionOnCommandIfConfigured(UUID transactionId) {
        CommandContext commandContext = this.getServiceOrNull(CommandContext.class);
        if (commandContext == null) {
            return;
        }
        CommandService commandService = this.getServiceOrNull(CommandService.class);
        if (commandService == null) {
            return;
        }
        Command command = commandContext.getCommand();
        commandService.startTransaction(command, transactionId);
    }

    public <T> T getServiceOrNull(Class<T> serviceType) {
        return (T)this.servicesInjector.lookupService(serviceType);
    }

    public synchronized boolean flushTransaction() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushTransaction");
        }
        if (this.getTransaction() != null) {
            this.persistenceSession.objectChangedAllDirty();
            this.getTransaction().flush();
        }
        return false;
    }

    public synchronized void endTransaction() {
        IsisTransaction transaction;
        if (LOG.isDebugEnabled()) {
            LOG.debug("endTransaction: level " + this.transactionLevel + "->" + (this.transactionLevel - 1));
        }
        if ((transaction = this.getTransaction()) == null || transaction.getState().isComplete()) {
            return;
        }
        Object abortCause = this.getTransaction().getAbortCause();
        if (transaction.getState().mustAbort()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("endTransaction: aborting instead [EARLY TERMINATION], abort cause '" + ((Throwable)abortCause).getMessage() + "' has been set");
            }
            try {
                this.abortTransaction();
                abortCause = this.getTransaction().getAbortCause();
            }
            catch (RuntimeException ex) {
                abortCause = ex;
            }
            if (abortCause != null) {
                throw abortCause;
            }
            return;
        }
        --this.transactionLevel;
        if (this.transactionLevel == 0) {
            if (abortCause == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("endTransaction: committing");
                }
                try {
                    this.persistenceSession.objectChangedAllDirty();
                }
                catch (RuntimeException ex) {
                    abortCause = ex;
                    this.transactionLevel = 1;
                }
            }
            if (abortCause == null) {
                try {
                    this.getTransaction().preCommit();
                }
                catch (RuntimeException ex) {
                    abortCause = ex;
                    this.transactionLevel = 1;
                }
            }
            if (abortCause == null) {
                try {
                    this.transactionalResource.endTransaction();
                }
                catch (RuntimeException ex) {
                    abortCause = ex;
                    this.transactionLevel = 1;
                    this.getTransaction().setAbortCause(new IsisTransactionManagerException(ex));
                }
            }
            if (abortCause == null) {
                try {
                    this.getTransaction().commit();
                }
                catch (RuntimeException ex) {
                    abortCause = ex;
                    this.transactionLevel = 1;
                }
            }
            this.endRequestOnRequestScopeServices();
            if (abortCause != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("endTransaction: aborting instead, abort cause has been set");
                }
                try {
                    this.abortTransaction();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                throw abortCause;
            }
        } else if (this.transactionLevel < 0) {
            LOG.error("endTransaction: transactionLevel=" + this.transactionLevel);
            this.transactionLevel = 0;
            throw new IllegalStateException(" no transaction running to end (transactionLevel < 0)");
        }
    }

    public synchronized void abortTransaction() {
        if (this.getTransaction() != null) {
            this.getTransaction().markAsAborted();
            this.transactionLevel = 0;
            this.transactionalResource.abortTransaction();
        }
    }

    public void addCommand(PersistenceCommand command) {
        this.getTransaction().addCommand(command);
    }

    protected MessageBroker createMessageBroker() {
        return MessageBroker.acquire((AuthenticationSession)this.getAuthenticationSession());
    }

    protected void ensureTransactionInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)true), (String)"No transaction in progress");
    }

    protected void ensureTransactionNotInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)false), (String)"Transaction in progress");
    }

    public void debugData(DebugBuilder debug) {
        debug.appendln("Transaction", (Object)this.getTransaction());
    }

    public IsisSession getSession() {
        return this.session;
    }

    public void setSession(IsisSession session) {
        this.session = session;
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected AdapterManager getAdapterManager() {
        return IsisContext.getPersistenceSession().getAdapterManager();
    }

    protected OidMarshaller getOidMarshaller() {
        return IsisContext.getOidMarshaller();
    }
}

