/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.session;

import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSessionFactory
implements ApplicationScopedComponent {
    private static final Logger LOG = LoggerFactory.getLogger(IsisSessionFactory.class);
    private final DeploymentType deploymentType;
    private final IsisConfiguration configuration;
    private final SpecificationLoaderSpi specificationLoaderSpi;
    private final AuthenticationManager authenticationManager;
    private final AuthorizationManager authorizationManager;
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final OidMarshaller oidMarshaller;

    public IsisSessionFactory(DeploymentType deploymentType, IsisConfiguration configuration, SpecificationLoaderSpi specificationLoader, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager, PersistenceSessionFactory persistenceSessionFactory) {
        Ensure.ensureThatArg((Object)deploymentType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authenticationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authorizationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)persistenceSessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.deploymentType = deploymentType;
        this.configuration = configuration;
        this.specificationLoaderSpi = specificationLoader;
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
        this.persistenceSessionFactory = persistenceSessionFactory;
        this.oidMarshaller = new OidMarshaller();
    }

    public void init() {
        ServicesInjectorSpi servicesInjector = this.persistenceSessionFactory.getServicesInjector();
        this.specificationLoaderSpi.setServiceInjector(servicesInjector);
        this.specificationLoaderSpi.init();
        this.specificationLoaderSpi.injectInto((Object)this.persistenceSessionFactory);
        this.authenticationManager.init();
        this.authorizationManager.init();
        this.persistenceSessionFactory.init();
    }

    public void shutdown() {
        this.persistenceSessionFactory.shutdown();
        this.authenticationManager.shutdown();
        this.specificationLoaderSpi.shutdown();
    }

    public IsisSession openSession(AuthenticationSession authenticationSession) {
        PersistenceSession persistenceSession = this.persistenceSessionFactory.createPersistenceSession();
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.getSpecificationLoader().injectInto((Object)persistenceSession);
        return this.newIsisSession(authenticationSession, persistenceSession);
    }

    protected IsisSession newIsisSession(AuthenticationSession authenticationSession, PersistenceSession persistenceSession) {
        return new IsisSession(this, authenticationSession, persistenceSession);
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public SpecificationLoaderSpi getSpecificationLoader() {
        return this.specificationLoaderSpi;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }

    public List<Object> getServices() {
        return this.getPersistenceSessionFactory().getServicesInjector().getRegisteredServices();
    }

    public OidMarshaller getOidMarshaller() {
        return this.oidMarshaller;
    }
}

