/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.persistence.ObjectStoreFactory;
import org.apache.isis.core.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.ObjectStore;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSessionFactory
implements MetaModelRefiner,
ApplicationScopedComponent,
FixturesInstalledFlag {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceSessionFactory.class);
    private final DeploymentType deploymentType;
    private final IsisConfiguration configuration;
    private final ObjectStoreFactory objectStoreFactory;
    private Boolean fixturesInstalled;
    private final ServicesInjectorSpi servicesInjector;
    private RuntimeContextFromSession runtimeContext;

    public PersistenceSessionFactory(DeploymentType deploymentType, ServicesInjectorSpi servicesInjector, IsisConfiguration isisConfiguration, ObjectStoreFactory objectStoreFactory, RuntimeContextFromSession runtimeContext) {
        Ensure.ensureThatState((Object)deploymentType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)servicesInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState((Object)isisConfiguration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)objectStoreFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)((Object)runtimeContext), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.deploymentType = deploymentType;
        this.configuration = isisConfiguration;
        this.objectStoreFactory = objectStoreFactory;
        this.servicesInjector = servicesInjector;
        this.runtimeContext = runtimeContext;
    }

    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public ObjectStoreFactory getDelegate() {
        return this.objectStoreFactory;
    }

    public PersistenceSession createPersistenceSession() {
        ObjectStore objectStore = this.objectStoreFactory.createObjectStore(this.getConfiguration());
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        return new PersistenceSession(this, objectStore, this.getConfiguration());
    }

    public final void init() {
        if (!this.deploymentType.isProduction() && !Clock.isInitialized()) {
            FixtureClock.initialize();
        }
        this.runtimeContext.injectInto(this.servicesInjector);
        this.getSpecificationLoader().injectInto((Object)this.runtimeContext);
        for (Object service : this.servicesInjector.getRegisteredServices()) {
            this.runtimeContext.injectInto(service);
        }
        this.servicesInjector.init();
    }

    public final void shutdown() {
        this.doShutdown();
    }

    protected void doShutdown() {
    }

    public ServicesInjectorSpi getServicesInjector() {
        return this.servicesInjector;
    }

    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        this.objectStoreFactory.refineMetaModelValidator(metaModelValidator, configuration);
    }

    public void refineProgrammingModel(ProgrammingModel baseProgrammingModel, IsisConfiguration configuration) {
        this.objectStoreFactory.refineProgrammingModel(baseProgrammingModel, configuration);
    }

    @Override
    public Boolean isFixturesInstalled() {
        return this.fixturesInstalled;
    }

    @Override
    public void setFixturesInstalled(Boolean fixturesInstalled) {
        this.fixturesInstalled = fixturesInstalled;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

