/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.query.Query;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Assert;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.facets.object.immutable.ImmutableFacetUtils;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.FreeStandingList;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.persistence.NotPersistableException;
import org.apache.isis.core.runtime.persistence.adapter.PojoAdapterFactory;
import org.apache.isis.core.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.apache.isis.core.runtime.persistence.adaptermanager.PojoRecreatorUnified;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithmUnified;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.IdentifierGeneratorUnified;
import org.apache.isis.core.runtime.system.persistence.ObjectFactory;
import org.apache.isis.core.runtime.system.persistence.ObjectStore;
import org.apache.isis.core.runtime.system.persistence.OidGenerator;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceQueryFactory;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureAbstract;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosureWithReturnAbstract;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSession
implements SessionScopedComponent,
DebuggableWithTitle {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceSession.class);
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final ObjectAdapterFactory objectAdapterFactory;
    private final OidGenerator oidGenerator;
    private final AdapterManagerDefault adapterManager;
    private final PersistAlgorithm persistAlgorithm;
    private final ObjectStore objectStore;
    private final Map<ObjectSpecId, RootOid> servicesByObjectType = Maps.newHashMap();
    private final PersistenceQueryFactory persistenceQueryFactory;
    private IsisTransactionManager transactionManager;
    private boolean dirtiableSupport = true;
    private State state;
    private Map<Oid, Oid> persistentByTransient = Maps.newHashMap();

    public PersistenceSession(PersistenceSessionFactory persistenceSessionFactory, ObjectStore objectStore, IsisConfiguration configuration) {
        Ensure.ensureThatArg((Object)persistenceSessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistence session factory required");
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"object store required");
        this.persistenceSessionFactory = persistenceSessionFactory;
        this.objectAdapterFactory = new PojoAdapterFactory();
        this.oidGenerator = new OidGenerator(new IdentifierGeneratorUnified(configuration));
        this.adapterManager = new AdapterManagerDefault(new PojoRecreatorUnified(configuration));
        this.persistAlgorithm = new PersistAlgorithmUnified(configuration);
        this.objectStore = objectStore;
        this.persistenceQueryFactory = new PersistenceQueryFactory((SpecificationLoader)this.getSpecificationLoader(), this.adapterManager);
        this.transactionManager = new IsisTransactionManager(this, objectStore, (ServicesInjector)persistenceSessionFactory.getServicesInjector());
        this.setState(State.NOT_INITIALIZED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating " + this);
        }
    }

    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }

    public void open() {
        this.ensureNotOpened();
        if (LOG.isDebugEnabled()) {
            LOG.debug("opening " + this);
        }
        Ensure.ensureThatState((Object)this.transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"TransactionManager missing");
        ServicesInjectorSpi servicesInjector = this.persistenceSessionFactory.getServicesInjector();
        servicesInjector.injectInto((Object)this.objectFactory);
        servicesInjector.injectInto((Object)this.adapterManager);
        this.adapterManager.open();
        Ensure.ensureThatState((Object)this.objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"object store required");
        Ensure.ensureThatState((Object)this.getTransactionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"transaction manager required");
        Ensure.ensureThatState((Object)this.persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"persist algorithm required");
        this.getAdapterManager().injectInto(this.objectStore);
        this.getSpecificationLoader().injectInto((Object)this.objectStore);
        this.objectStore.open();
        this.initServices();
        this.setState(State.OPEN);
    }

    private void initServices() {
        List registeredServices = this.persistenceSessionFactory.getServicesInjector().getRegisteredServices();
        this.createServiceAdapters(registeredServices);
    }

    private void createServiceAdapters(List<Object> registeredServices) {
        for (Object service : registeredServices) {
            ObjectAdapter serviceAdapter;
            ObjectSpecification serviceSpecification = this.getSpecificationLoader().loadSpecification(service.getClass());
            serviceSpecification.markAsService();
            RootOid existingOid = this.getOidForService(serviceSpecification);
            ObjectAdapter objectAdapter = serviceAdapter = existingOid == null ? this.getAdapterManager().adapterFor(service) : this.getAdapterManager().mapRecreatedPojo((Oid)existingOid, service);
            if (serviceAdapter.getOid().isTransient()) {
                this.adapterManager.remapAsPersistent(serviceAdapter, null);
            }
            serviceAdapter.markAsResolvedIfPossible();
            if (existingOid != null) continue;
            RootOid persistentOid = (RootOid)serviceAdapter.getOid();
            this.registerService(persistentOid);
        }
    }

    public <T> T getServiceOrNull(Class<T> serviceType) {
        return (T)this.persistenceSessionFactory.getServicesInjector().lookupService(serviceType);
    }

    public void close() {
        if (this.getState() == State.CLOSED) {
            return;
        }
        try {
            try {
                this.objectStore.close();
            }
            catch (Throwable ex) {
                LOG.error("objectStore#close() failed while closing the session; continuing to avoid memory leakage");
            }
            try {
                this.adapterManager.close();
            }
            catch (Throwable ex) {
                LOG.error("adapterManager#close() failed while closing the session; continuing to avoid memory leakage");
            }
        }
        finally {
            this.setState(State.CLOSED);
        }
    }

    private State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    protected void ensureNotOpened() {
        if (this.getState() != State.NOT_INITIALIZED) {
            throw new IllegalStateException("Persistence session has already been initialized");
        }
    }

    public ObjectAdapter createTransientInstance(ObjectSpecification objectSpec) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating transient instance of " + objectSpec);
        }
        Object pojo = objectSpec.createObject();
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(pojo);
        return objectSpec.initialize(adapter);
    }

    public ObjectAdapter createViewModelInstance(ObjectSpecification objectSpec, String memento) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating view model instance of " + objectSpec);
        }
        Object pojo = objectSpec.createObject();
        ViewModelFacet facet = (ViewModelFacet)objectSpec.getFacet(ViewModelFacet.class);
        facet.initialize(pojo, memento);
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(pojo);
        return objectSpec.initialize(adapter);
    }

    public ObjectAdapter createAggregatedInstance(ObjectSpecification objectSpec, ObjectAdapter parentAdapter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("creating aggregated instance of " + objectSpec);
        }
        Object pojo = objectSpec.createObject();
        ObjectAdapter adapter = this.getAdapterManager().adapterFor(pojo, parentAdapter);
        objectSpec.initialize(adapter);
        if (adapter.isGhost()) {
            adapter.changeState(ResolveState.RESOLVING);
            adapter.changeState(ResolveState.RESOLVED);
        }
        return adapter;
    }

    public <T> ObjectAdapter findInstances(Query<T> query, QueryCardinality cardinality) {
        PersistenceQuery persistenceQuery = this.createPersistenceQueryFor(query, cardinality);
        if (persistenceQuery == null) {
            throw new IllegalArgumentException("Unknown query type: " + query.getDescription());
        }
        return this.findInstances(persistenceQuery);
    }

    public ObjectAdapter findInstances(PersistenceQuery persistenceQuery) {
        List<ObjectAdapter> instances = this.getInstances(persistenceQuery);
        ObjectSpecification specification = persistenceQuery.getSpecification();
        FreeStandingList results = new FreeStandingList(specification, instances);
        return this.getAdapterManager().adapterFor(results);
    }

    protected final PersistenceQuery createPersistenceQueryFor(Query<?> query, QueryCardinality cardinality) {
        return this.persistenceQueryFactory.createPersistenceQueryFor(query, cardinality);
    }

    protected List<ObjectAdapter> getInstances(PersistenceQuery persistenceQuery) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getInstances matching " + persistenceQuery);
        }
        return this.getInstancesFromPersistenceLayer(persistenceQuery);
    }

    private List<ObjectAdapter> getInstancesFromPersistenceLayer(final PersistenceQuery persistenceQuery) {
        return this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<List<ObjectAdapter>>(){

            @Override
            public List<ObjectAdapter> execute() {
                return PersistenceSession.this.objectStore.loadInstancesAndAdapt(persistenceQuery);
            }

            @Override
            public void onSuccess() {
                PersistenceSession.this.clearAllDirty();
            }
        });
    }

    public boolean isCheckObjectsForDirtyFlag() {
        return this.dirtiableSupport;
    }

    public void objectChangedAllDirty() {
        if (!this.dirtiableSupport) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("marking as changed any objects that have been manually set as dirty");
        }
        for (ObjectAdapter adapter : this.adapterManager) {
            if (!adapter.getSpecification().isDirty(adapter)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("  found dirty object " + adapter);
            }
            this.objectChanged(adapter);
            adapter.getSpecification().clearDirty(adapter);
        }
    }

    public synchronized void clearAllDirty() {
        if (!this.isCheckObjectsForDirtyFlag()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("cleaning any manually dirtied objects");
        }
        for (ObjectAdapter object : this.adapterManager) {
            if (!object.getSpecification().isDirty(object)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("  found dirty object " + object);
            }
            object.getSpecification().clearDirty(object);
        }
    }

    protected RootOid getOidForService(ObjectSpecification serviceSpec) {
        return this.getOidForServiceFromPersistenceLayer(serviceSpec);
    }

    protected void registerService(RootOid rootOid) {
        this.objectStore.registerService(rootOid);
    }

    public List<ObjectAdapter> getServices() {
        List services = this.persistenceSessionFactory.getServicesInjector().getRegisteredServices();
        ArrayList serviceAdapters = Lists.newArrayList();
        for (Object servicePojo : services) {
            serviceAdapters.add(this.getService(servicePojo));
        }
        return serviceAdapters;
    }

    private ObjectAdapter getService(Object servicePojo) {
        ObjectSpecification serviceSpecification = this.getSpecificationLoader().loadSpecification(servicePojo.getClass());
        RootOid oid = this.getOidForService(serviceSpecification);
        ObjectAdapter serviceAdapter = this.getAdapterManager().mapRecreatedPojo((Oid)oid, servicePojo);
        serviceAdapter.markAsResolvedIfPossible();
        return serviceAdapter;
    }

    private RootOid getOidForServiceFromPersistenceLayer(ObjectSpecification serviceSpecification) {
        ObjectSpecId objectSpecId = serviceSpecification.getSpecId();
        RootOid oid = this.servicesByObjectType.get(objectSpecId);
        if (oid == null) {
            oid = this.objectStore.getOidForService(serviceSpecification);
            this.servicesByObjectType.put(objectSpecId, oid);
        }
        return oid;
    }

    public boolean isFixturesInstalled() {
        PersistenceSessionFactory persistenceSessionFactory = this.getPersistenceSessionFactory();
        if (persistenceSessionFactory.isFixturesInstalled() == null) {
            persistenceSessionFactory.setFixturesInstalled(this.objectStore.isFixturesInstalled());
        }
        return persistenceSessionFactory.isFixturesInstalled();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug("finalizing persistence session");
    }

    public ObjectAdapter loadObject(TypedOid oid) {
        Ensure.ensureThatArg((Object)oid, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ObjectAdapter adapter = this.getAdapterManager().getAdapterFor((Oid)oid);
        if (adapter != null) {
            return adapter;
        }
        return this.loadMappedObjectFromObjectStore(oid);
    }

    private ObjectAdapter loadMappedObjectFromObjectStore(final TypedOid oid) {
        ObjectAdapter adapter = this.getTransactionManager().executeWithinTransaction(new TransactionalClosureWithReturnAbstract<ObjectAdapter>(){

            @Override
            public ObjectAdapter execute() {
                return PersistenceSession.this.objectStore.loadInstanceAndAdapt(oid);
            }
        });
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveImmediately(ObjectAdapter adapter) {
        AuthenticationSession authenticationSession = this.getAuthenticationSession();
        synchronized (authenticationSession) {
            if (!adapter.canTransitionToResolving()) {
                return;
            }
            Assert.assertFalse((String)"only resolve object that is not yet resolved", (Object)adapter, (boolean)adapter.isResolved());
            Assert.assertTrue((String)"only resolve object that is persistent", (Object)adapter, (boolean)adapter.representsPersistent());
            this.resolveImmediatelyFromPersistenceLayer(adapter);
            if (LOG.isDebugEnabled()) {
                LOG.debug("resolved: " + adapter.getSpecification().getShortIdentifier() + " " + adapter.getResolveState().code() + " " + adapter.getOid());
            }
        }
    }

    private void resolveImmediatelyFromPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
            }

            @Override
            public void execute() {
                PersistenceSession.this.objectStore.resolveImmediately(adapter);
            }

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        });
    }

    public void makePersistent(ObjectAdapter adapter) {
        if (adapter.representsPersistent()) {
            throw new NotPersistableException("Object already persistent: " + adapter);
        }
        if (!adapter.getSpecification().persistability().isPersistable()) {
            throw new NotPersistableException("Object is not persistable: " + adapter);
        }
        ObjectSpecification specification = adapter.getSpecification();
        if (specification.isService()) {
            throw new NotPersistableException("Cannot persist services: " + adapter);
        }
        this.makePersistentInPersistenceLayer(adapter);
    }

    protected void makePersistentInPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
            }

            @Override
            public void execute() {
                PersistenceSession.this.persistAlgorithm.makePersistent(adapter, PersistenceSession.this);
                PersistenceSession.this.persistentByTransient.clear();
            }

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        });
    }

    public void objectChanged(ObjectAdapter adapter) {
        if (adapter.isTransient() || adapter.isParented() && adapter.getAggregateRoot().isTransient()) {
            return;
        }
        if (adapter.respondToChangesInPersistentObjects()) {
            if (this.isImmutable(adapter)) {
                return;
            }
            this.addObjectChangedForPersistenceLayer(adapter);
        }
    }

    private void addObjectChangedForPersistenceLayer(final ObjectAdapter adapter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("object change to be persisted " + adapter.getOid());
        }
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
            }

            @Override
            public void execute() {
                SaveObjectCommand saveObjectCommand = PersistenceSession.this.objectStore.createSaveObjectCommand(adapter);
                PersistenceSession.this.getTransactionManager().addCommand(saveObjectCommand);
            }

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        });
    }

    public void destroyObject(ObjectAdapter adapter) {
        ObjectSpecification spec = adapter.getSpecification();
        if (spec.isParented()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("destroyObject " + adapter);
        }
        this.destroyObjectInPersistenceLayer(adapter);
    }

    private void destroyObjectInPersistenceLayer(final ObjectAdapter adapter) {
        this.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

            @Override
            public void preExecute() {
            }

            @Override
            public void execute() {
                DestroyObjectCommand command = PersistenceSession.this.objectStore.createDestroyObjectCommand(adapter);
                PersistenceSession.this.getTransactionManager().addCommand(command);
            }

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
            }
        });
    }

    public void remapAsPersistent(ObjectAdapter adapter) {
        Oid transientOid = adapter.getOid();
        this.adapterManager.remapAsPersistent(adapter, null);
        Oid persistentOid = adapter.getOid();
        this.persistentByTransient.put(transientOid, persistentOid);
    }

    public Oid remappedFrom(Oid transientOid) {
        return this.persistentByTransient.get(transientOid);
    }

    public void addCreateObjectCommand(ObjectAdapter object) {
        this.getTransactionManager().addCommand(this.objectStore.createCreateObjectCommand(object));
    }

    public String debugTitle() {
        return "Object Store Persistor";
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle(this.getClass().getName());
        debug.appendln();
        this.adapterManager.debugData(debug);
        debug.appendln();
        debug.appendln("manually dirtiable support (isDirty flag)?", this.dirtiableSupport);
        debug.appendTitle("OID Generator");
        this.oidGenerator.debugData(debug);
        debug.appendln();
        debug.appendTitle("Services");
        for (Object servicePojo : this.persistenceSessionFactory.getServicesInjector().getRegisteredServices()) {
            String id = ServiceUtil.id(servicePojo);
            Class<?> serviceClass = servicePojo.getClass();
            ObjectSpecification serviceSpecification = this.getSpecificationLoader().loadSpecification(serviceClass);
            String serviceClassName = serviceClass.getName();
            RootOid oidForService = this.getOidForService(serviceSpecification);
            String serviceId = id + (id.equals(serviceClassName) ? "" : " (" + serviceClassName + ")");
            debug.appendln(oidForService != null ? oidForService.toString() : "[NULL]", (Object)serviceId);
        }
        debug.appendln();
        debug.appendTitle("Persistor");
        this.getTransactionManager().debugData(debug);
        debug.appendln("Persist Algorithm", (Object)this.persistAlgorithm);
        debug.appendln("Object Store", (Object)this.objectStore);
        debug.appendln();
        this.objectStore.debugData(debug);
    }

    public String toString() {
        ToString toString = new ToString((Object)this);
        if (this.objectStore != null) {
            toString.append("objectStore", this.objectStore.name());
        }
        if (this.persistAlgorithm != null) {
            toString.append("persistAlgorithm", this.persistAlgorithm.name());
        }
        return toString.toString();
    }

    protected boolean isImmutable(ObjectAdapter adapter) {
        ObjectSpecification noSpec = adapter.getSpecification();
        return ImmutableFacetUtils.isAlwaysImmutable((ObjectSpecification)noSpec) || ImmutableFacetUtils.isImmutableOncePersisted((ObjectSpecification)noSpec) && adapter.representsPersistent();
    }

    public void testReset() {
        this.objectStore.reset();
        this.adapterManager.reset();
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public final ObjectAdapterFactory getObjectAdapterFactory() {
        return this.objectAdapterFactory;
    }

    public final OidGenerator getOidGenerator() {
        return this.oidGenerator;
    }

    public final AdapterManagerDefault getAdapterManager() {
        return this.adapterManager;
    }

    public ServicesInjectorSpi getServicesInjector() {
        return this.persistenceSessionFactory.getServicesInjector();
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public IsisTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    void setTransactionManager(IsisTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    private static enum State {
        NOT_INITIALIZED,
        OPEN,
        CLOSED;

    }
}

