/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.UUID;
import javax.jdo.PersistenceManager;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facets.object.viewmodel.ViewModelFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;
import org.apache.isis.objectstore.jdo.datanucleus.DataNucleusObjectStore;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.spi.JdoObjectIdSerializer;
import org.datanucleus.enhancement.Persistable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IdentifierGeneratorForDataNucleus
implements IdentifierGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(IdentifierGeneratorForDataNucleus.class);

    IdentifierGeneratorForDataNucleus() {
    }

    @Override
    public String createTransientIdentifierFor(ObjectSpecId objectSpecId, Object pojo) {
        ObjectSpecification spec = this.getSpecificationLoader().lookupBySpecId(objectSpecId);
        ViewModelFacet recreatableObjectFacet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
        if (recreatableObjectFacet != null) {
            return recreatableObjectFacet.memento(pojo);
        }
        return UUID.randomUUID().toString();
    }

    @Override
    public String createAggregateLocalId(ObjectSpecId objectSpecId, Object pojo, ObjectAdapter parentAdapter) {
        return UUID.randomUUID().toString();
    }

    @Override
    public String createPersistentIdentifierFor(ObjectSpecId objectSpecId, Object pojo, RootOid transientRootOid) {
        if (!(pojo instanceof Persistable)) {
            return "1";
        }
        ObjectSpecification spec = this.getSpecificationLoader().lookupBySpecId(objectSpecId);
        if (spec.containsFacet(ViewModelFacet.class)) {
            ViewModelFacet recreatableObjectFacet = (ViewModelFacet)spec.getFacet(ViewModelFacet.class);
            return recreatableObjectFacet.memento(pojo);
        }
        Object jdoOid = this.getJdoPersistenceManager().getObjectId(pojo);
        return JdoObjectIdSerializer.toOidIdentifier(jdoOid);
    }

    @Override
    public <T extends IdentifierGenerator> T underlying(Class<T> cls) {
        return (T)(cls == IdentifierGeneratorForDataNucleus.class ? this : null);
    }

    public String debugTitle() {
        return "DataNucleus Identifier Generator";
    }

    public void debugData(DebugBuilder debug) {
    }

    protected PersistenceManager getJdoPersistenceManager() {
        DataNucleusObjectStore objectStore = this.getDataNucleusObjectStore();
        return objectStore.getPersistenceManager();
    }

    protected DataNucleusObjectStore getDataNucleusObjectStore() {
        return (DataNucleusObjectStore)IsisContext.getPersistenceSession().getObjectStore();
    }

    protected IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }

    protected SpecificationLoader getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

