/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.matchers.IsisMatchers;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IdentifierGeneratorDefault
implements IdentifierGenerator {
    private long persistentSerialNumber;
    private long transientSerialNumber;
    private long aggregatedId;

    public IdentifierGeneratorDefault() {
        this(1L);
    }

    public IdentifierGeneratorDefault(long seed) {
        this(seed, Long.MIN_VALUE + seed);
    }

    public IdentifierGeneratorDefault(Memento memento) {
        this(memento.getPersistentSerialNumber(), memento.getTransientSerialNumber());
    }

    public IdentifierGeneratorDefault(long persistentSerialNumber, long transientSerialNumber) {
        Ensure.ensureThatArg((Object)persistentSerialNumber, (Matcher)CoreMatchers.is((Matcher)IsisMatchers.greaterThan((Comparable)Long.valueOf(0L))));
        this.persistentSerialNumber = persistentSerialNumber;
        this.transientSerialNumber = transientSerialNumber;
    }

    public String name() {
        return "Default Identifier Generator";
    }

    @Override
    public String createAggregateLocalId(ObjectSpecId objectSpecId, Object pojo, ObjectAdapter parentAdapter) {
        return Long.toHexString(this.aggregatedId++);
    }

    @Override
    public String createTransientIdentifierFor(ObjectSpecId objectSpecId, Object pojo) {
        return "" + this.transientSerialNumber--;
    }

    @Override
    public String createPersistentIdentifierFor(ObjectSpecId objectSpecId, Object pojo, RootOid transientRootOid) {
        return "" + this.persistentSerialNumber++;
    }

    @Override
    public <T extends IdentifierGenerator> T underlying(Class<T> cls) {
        return (T)(cls == IdentifierGeneratorDefault.class ? this : null);
    }

    public Memento getMemento() {
        return new Memento(this.persistentSerialNumber, this.transientSerialNumber);
    }

    public void resetTo(Memento memento) {
        this.persistentSerialNumber = memento.getPersistentSerialNumber();
        this.transientSerialNumber = memento.getTransientSerialNumber();
    }

    public void debugData(DebugBuilder debug) {
        debug.appendln("Persistent", this.persistentSerialNumber);
        debug.appendln("Transient", this.transientSerialNumber);
    }

    public String debugTitle() {
        return this.name();
    }

    public static class Memento {
        private final long persistentSerialNumber;
        private final long transientSerialNumber;

        Memento(long persistentSerialNumber, long transientSerialNumber) {
            this.persistentSerialNumber = persistentSerialNumber;
            this.transientSerialNumber = transientSerialNumber;
        }

        public long getTransientSerialNumber() {
            return this.transientSerialNumber;
        }

        public long getPersistentSerialNumber() {
            return this.persistentSerialNumber;
        }
    }
}

