/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.deployment.DeploymentCategoryProvider;
import org.apache.isis.core.runtime.system.ContextCategory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

public class DeploymentType
implements DeploymentCategoryProvider {
    private static List<DeploymentType> deploymentTypes = Lists.newArrayList();
    public static DeploymentType SERVER = new DeploymentType("SERVER", DeploymentCategory.PRODUCTION, ContextCategory.THREADLOCAL);
    public static DeploymentType SERVER_EXPLORATION = new DeploymentType("SERVER_EXPLORATION", DeploymentCategory.EXPLORING, ContextCategory.THREADLOCAL);
    public static DeploymentType SERVER_PROTOTYPE = new DeploymentType("SERVER_PROTOTYPE", DeploymentCategory.PROTOTYPING, ContextCategory.THREADLOCAL);
    public static DeploymentType UNIT_TESTING = new DeploymentType("UNIT_TESTING", DeploymentCategory.PRODUCTION, ContextCategory.STATIC_RELAXED);
    private final String name;
    private final DeploymentCategory deploymentCategory;
    private final ContextCategory contextCategory;

    public static DeploymentType lookup(String str) {
        String underscoredStr = str.replace('-', '_').toUpperCase();
        for (DeploymentType deploymentType : deploymentTypes) {
            if (!underscoredStr.equals(deploymentType.name())) continue;
            return deploymentType;
        }
        throw new IllegalArgumentException(String.format("Unknown deployment type '%s'", str));
    }

    public DeploymentType(String name, DeploymentCategory category, ContextCategory contextCategory) {
        this.deploymentCategory = category;
        this.contextCategory = contextCategory;
        this.name = name;
        deploymentTypes.add(this);
    }

    public DebuggableWithTitle getDebug() {
        return new DebuggableWithTitle(){

            public void debugData(DebugBuilder debug) {
                debug.appendln("Category", (Object)DeploymentType.this.deploymentCategory);
                debug.appendln("Context", (Object)DeploymentType.this.contextCategory);
                debug.appendln();
                debug.appendln("Name", (Object)DeploymentType.this.friendlyName());
                debug.appendln("Should monitor", DeploymentType.this.shouldMonitor());
            }

            public String debugTitle() {
                return "Deployment type";
            }
        };
    }

    public void initContext(IsisSessionFactory sessionFactory) {
        this.contextCategory.initContext(sessionFactory);
    }

    public boolean shouldMonitor() {
        return this == SERVER && this.isProduction();
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    public boolean isExploring() {
        return this.deploymentCategory.isExploring();
    }

    public boolean isPrototyping() {
        return this.deploymentCategory.isPrototyping();
    }

    public boolean isProduction() {
        return this.deploymentCategory.isProduction();
    }

    public String friendlyName() {
        return this.nameLowerCase().replace('_', '-');
    }

    public String nameLowerCase() {
        return this.name().toLowerCase();
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }
}

