/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system;

import java.util.List;
import org.apache.isis.core.runtime.system.context.IsisContextStatic;
import org.apache.isis.core.runtime.system.context.IsisContextThreadLocal;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

public abstract class ContextCategory {
    public static ContextCategory STATIC_RELAXED = new ContextCategory(){

        @Override
        public void initContext(IsisSessionFactory sessionFactory) {
            IsisContextStatic.createRelaxedInstance(sessionFactory);
        }

        @Override
        public boolean canSpecifyViewers(List<String> viewers) {
            return viewers.size() <= 1;
        }
    };
    public static ContextCategory STATIC = new ContextCategory(){

        @Override
        public void initContext(IsisSessionFactory sessionFactory) {
            IsisContextStatic.createInstance(sessionFactory);
        }

        @Override
        public boolean canSpecifyViewers(List<String> viewers) {
            return viewers.size() == 1;
        }
    };
    public static ContextCategory THREADLOCAL = new ContextCategory(){

        @Override
        public void initContext(IsisSessionFactory sessionFactory) {
            IsisContextThreadLocal.createInstance(sessionFactory);
        }

        @Override
        public boolean canSpecifyViewers(List<String> viewers) {
            return true;
        }
    };

    public abstract void initContext(IsisSessionFactory var1);

    public abstract boolean canSpecifyViewers(List<String> var1);
}

