/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.snapshot;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.runtime.snapshot.XmlSchema;
import org.apache.isis.core.runtime.snapshot.XmlSnapshot;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

public class XmlSnapshotBuilder {
    private final Object domainObject;
    private XmlSchema schema;
    private OidMarshaller oidMarshaller = new OidMarshaller();
    private final List<PathAndAnnotation> paths = Lists.newArrayList();

    public XmlSnapshotBuilder(Object domainObject) {
        this.domainObject = domainObject;
    }

    public XmlSnapshotBuilder usingSchema(XmlSchema schema) {
        this.schema = schema;
        return this;
    }

    public XmlSnapshotBuilder usingOidMarshaller(OidMarshaller oidMarshaller) {
        this.oidMarshaller = oidMarshaller;
        return this;
    }

    public XmlSnapshotBuilder includePath(String path) {
        return this.includePathAndAnnotation(path, null);
    }

    public XmlSnapshotBuilder includePathAndAnnotation(String path, String annotation) {
        this.paths.add(new PathAndAnnotation(path, annotation));
        return this;
    }

    public XmlSnapshot build() {
        ObjectAdapter adapter = XmlSnapshotBuilder.getAdapterManager().adapterFor(this.domainObject);
        XmlSnapshot snapshot = this.schema != null ? new XmlSnapshot(adapter, this.schema, this.oidMarshaller) : new XmlSnapshot(adapter, this.oidMarshaller);
        for (PathAndAnnotation paa : this.paths) {
            if (paa.annotation != null) {
                snapshot.include(paa.path, paa.annotation);
                continue;
            }
            snapshot.include(paa.path);
        }
        return snapshot;
    }

    private static AdapterManager getAdapterManager() {
        return XmlSnapshotBuilder.getPersistenceSession().getAdapterManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    static class PathAndAnnotation {
        private final String path;
        private final String annotation;

        public PathAndAnnotation(String path, String annotation) {
            this.path = path;
            this.annotation = annotation;
        }
    }
}

