/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.i18n.po;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.core.runtime.services.i18n.po.ContextAndMsgId;

class Block {
    State state = State.CONTEXT;
    List<String> contextList = Lists.newArrayList();
    String msgid = null;
    String msgid_plural = null;
    String msgstr = null;
    String msgstr_plural = null;

    Block() {
    }

    Block parseLine(String line, Map<ContextAndMsgId, String> translationsByKey) {
        if (this.state == State.CONTEXT) {
            Matcher contextMatcher = this.state.pattern.matcher(line);
            if (contextMatcher.matches()) {
                String context = contextMatcher.group("value");
                this.contextList.add(context);
                return this;
            }
            this.state = State.MSGID;
        }
        if (this.state == State.MSGID) {
            Matcher msgidMatcher = this.state.pattern.matcher(line);
            if (!msgidMatcher.matches()) {
                return new Block();
            }
            this.msgid = msgidMatcher.group("value");
            this.state = State.MSGID_PLURAL;
            return this;
        }
        if (this.state == State.MSGID_PLURAL) {
            Matcher msgIdPluralMatcher = this.state.pattern.matcher(line);
            if (msgIdPluralMatcher.matches()) {
                this.msgid_plural = msgIdPluralMatcher.group("value");
                this.state = State.MSGSTR0;
                return this;
            }
            this.state = State.MSGSTR;
        }
        if (this.state == State.MSGSTR) {
            Matcher msgStrMatcher = this.state.pattern.matcher(line);
            if (msgStrMatcher.matches()) {
                this.msgstr = msgStrMatcher.group("value");
            }
            this.append(translationsByKey);
            return new Block();
        }
        if (this.state == State.MSGSTR0) {
            Matcher msgStr0Matcher = this.state.pattern.matcher(line);
            if (!msgStr0Matcher.matches()) {
                this.append(translationsByKey);
                return new Block();
            }
            this.msgstr = msgStr0Matcher.group("value");
            this.state = State.MSGSTR1;
            return this;
        }
        if (this.state == State.MSGSTR1) {
            Matcher msgStr1Matcher = this.state.pattern.matcher(line);
            if (msgStr1Matcher.matches()) {
                this.msgstr_plural = msgStr1Matcher.group("value");
            }
            this.append(translationsByKey);
            return new Block();
        }
        return this;
    }

    void append(Map<ContextAndMsgId, String> translationsByKey) {
        for (String context : this.contextList) {
            ContextAndMsgId mc;
            if (this.msgid != null && this.msgstr != null) {
                mc = new ContextAndMsgId(context, this.msgid, ContextAndMsgId.Type.REGULAR);
                translationsByKey.put(mc, this.msgstr);
            }
            if (this.msgid_plural == null || this.msgstr_plural == null) continue;
            mc = new ContextAndMsgId(context, this.msgid_plural, ContextAndMsgId.Type.PLURAL_ONLY);
            translationsByKey.put(mc, this.msgstr_plural);
        }
    }

    private static enum State {
        CONTEXT("^#: (?<value>.+)$"),
        MSGID("^msgid \"(?<value>.+)\"$"),
        MSGID_PLURAL("^msgid_plural \"(?<value>.+)\"$"),
        MSGSTR("^msgstr \"(?<value>.+)\"$"),
        MSGSTR0("^msgstr\\[0\\] \"(?<value>.+)\"$"),
        MSGSTR1("^msgstr\\[1\\] \"(?<value>.+)\"$");

        private final Pattern pattern;

        private State(String regex) {
            this.pattern = Pattern.compile(regex);
        }
    }
}

