/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner.opts;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.NotFoundPolicy;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;

public class OptionHandlerConfiguration
extends OptionHandlerAbstract {
    private String configurationResource;

    public void addOption(Options options) {
        OptionBuilder.withArgName((String)"config file");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"read in configuration file (as well as isis.properties)");
        Option option = OptionBuilder.create((String)"c");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.configurationResource = commandLine.getOptionValue("c");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        if (this.configurationResource == null) {
            return;
        }
        isisConfigurationBuilder.addConfigurationResource(this.configurationResource, NotFoundPolicy.FAIL_FAST);
    }
}

