/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner.opts;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;

public class OptionHandlerAdditionalProperty
extends OptionHandlerAbstract {
    private List<String> additionalProperties;

    public void addOption(Options options) {
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription((String)"use value for given property");
        Option option = OptionBuilder.create((String)"D");
        option.setArgs(-2);
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.additionalProperties = this.getOptionValues(commandLine, "D");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        this.addConfigurationProperties(isisConfigurationBuilder, this.additionalProperties);
    }

    private void addConfigurationProperties(IsisConfigurationBuilder isisConfigurationBuilder, List<String> additionalProperties) {
        if (additionalProperties == null) {
            return;
        }
        String key = null;
        String value = null;
        for (String additionalProperty : additionalProperties) {
            if (key == null) {
                key = additionalProperty;
                continue;
            }
            value = additionalProperty;
            isisConfigurationBuilder.add(key, value);
            key = null;
        }
    }
}

