/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.adaptermanager;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.isis.core.commons.components.Resettable;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoAdapterHashMap
implements DebuggableWithTitle,
Iterable<ObjectAdapter>,
SessionScopedComponent,
Resettable {
    private static final Logger LOG = LoggerFactory.getLogger(PojoAdapterHashMap.class);
    public static final int DEFAULT_POJO_ADAPTER_MAP_SIZE = 100;
    protected final Map<Object, ObjectAdapter> adapterByPojoMap;

    public PojoAdapterHashMap() {
        this(100);
    }

    public PojoAdapterHashMap(int capacity) {
        this.adapterByPojoMap = Maps.newHashMapWithExpectedSize((int)capacity);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug("finalizing hash of pojos");
    }

    public void open() {
    }

    public void close() {
        LOG.debug("close");
        this.adapterByPojoMap.clear();
    }

    public void reset() {
        LOG.debug("reset");
        Iterator<Map.Entry<Object, ObjectAdapter>> iterator = this.adapterByPojoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, ObjectAdapter> entry = iterator.next();
            ObjectAdapter adapter = entry.getValue();
            if (adapter.getSpecification().isService()) continue;
            iterator.remove();
        }
    }

    public void add(Object pojo, ObjectAdapter adapter) {
        this.adapterByPojoMap.put(this.key(pojo), adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("add adapter: #" + this.key(pojo) + " -> #" + Long.toHexString(adapter.hashCode()));
            if (adapter.isResolved() && !(pojo instanceof RequestScopedService)) {
                LOG.debug("add " + new ToString(pojo) + " as " + adapter);
            }
        }
    }

    public void remove(ObjectAdapter object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove adapter: " + object);
        }
        this.adapterByPojoMap.remove(this.key(object.getObject()));
    }

    public boolean containsPojo(Object pojo) {
        return this.adapterByPojoMap.containsKey(this.key(pojo));
    }

    public ObjectAdapter getAdapter(Object pojo) {
        return this.adapterByPojoMap.get(this.key(pojo));
    }

    @Override
    public Iterator<ObjectAdapter> iterator() {
        return this.adapterByPojoMap.values().iterator();
    }

    private Object key(Object pojo) {
        return new IdentityHashKey(pojo);
    }

    public void debugData(DebugBuilder debug) {
        int count = 0;
        HashMap copyForDebug = Maps.newHashMap(this.adapterByPojoMap);
        for (Map.Entry entry : copyForDebug.entrySet()) {
            Object pojo = entry.getKey();
            ObjectAdapter object = (ObjectAdapter)entry.getValue();
            debug.append(count++ + 1, 5);
            debug.append((Object)" '");
            debug.append((Object)pojo.toString(), 50);
            debug.append((Object)"'    ");
            debug.appendln(object.toString());
        }
    }

    public String debugTitle() {
        return "POJO Adapter Hashtable";
    }

    private static class IdentityHashKey {
        private final Object pojo;

        public IdentityHashKey(Object pojo) {
            this.pojo = pojo;
        }

        public int hashCode() {
            return System.identityHashCode(this.pojo);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof IdentityHashKey && ((IdentityHashKey)obj).pojo == this.pojo;
        }
    }
}

