/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.adaptermanager;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.isis.core.commons.components.Resettable;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidAdapterHashMap
implements DebuggableWithTitle,
Iterable<Oid>,
SessionScopedComponent,
Resettable {
    private static final Logger LOG = LoggerFactory.getLogger(OidAdapterHashMap.class);
    public static final int DEFAULT_OID_ADAPTER_MAP_SIZE = 100;
    private final Map<Oid, ObjectAdapter> adapterByOidMap = Maps.newHashMapWithExpectedSize((int)100);

    public void open() {
    }

    public void close() {
        LOG.debug("close");
        this.adapterByOidMap.clear();
    }

    public void reset() {
        LOG.debug("reset");
        Iterator<Map.Entry<Oid, ObjectAdapter>> iterator = this.adapterByOidMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Oid, ObjectAdapter> entry = iterator.next();
            ObjectAdapter adapter = entry.getValue();
            if (adapter.getSpecification().isService()) continue;
            iterator.remove();
        }
    }

    public void add(Oid oid, ObjectAdapter adapter) {
        this.adapterByOidMap.put(oid, adapter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("add oid: " + oid + " ; oid.hashCode: + #" + Long.toHexString(oid.hashCode()) + " ; adapter.hashCode(): #" + Long.toHexString(adapter.hashCode()));
        }
    }

    public boolean remove(Oid oid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove oid: " + oid);
        }
        return this.adapterByOidMap.remove(oid) != null;
    }

    public ObjectAdapter getAdapter(Oid oid) {
        return this.adapterByOidMap.get(oid);
    }

    @Override
    public Iterator<Oid> iterator() {
        return this.adapterByOidMap.keySet().iterator();
    }

    public String debugTitle() {
        return "Identity adapter map";
    }

    public void debugData(DebugBuilder debug) {
        int count = 1;
        HashMap copyForDebug = Maps.newHashMap(this.adapterByOidMap);
        for (Map.Entry entry : copyForDebug.entrySet()) {
            Oid oid = (Oid)entry.getKey();
            ObjectAdapter adapter = (ObjectAdapter)entry.getValue();
            debug.append(count++, 5);
            debug.append((Object)" '");
            debug.append((Object)oid.toString(), 15);
            debug.append((Object)"'    ");
            debug.appendln(adapter != null ? adapter.toString() : "(MISSING OBJECT ?!)");
        }
    }
}

