/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.xds.util.bootstrap;

import io.envoyproxy.envoy.config.core.v3.Node;
import io.grpc.ChannelCredentials;
import io.grpc.internal.JsonParser;
import io.grpc.internal.JsonUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.xds.XdsInitializationException;
import org.apache.dubbo.registry.xds.util.bootstrap.BootstrapInfoImpl;
import org.apache.dubbo.registry.xds.util.bootstrap.Bootstrapper;
import org.apache.dubbo.registry.xds.util.bootstrap.CertificateProviderInfoImpl;
import org.apache.dubbo.registry.xds.util.bootstrap.ServerInfoImpl;

class BootstrapperImpl
extends Bootstrapper {
    static final String BOOTSTRAP_PATH_SYS_ENV_VAR = "GRPC_XDS_BOOTSTRAP";
    static String bootstrapPathFromEnvVar = System.getenv("GRPC_XDS_BOOTSTRAP");
    private static final Logger logger = LoggerFactory.getLogger(BootstrapperImpl.class);
    private FileReader reader = LocalFileReader.INSTANCE;
    private static final String SERVER_FEATURE_XDS_V3 = "xds_v3";
    private static final String SERVER_FEATURE_IGNORE_RESOURCE_DELETION = "ignore_resource_deletion";

    BootstrapperImpl() {
    }

    @Override
    public Bootstrapper.BootstrapInfo bootstrap() throws XdsInitializationException {
        Map rawBootstrap;
        String filePath = bootstrapPathFromEnvVar;
        String fileContent = null;
        if (filePath != null) {
            try {
                fileContent = this.reader.readFile(filePath);
            }
            catch (IOException e) {
                throw new XdsInitializationException("Fail to read bootstrap file", e);
            }
        }
        if (fileContent == null) {
            throw new XdsInitializationException("Cannot find bootstrap configuration");
        }
        try {
            rawBootstrap = (Map)JsonParser.parse(fileContent);
        }
        catch (IOException e) {
            throw new XdsInitializationException("Failed to parse JSON", e);
        }
        return this.bootstrap(rawBootstrap);
    }

    @Override
    Bootstrapper.BootstrapInfo bootstrap(Map<String, ?> rawData) throws XdsInitializationException {
        BootstrapInfoImpl.Builder builder = new BootstrapInfoImpl.Builder();
        List rawServerConfigs = JsonUtil.getList(rawData, (String)"xds_servers");
        if (rawServerConfigs == null) {
            throw new XdsInitializationException("Invalid bootstrap: 'xds_servers' does not exist.");
        }
        List<Bootstrapper.ServerInfo> servers = BootstrapperImpl.parseServerInfos(rawServerConfigs);
        ((Bootstrapper.BootstrapInfo.Builder)builder).servers(servers);
        Node.Builder nodeBuilder = Node.newBuilder();
        Map rawNode = JsonUtil.getObject(rawData, (String)"node");
        if (rawNode != null) {
            String cluster;
            String id = JsonUtil.getString((Map)rawNode, (String)"id");
            if (id != null) {
                nodeBuilder.setId(id);
            }
            if ((cluster = JsonUtil.getString((Map)rawNode, (String)"cluster")) != null) {
                nodeBuilder.setCluster(cluster);
            }
            Map metadata = JsonUtil.getObject((Map)rawNode, (String)"metadata");
            Map map = JsonUtil.getObject((Map)rawNode, (String)"locality");
        }
        ((Bootstrapper.BootstrapInfo.Builder)builder).node(nodeBuilder.build());
        Map certProvidersBlob = JsonUtil.getObject(rawData, (String)"certificate_providers");
        if (certProvidersBlob != null) {
            HashMap<String, Bootstrapper.CertificateProviderInfo> certProviders = new HashMap<String, Bootstrapper.CertificateProviderInfo>(certProvidersBlob.size());
            for (String name : certProvidersBlob.keySet()) {
                Map valueMap = JsonUtil.getObject((Map)certProvidersBlob, (String)name);
                String pluginName = BootstrapperImpl.checkForNull(JsonUtil.getString((Map)valueMap, (String)"plugin_name"), "plugin_name");
                Map config = BootstrapperImpl.checkForNull(JsonUtil.getObject((Map)valueMap, (String)"config"), "config");
                CertificateProviderInfoImpl certificateProviderInfo = new CertificateProviderInfoImpl(pluginName, config);
                certProviders.put(name, certificateProviderInfo);
            }
            ((Bootstrapper.BootstrapInfo.Builder)builder).certProviders(certProviders);
        }
        return ((Bootstrapper.BootstrapInfo.Builder)builder).build();
    }

    private static List<Bootstrapper.ServerInfo> parseServerInfos(List<?> rawServerConfigs) throws XdsInitializationException {
        LinkedList<Bootstrapper.ServerInfo> servers = new LinkedList<Bootstrapper.ServerInfo>();
        List serverConfigList = JsonUtil.checkObjectList(rawServerConfigs);
        for (Map serverConfig : serverConfigList) {
            String serverUri = JsonUtil.getString((Map)serverConfig, (String)"server_uri");
            if (serverUri == null) {
                throw new XdsInitializationException("Invalid bootstrap: missing 'server_uri'");
            }
            List rawChannelCredsList = JsonUtil.getList((Map)serverConfig, (String)"channel_creds");
            if (rawChannelCredsList == null || rawChannelCredsList.isEmpty()) {
                throw new XdsInitializationException("Invalid bootstrap: server " + serverUri + " 'channel_creds' required");
            }
            ChannelCredentials channelCredentials = BootstrapperImpl.parseChannelCredentials(JsonUtil.checkObjectList((List)rawChannelCredsList), serverUri);
            boolean useProtocolV3 = false;
            boolean ignoreResourceDeletion = false;
            List serverFeatures = JsonUtil.getListOfStrings((Map)serverConfig, (String)"server_features");
            if (serverFeatures != null) {
                useProtocolV3 = serverFeatures.contains(SERVER_FEATURE_XDS_V3);
                ignoreResourceDeletion = serverFeatures.contains(SERVER_FEATURE_IGNORE_RESOURCE_DELETION);
            }
            servers.add(new ServerInfoImpl(serverUri, channelCredentials, useProtocolV3, ignoreResourceDeletion));
        }
        return servers;
    }

    void setFileReader(FileReader reader) {
        this.reader = reader;
    }

    private static <T> T checkForNull(T value, String fieldName) throws XdsInitializationException {
        if (value == null) {
            throw new XdsInitializationException("Invalid bootstrap: '" + fieldName + "' does not exist.");
        }
        return value;
    }

    @Nullable
    private static ChannelCredentials parseChannelCredentials(List<Map<String, ?>> jsonList, String serverUri) throws XdsInitializationException {
        return null;
    }

    private static enum LocalFileReader implements FileReader
    {
        INSTANCE;


        @Override
        public String readFile(String path) throws IOException {
            return new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        }
    }

    static interface FileReader {
        public String readFile(String var1) throws IOException;
    }
}

