/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.model;

import java.util.Set;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;
import org.apache.dubbo.spring.security.jackson.ObjectMapperCodec;
import org.apache.dubbo.spring.security.jackson.ObjectMapperCodecCustomer;

@Activate(onClass={"org.springframework.security.core.context.SecurityContextHolder", "org.springframework.security.jackson2.CoreJackson2Module", "com.fasterxml.jackson.databind.ObjectMapper"})
public class SecurityScopeModelInitializer
implements ScopeModelInitializer {
    public void initializeFrameworkModel(FrameworkModel frameworkModel) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        ObjectMapperCodec objectMapperCodec = (ObjectMapperCodec)beanFactory.getOrRegisterBean(ObjectMapperCodec.class);
        Set objectMapperCodecCustomerList = frameworkModel.getExtensionLoader(ObjectMapperCodecCustomer.class).getSupportedExtensionInstances();
        for (ObjectMapperCodecCustomer objectMapperCodecCustomer : objectMapperCodecCustomerList) {
            objectMapperCodecCustomer.customize(objectMapperCodec);
        }
    }

    public void initializeApplicationModel(ApplicationModel applicationModel) {
    }

    public void initializeModuleModel(ModuleModel moduleModel) {
    }
}

